/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorHost {
    @Test
    public void testDoubleLoading() {
        Configuration conf = HBaseConfiguration.create();
        CoprocessorHost<CoprocessorEnvironment> host = new CoprocessorHost<CoprocessorEnvironment>((Abortable)new TestAbortable()){
            final Configuration cpHostConf;
            {
                this.cpHostConf = this.conf;
            }

            public CoprocessorEnvironment createEnvironment(Class<?> implClass, final Coprocessor instance, int priority, int sequence, Configuration conf) {
                return new CoprocessorEnvironment(){
                    final Coprocessor envInstance;
                    {
                        this.envInstance = instance;
                    }

                    public int getVersion() {
                        return 0;
                    }

                    public String getHBaseVersion() {
                        return "0.0.0";
                    }

                    public Coprocessor getInstance() {
                        return this.envInstance;
                    }

                    public int getPriority() {
                        return 0;
                    }

                    public int getLoadSequence() {
                        return 0;
                    }

                    public Configuration getConfiguration() {
                        return cpHostConf;
                    }

                    public HTableInterface getTable(TableName tableName) throws IOException {
                        return null;
                    }

                    public HTableInterface getTable(TableName tableName, ExecutorService service) throws IOException {
                        return null;
                    }

                    public ClassLoader getClassLoader() {
                        return null;
                    }
                };
            }
        };
        String key = "KEY";
        String coprocessor = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        conf.setStrings("KEY", new String[]{"org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver"});
        host.loadSystemCoprocessors(conf, "KEY");
        Assert.assertEquals((long)1L, (long)host.coprocessors.size());
    }

    class TestAbortable
    implements Abortable {
        private volatile boolean aborted = false;

        TestAbortable() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
            Assert.fail();
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

