/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpReceiver;
import org.spark_project.jetty.client.HttpRequest;
import org.spark_project.jetty.client.HttpSender;
import org.spark_project.jetty.client.TimeoutCompleteListener;
import org.spark_project.jetty.client.api.Result;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public abstract class HttpChannel {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final HttpDestination _destination;
    private final TimeoutCompleteListener _totalTimeout;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
        this._totalTimeout = new TimeoutCompleteListener(destination.getHttpClient().getScheduler());
    }

    public void destroy() {
        this._totalTimeout.destroy();
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean associate(HttpExchange exchange) {
        boolean result2 = false;
        boolean abort = true;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            if (this._exchange == null) {
                abort = false;
                result2 = exchange.associate(this);
                if (result2) {
                    this._exchange = exchange;
                }
            }
        }
        if (abort) {
            exchange.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{} associated {} to {}", exchange, result2, this);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disassociate(HttpExchange exchange) {
        boolean result2 = false;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange) {
                existing.disassociate(this);
                result2 = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", exchange, result2, this);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpExchange getHttpExchange() {
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            return this._exchange;
        }
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            HttpRequest request = exchange.getRequest();
            long timeoutAt = request.getTimeoutAt();
            if (timeoutAt != -1L) {
                exchange.getResponseListeners().add(this._totalTimeout);
                this._totalTimeout.schedule(request, timeoutAt);
            }
            this.send(exchange);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange, Throwable failure) {
        this.getHttpSender().proceed(exchange, failure);
    }

    public boolean abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure) {
        boolean requestAborted = false;
        if (requestFailure != null) {
            requestAborted = this.getHttpSender().abort(exchange, requestFailure);
        }
        boolean responseAborted = false;
        if (responseFailure != null) {
            responseAborted = this.abortResponse(exchange, responseFailure);
        }
        return requestAborted || responseAborted;
    }

    public boolean abortResponse(HttpExchange exchange, Throwable failure) {
        return this.getHttpReceiver().abort(exchange, failure);
    }

    public Result exchangeTerminating(HttpExchange exchange, Result result2) {
        return result2;
    }

    public void exchangeTerminated(HttpExchange exchange, Result result2) {
        this.disassociate(exchange);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

