/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusWithUpgradeDomain;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBlockPlacementStatusWithUpgradeDomain {
    private Set<String> upgradeDomains;
    private BlockPlacementStatusDefault bpsd = (BlockPlacementStatusDefault)Mockito.mock(BlockPlacementStatusDefault.class);

    @Before
    public void setup() {
        this.upgradeDomains = new HashSet<String>();
        this.upgradeDomains.add("1");
        this.upgradeDomains.add("2");
        this.upgradeDomains.add("3");
        Mockito.when((Object)this.bpsd.isPlacementPolicySatisfied()).thenReturn((Object)true);
    }

    @Test
    public void testIsPolicySatisfiedParentFalse() {
        Mockito.when((Object)this.bpsd.isPlacementPolicySatisfied()).thenReturn((Object)false);
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assert.assertFalse((boolean)bps.isPlacementPolicySatisfied());
    }

    @Test
    public void testIsPolicySatisfiedAllEqual() {
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 3, 3);
        Assert.assertTrue((boolean)bps.isPlacementPolicySatisfied());
    }

    @Test
    public void testIsPolicySatisifedSmallDomains() {
        BlockPlacementStatusWithUpgradeDomain bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 3);
        Assert.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 2);
        Assert.assertTrue((boolean)bps.isPlacementPolicySatisfied());
        bps = new BlockPlacementStatusWithUpgradeDomain((BlockPlacementStatus)this.bpsd, this.upgradeDomains, 4, 4);
        Assert.assertFalse((boolean)bps.isPlacementPolicySatisfied());
    }
}

