/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class PathFinder {
    String pathenv;
    String pathSep;
    String fileSep;

    public PathFinder() {
        this.pathenv = System.getProperty("java.class.path");
        this.pathSep = System.getProperty("path.separator");
        this.fileSep = System.getProperty("file.separator");
    }

    public PathFinder(String envpath) {
        this.pathenv = System.getenv(envpath);
        this.pathSep = System.getProperty("path.separator");
        this.fileSep = System.getProperty("file.separator");
    }

    public void prependPathComponent(String str) {
        this.pathenv = str + this.pathSep + this.pathenv;
    }

    public File getAbsolutePath(String filename) {
        if (this.pathenv == null || this.pathSep == null || this.fileSep == null) {
            return null;
        }
        int val = -1;
        String classvalue = this.pathenv + this.pathSep;
        while ((val = classvalue.indexOf(this.pathSep)) >= 0 && classvalue.length() > 0) {
            String entry = classvalue.substring(0, val).trim();
            File f = new File(entry);
            if (f.isDirectory()) {
                f = new File(entry + this.fileSep + filename);
            }
            if (f.isFile() && f.canRead()) {
                return f;
            }
            classvalue = classvalue.substring(val + 1).trim();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        PathFinder finder;
        File file;
        if (args.length < 1) {
            System.out.println("Usage: java PathFinder <filename>");
            System.exit(1);
        }
        if ((file = (finder = new PathFinder("PATH")).getAbsolutePath(args[0])) != null) {
            System.out.println("Full path name = " + file.getCanonicalPath());
        }
    }
}

