/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.log4j.Logger;

public abstract class AccumuloConfiguration
implements Iterable<Map.Entry<String, String>> {
    private static final Logger log = Logger.getLogger(AccumuloConfiguration.class);

    public abstract String get(Property var1);

    @Override
    public abstract Iterator<Map.Entry<String, String>> iterator();

    private void checkType(Property property, PropertyType type) {
        if (!property.getType().equals((Object)type)) {
            String msg = "Configuration method intended for type " + (Object)((Object)type) + " called with a " + (Object)((Object)property.getType()) + " argument (" + property.getKey() + ")";
            IllegalArgumentException err = new IllegalArgumentException(msg);
            log.error((Object)msg, (Throwable)err);
            throw err;
        }
    }

    public Map<String, String> getAllPropertiesWithPrefix(Property property) {
        this.checkType(property, PropertyType.PREFIX);
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this) {
            if (!entry.getKey().startsWith(property.getKey())) continue;
            propMap.put(entry.getKey(), entry.getValue());
        }
        return propMap;
    }

    public long getMemoryInBytes(Property property) {
        this.checkType(property, PropertyType.MEMORY);
        String memString = this.get(property);
        return AccumuloConfiguration.getMemoryInBytes(memString);
    }

    public static long getMemoryInBytes(String str) {
        int multiplier = 0;
        switch (str.charAt(str.length() - 1)) {
            case 'G': {
                multiplier += 10;
            }
            case 'M': {
                multiplier += 10;
            }
            case 'K': {
                multiplier += 10;
            }
            case 'B': {
                return Long.parseLong(str.substring(0, str.length() - 1)) << multiplier;
            }
        }
        return Long.parseLong(str);
    }

    public long getTimeInMillis(Property property) {
        this.checkType(property, PropertyType.TIMEDURATION);
        return AccumuloConfiguration.getTimeInMillis(this.get(property));
    }

    public static long getTimeInMillis(String str) {
        int multiplier = 1;
        switch (str.charAt(str.length() - 1)) {
            case 'd': {
                multiplier *= 24;
            }
            case 'h': {
                multiplier *= 60;
            }
            case 'm': {
                multiplier *= 60;
            }
            case 's': {
                multiplier *= 1000;
                if (str.length() > 1 && str.endsWith("ms")) {
                    return Long.parseLong(str.substring(0, str.length() - 2));
                }
                return Long.parseLong(str.substring(0, str.length() - 1)) * (long)multiplier;
            }
        }
        return Long.parseLong(str) * 1000L;
    }

    public boolean getBoolean(Property property) {
        this.checkType(property, PropertyType.BOOLEAN);
        return Boolean.parseBoolean(this.get(property));
    }

    public double getFraction(Property property) {
        this.checkType(property, PropertyType.FRACTION);
        return this.getFraction(this.get(property));
    }

    public double getFraction(String str) {
        if (str.charAt(str.length() - 1) == '%') {
            return Double.parseDouble(str.substring(0, str.length() - 1)) / 100.0;
        }
        return Double.parseDouble(str);
    }

    public int getPort(Property property) {
        this.checkType(property, PropertyType.PORT);
        String portString = this.get(property);
        int port = Integer.parseInt(portString);
        if (port != 0 && (port < 1024 || port > 65535)) {
            log.error((Object)("Invalid port number " + port + "; Using default " + property.getDefaultValue()));
            port = Integer.parseInt(property.getDefaultValue());
        }
        return port;
    }

    public int getCount(Property property) {
        this.checkType(property, PropertyType.COUNT);
        String countString = this.get(property);
        return Integer.parseInt(countString);
    }

    public static synchronized DefaultConfiguration getDefaultConfiguration() {
        return DefaultConfiguration.getInstance();
    }

    @Deprecated
    public static synchronized AccumuloConfiguration getSiteConfiguration() {
        return SiteConfiguration.getInstance(AccumuloConfiguration.getDefaultConfiguration());
    }

    public static AccumuloConfiguration getTableConfiguration(Connector conn, String tableId) throws TableNotFoundException, AccumuloException {
        String tableName = Tables.getTableName(conn.getInstance(), tableId);
        return new ConfigurationCopy(conn.tableOperations().getProperties(tableName));
    }

    public int getMaxFilesPerTablet() {
        int maxFilesPerTablet = this.getCount(Property.TABLE_FILE_MAX);
        if (maxFilesPerTablet <= 0) {
            maxFilesPerTablet = this.getCount(Property.TSERV_SCAN_MAX_OPENFILES) - 1;
            log.debug((Object)("Max files per tablet " + maxFilesPerTablet));
        }
        return maxFilesPerTablet;
    }

    public void invalidateCache() {
    }
}

