/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;

public class ConfigurationCopy
extends AccumuloConfiguration {
    final Map<String, String> copy = Collections.synchronizedMap(new HashMap());

    public ConfigurationCopy(Map<String, String> config) {
        this(config.entrySet());
    }

    public ConfigurationCopy(Iterable<Map.Entry<String, String>> config) {
        for (Map.Entry<String, String> entry : config) {
            this.copy.put(entry.getKey(), entry.getValue());
        }
    }

    public ConfigurationCopy() {
        this(new HashMap<String, String>());
    }

    @Override
    public String get(Property property) {
        return this.copy.get(property.getKey());
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.copy.entrySet().iterator();
    }

    public void set(Property prop, String value) {
        this.copy.put(prop.getKey(), value);
    }

    public void set(String key, String value) {
        this.copy.put(key, value);
    }
}

