/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.TypedValueCombiner;
import org.apache.accumulo.core.iterators.ValueFormatException;
import org.apache.hadoop.io.WritableUtils;

public class SummingArrayCombiner
extends TypedValueCombiner<List<Long>> {
    public static final TypedValueCombiner.Encoder<List<Long>> FIXED_LONG_ARRAY_ENCODER = new FixedLongArrayEncoder();
    public static final TypedValueCombiner.Encoder<List<Long>> VAR_LONG_ARRAY_ENCODER = new VarLongArrayEncoder();
    public static final TypedValueCombiner.Encoder<List<Long>> STRING_ARRAY_ENCODER = new StringArrayEncoder();
    private static final String TYPE = "type";
    private static final String CLASS_PREFIX = "class:";

    @Override
    public List<Long> typedReduce(Key key, Iterator<List<Long>> iter) {
        List<Long> sum = new ArrayList<Long>();
        while (iter.hasNext()) {
            sum = SummingArrayCombiner.arrayAdd(sum, iter.next());
        }
        return sum;
    }

    public static List<Long> arrayAdd(List<Long> la, List<Long> lb) {
        if (la.size() > lb.size()) {
            for (int i = 0; i < lb.size(); ++i) {
                la.set(i, LongCombiner.safeAdd(la.get(i), lb.get(i)));
            }
            return la;
        }
        for (int i = 0; i < la.size(); ++i) {
            lb.set(i, LongCombiner.safeAdd(lb.get(i), la.get(i)));
        }
        return lb;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.setEncoder(options);
    }

    private void setEncoder(Map<String, String> options) {
        String type = options.get(TYPE);
        if (type == null) {
            throw new IllegalArgumentException("no type specified");
        }
        if (!type.startsWith(CLASS_PREFIX)) {
            switch (Type.valueOf(options.get(TYPE))) {
                case VARLEN: {
                    this.setEncoder(VAR_LONG_ARRAY_ENCODER);
                    return;
                }
                case FIXEDLEN: {
                    this.setEncoder(FIXED_LONG_ARRAY_ENCODER);
                    return;
                }
                case STRING: {
                    this.setEncoder(STRING_ARRAY_ENCODER);
                    return;
                }
            }
            throw new IllegalArgumentException();
        }
        this.setEncoder(type.substring(CLASS_PREFIX.length()));
        this.testEncoder(Arrays.asList(0L, 1L));
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("sumarray");
        io.setDescription("SummingArrayCombiner can interpret Values as arrays of Longs using a variety of encodings (arrays of variable length longs or fixed length longs, or comma-separated strings) before summing element-wise.");
        io.addNamedOption(TYPE, "<VARLEN|FIXEDLEN|STRING|fullClassName>");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        try {
            this.setEncoder(options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad encoder option", e);
        }
        return true;
    }

    public static void setEncodingType(IteratorSetting is, Type type) {
        is.addOption(TYPE, type.toString());
    }

    public static void setEncodingType(IteratorSetting is, Class<? extends TypedValueCombiner.Encoder<List<Long>>> encoderClass) {
        is.addOption(TYPE, CLASS_PREFIX + encoderClass.getName());
    }

    public static void setEncodingType(IteratorSetting is, String encoderClassName) {
        is.addOption(TYPE, CLASS_PREFIX + encoderClassName);
    }

    public static class StringArrayEncoder
    implements TypedValueCombiner.Encoder<List<Long>> {
        @Override
        public byte[] encode(List<Long> la) {
            if (la.size() == 0) {
                return new byte[0];
            }
            StringBuilder sb = new StringBuilder(Long.toString(la.get(0)));
            for (int i = 1; i < la.size(); ++i) {
                sb.append(",");
                sb.append(Long.toString(la.get(i)));
            }
            return sb.toString().getBytes();
        }

        @Override
        public List<Long> decode(byte[] b) {
            String[] longstrs = new String(b).split(",");
            ArrayList<Long> la = new ArrayList<Long>(longstrs.length);
            for (String s : longstrs) {
                if (s.length() == 0) {
                    la.add(0L);
                    continue;
                }
                try {
                    la.add(Long.parseLong(s));
                }
                catch (NumberFormatException nfe) {
                    throw new ValueFormatException(nfe);
                }
            }
            return la;
        }
    }

    public static class FixedLongArrayEncoder
    extends DOSArrayEncoder<Long> {
        @Override
        public void write(DataOutputStream dos, Long v) throws IOException {
            dos.writeLong(v);
        }

        @Override
        public Long read(DataInputStream dis) throws IOException {
            return dis.readLong();
        }
    }

    public static class VarLongArrayEncoder
    extends DOSArrayEncoder<Long> {
        @Override
        public void write(DataOutputStream dos, Long v) throws IOException {
            WritableUtils.writeVLong((DataOutput)dos, (long)v);
        }

        @Override
        public Long read(DataInputStream dis) throws IOException {
            return WritableUtils.readVLong((DataInput)dis);
        }
    }

    public static abstract class DOSArrayEncoder<V>
    implements TypedValueCombiner.Encoder<List<V>> {
        public abstract void write(DataOutputStream var1, V var2) throws IOException;

        public abstract V read(DataInputStream var1) throws IOException;

        @Override
        public byte[] encode(List<V> vl) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                WritableUtils.writeVInt((DataOutput)dos, (int)vl.size());
                for (V v : vl) {
                    this.write(dos, v);
                }
            }
            catch (IOException e) {
                throw new NumberFormatException(e.getMessage());
            }
            return baos.toByteArray();
        }

        @Override
        public List<V> decode(byte[] b) {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
            try {
                int len = WritableUtils.readVInt((DataInput)dis);
                ArrayList<V> vl = new ArrayList<V>(len);
                for (int i = 0; i < len; ++i) {
                    vl.add(this.read(dis));
                }
                return vl;
            }
            catch (IOException e) {
                throw new ValueFormatException(e);
            }
        }
    }

    public static enum Type {
        VARLEN,
        FIXEDLEN,
        STRING;

    }
}

