/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.accumulo.core.util.ByteArrayComparator;

public class ByteArraySet
extends TreeSet<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySet() {
        super(new ByteArrayComparator());
    }

    public ByteArraySet(Collection<? extends byte[]> c) {
        this();
        this.addAll(c);
    }

    public static ByteArraySet fromStrings(Collection<String> c) {
        ArrayList<byte[]> lst = new ArrayList<byte[]>();
        for (String s : c) {
            lst.add(s.getBytes());
        }
        return new ByteArraySet((Collection<? extends byte[]>)lst);
    }

    public static ByteArraySet fromStrings(String ... c) {
        return ByteArraySet.fromStrings(Arrays.asList(c));
    }

    public List<byte[]> toList() {
        return new ArrayList<byte[]>(this);
    }
}

