/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Utils;

public class PONative
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    String nativeMRjar;
    String[] params;

    public PONative(OperatorKey k) {
        super(k);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitNative(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Native('hadoop jar " + this.nativeMRjar + " " + Utils.getStringFromArray(this.getParams()) + "') - " + this.mKey.toString();
    }

    public String getNativeMRjar() {
        return this.nativeMRjar;
    }

    public void setNativeMRjar(String nativeMRjar) {
        this.nativeMRjar = nativeMRjar;
    }

    public String[] getParams() {
        this.unquotePropertyParams();
        return this.params;
    }

    private void unquotePropertyParams() {
        for (int i = 0; i < this.params.length; ++i) {
            int equalPos;
            String param = this.params[i];
            if (!param.startsWith("-D") || (equalPos = param.indexOf(61)) == -1 || equalPos >= param.length() - 3 || !this.checkQuote(equalPos + 1, param, '\'') && !this.checkQuote(equalPos + 1, param, '\"')) continue;
            this.params[i] = param.substring(0, equalPos + 1) + param.substring(equalPos + 2, param.length() - 1);
        }
    }

    private boolean checkQuote(int i, String param, char quote) {
        return param.charAt(i) == quote && param.charAt(param.length() - 1) == quote;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

