/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.operator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPoissonSample;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;

public class POPoissonSampleSpark
extends POPoissonSample {
    private static final Log LOG = LogFactory.getLog(POPoissonSampleSpark.class);
    private transient boolean endOfInput = false;

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void setEndOfInput(boolean isEndOfInput) {
        this.endOfInput = isEndOfInput;
    }

    public POPoissonSampleSpark(OperatorKey k, int rp, int sr, float hp, long tm) {
        super(k, rp, sr, hp, tm);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (!this.initialized) {
            this.numRowsSampled = 0;
            this.avgTupleMemSz = 0L;
            this.rowNum = 0L;
            this.skipInterval = -1L;
            if (this.totalMemory == null) {
                this.totalMemory = Runtime.getRuntime().maxMemory();
            }
            long availRedMem = (long)((float)this.totalMemory.longValue() * this.heapPerc);
            this.memToSkipPerSample = availRedMem / (long)this.sampleRate;
            this.initialized = true;
        }
        if (this.numRowSplTupleReturned) {
            return RESULT_EOP;
        }
        Result res = this.processInput();
        if (this.isEndOfInput()) {
            if ((long)this.numSkipped == this.skipInterval && res.returnStatus == 0) {
                return this.createNumRowTuple((Tuple)res.result);
            }
            if (this.newSample != null) {
                return this.createNumRowTuple((Tuple)this.newSample.result);
            }
        }
        if (res.returnStatus == 1) {
            return new Result(1, null);
        }
        if (res.returnStatus == 3 || res.returnStatus == 2) {
            return res;
        }
        ++this.rowNum;
        if ((long)this.numSkipped < this.skipInterval) {
            ++this.numSkipped;
            return new Result(3, null);
        }
        this.newSample = res;
        this.numSkipped = 0;
        Result pickedSample = this.newSample;
        this.updateSkipInterval((Tuple)pickedSample.result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"pickedSample:");
            if (pickedSample.result != null) {
                for (int i = 0; i < ((Tuple)pickedSample.result).size(); ++i) {
                    LOG.debug((Object)("the " + i + " ele:" + ((Tuple)pickedSample.result).get(i)));
                }
            }
        }
        return pickedSample;
    }

    @Override
    public String name() {
        return this.getAliasString() + "PoissonSampleSpark - " + this.mKey.toString();
    }
}

