/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestClusterTopology
extends Assert {
    @Test
    public void testCountNumNodes() throws Exception {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode("node1", "/d1/r1");
        cluster.add((Node)node1);
        NodeElement node2 = this.getNewNode("node2", "/d1/r2");
        cluster.add((Node)node2);
        NodeElement node3 = this.getNewNode("node3", "/d1/r3");
        cluster.add((Node)node3);
        NodeElement node4 = this.getNewNode("node4", "/d1/r4");
        cluster.add((Node)node4);
        ArrayList<NodeElement> excludedNodes = new ArrayList<NodeElement>();
        TestClusterTopology.assertEquals((String)"4 nodes should be available", (long)4L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        NodeElement deadNode = this.getNewNode("node5", "/d1/r2");
        excludedNodes.add(deadNode);
        TestClusterTopology.assertEquals((String)"4 nodes should be available with extra excluded Node", (long)4L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        excludedNodes.add(node4);
        TestClusterTopology.assertEquals((String)"excluded nodes with ROOT scope should be considered", (long)3L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
        TestClusterTopology.assertEquals((String)"excluded nodes without ~ scope should be considered", (long)2L, (long)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes));
        TestClusterTopology.assertEquals((String)"excluded nodes with rack scope should be considered", (long)1L, (long)cluster.countNumOfAvailableNodes(deadNode.getNetworkLocation(), excludedNodes));
        excludedNodes.add(node2);
        TestClusterTopology.assertEquals((String)"excluded nodes with ~ scope should be considered", (long)2L, (long)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes));
        TestClusterTopology.assertEquals((String)"No nodes should be considered for non-exist scope", (long)0L, (long)cluster.countNumOfAvailableNodes("/non-exist", excludedNodes));
        cluster.remove((Node)node1);
        TestClusterTopology.assertEquals((String)"1 node should be available", (long)1L, (long)cluster.countNumOfAvailableNodes("", excludedNodes));
    }

    @Test
    public void testChooseRandom() {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode("node1", "/d1/r1");
        cluster.add((Node)node1);
        NodeElement node2 = this.getNewNode("node2", "/d1/r2");
        cluster.add((Node)node2);
        NodeElement node3 = this.getNewNode("node3", "/d1/r3");
        cluster.add((Node)node3);
        NodeElement node4 = this.getNewNode("node4", "/d1/r3");
        cluster.add((Node)node4);
        int numIterations = 100;
        HashMap<String, Integer> histogram = new HashMap<String, Integer>();
        for (int i = 0; i < numIterations; ++i) {
            String randomNode = cluster.chooseRandom("").getName();
            if (!histogram.containsKey(randomNode)) {
                histogram.put(randomNode, 0);
            }
            histogram.put(randomNode, (Integer)histogram.get(randomNode) + 1);
        }
        TestClusterTopology.assertEquals((String)"Random is not selecting all nodes", (long)4L, (long)histogram.size());
        ChiSquareTest chiSquareTest = new ChiSquareTest();
        double[] expected = new double[histogram.size()];
        long[] observed = new long[histogram.size()];
        int j = 0;
        for (Integer occurrence : histogram.values()) {
            expected[j] = 1.0 * (double)numIterations / (double)histogram.size();
            observed[j] = occurrence.intValue();
            ++j;
        }
        boolean chiSquareTestRejected = chiSquareTest.chiSquareTest(expected, observed, 0.01);
        TestClusterTopology.assertFalse((String)"Not choosing nodes randomly", (boolean)chiSquareTestRejected);
        histogram = new HashMap();
        for (int i = 0; i < numIterations; ++i) {
            String randomNode = cluster.chooseRandom("~/d1/r3").getName();
            if (!histogram.containsKey(randomNode)) {
                histogram.put(randomNode, 0);
            }
            histogram.put(randomNode, (Integer)histogram.get(randomNode) + 1);
        }
        TestClusterTopology.assertEquals((String)"Random is not selecting the nodes it should", (long)2L, (long)histogram.size());
    }

    private NodeElement getNewNode(String name, String rackLocation) {
        NodeElement node = new NodeElement(name);
        node.setNetworkLocation(rackLocation);
        return node;
    }

    private NodeElement getNewNode(NetworkTopology cluster, String name, String rackLocation) {
        NodeElement node = this.getNewNode(name, rackLocation);
        cluster.add((Node)node);
        return node;
    }

    @Test
    public void testWeights() {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode(cluster, "node1", "/r1");
        NodeElement node2 = this.getNewNode(cluster, "node2", "/r1");
        NodeElement node3 = this.getNewNode(cluster, "node3", "/r2");
        for (Pair test : new Pair[]{Pair.of((Object)0, (Object)node1), Pair.of((Object)2, (Object)node2), Pair.of((Object)4, (Object)node3)}) {
            int expect = (Integer)test.getLeft();
            TestClusterTopology.assertEquals((String)test.toString(), (long)expect, (long)cluster.getWeight((Node)node1, (Node)test.getRight()));
            TestClusterTopology.assertEquals((String)test.toString(), (long)expect, (long)NetworkTopology.getWeightUsingNetworkLocation((Node)node1, (Node)((Node)test.getRight())));
        }
        cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node5 = this.getNewNode(cluster, "node5", "/pod1/r1");
        NodeElement node6 = this.getNewNode(cluster, "node6", "/pod1/r1");
        NodeElement node7 = this.getNewNode(cluster, "node7", "/pod1/r2");
        NodeElement node8 = this.getNewNode(cluster, "node8", "/pod2/r3");
        for (Pair test : new Pair[]{Pair.of((Object)0, (Object)node5), Pair.of((Object)2, (Object)node6), Pair.of((Object)4, (Object)node7), Pair.of((Object)6, (Object)node8)}) {
            int expect = (Integer)test.getLeft();
            TestClusterTopology.assertEquals((String)test.toString(), (long)expect, (long)cluster.getWeight((Node)node5, (Node)test.getRight()));
            TestClusterTopology.assertEquals((String)test.toString(), (long)expect, (long)NetworkTopology.getWeightUsingNetworkLocation((Node)node5, (Node)((Node)test.getRight())));
        }
    }

    public static class NodeElement
    implements Node {
        private String location;
        private String name;
        private Node parent;
        private int level;

        public NodeElement(String name) {
            this.name = name;
        }

        public String getNetworkLocation() {
            return this.location;
        }

        public void setNetworkLocation(String location) {
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int i) {
            this.level = i;
        }
    }
}

