/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DagDeleteRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(DagDeleteRunnable.class);
    final NodeId nodeId;
    final TezDAGID dag;
    final JobTokenSecretManager jobTokenSecretManager;
    final int shufflePort;
    final HttpConnectionParams httpConnectionParams;

    public DagDeleteRunnable(NodeId nodeId, int shufflePort, TezDAGID currentDag, HttpConnectionParams httpConnectionParams, JobTokenSecretManager jobTokenSecretMgr) {
        this.nodeId = nodeId;
        this.shufflePort = shufflePort;
        this.dag = currentDag;
        this.httpConnectionParams = httpConnectionParams;
        this.jobTokenSecretManager = jobTokenSecretMgr;
    }

    @Override
    public void run() {
        BaseHttpConnection httpConnection = null;
        try {
            URL baseURL = TezRuntimeUtils.constructBaseURIForShuffleHandlerDagComplete((String)this.nodeId.getHost(), (int)this.shufflePort, (String)this.dag.getApplicationId().toString(), (int)this.dag.getId(), (boolean)false);
            httpConnection = TezRuntimeUtils.getHttpConnection((boolean)true, (URL)baseURL, (HttpConnectionParams)this.httpConnectionParams, (String)"DAGDelete", (JobTokenSecretManager)this.jobTokenSecretManager);
            httpConnection.connect();
            httpConnection.getInputStream();
        }
        catch (Exception e) {
            LOG.warn("Could not setup HTTP Connection to the node " + this.nodeId.getHost() + " for dag delete. ", (Throwable)e);
        }
        finally {
            try {
                if (httpConnection != null) {
                    httpConnection.cleanup(true);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Encountered IOException for " + this.nodeId.getHost() + " during close. ", (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return "DagDeleteRunnable nodeId=" + this.nodeId + ", shufflePort=" + this.shufflePort + ", dagId=" + this.dag.toString();
    }
}

