/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.InternalApi;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

public final class BlobId
implements Serializable {
    private static final long serialVersionUID = 8201580858265557469L;
    private static final Pattern gsUtilUriPattern = Pattern.compile("^gs://(.+?)/(.+?)(?:#(\\d+))?$");
    private final String bucket;
    private final String name;
    private final Long generation;

    private BlobId(String bucket, String name, Long generation) {
        this.bucket = bucket;
        this.name = name;
        this.generation = generation;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getName() {
        return this.name;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String toGsUtilUri() {
        return "gs://" + this.bucket + "/" + this.name;
    }

    public String toGsUtilUriWithGeneration() {
        return "gs://" + this.bucket + "/" + this.name + (this.generation == null ? "" : "#" + this.generation);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucket", this.getBucket()).add("name", this.getName()).add("generation", this.getGeneration()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.name, this.generation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(BlobId.class)) {
            return false;
        }
        BlobId other = (BlobId)obj;
        return Objects.equals(this.bucket, other.bucket) && Objects.equals(this.name, other.name) && Objects.equals(this.generation, other.generation);
    }

    @InternalApi
    BlobId withGeneration(long generation) {
        return new BlobId(this.bucket, this.name, generation);
    }

    public static BlobId of(String bucket, String name) {
        return new BlobId(Preconditions.checkNotNull(bucket), Preconditions.checkNotNull(name), null);
    }

    public static BlobId of(String bucket, String name, Long generation) {
        return new BlobId(Preconditions.checkNotNull(bucket), Preconditions.checkNotNull(name), generation);
    }

    public static BlobId fromGsUtilUri(String gsUtilUri) {
        Matcher m4 = gsUtilUriPattern.matcher(gsUtilUri);
        if (!m4.matches()) {
            throw new IllegalArgumentException(gsUtilUri + " is not a valid gsutil URI (i.e. \"gs://bucket/blob\" or \"gs://bucket/blob#generation\")");
        }
        String bucket = m4.group(1);
        String name = m4.group(2);
        String generationGroup = m4.group(3);
        Long generation = generationGroup == null ? null : Long.valueOf(Long.parseLong(generationGroup));
        return BlobId.of(bucket, name, generation);
    }
}

