/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.http.HttpResponseException;
import com.google.auth.Retryable;
import com.google.cloud.BaseServiceException;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.io.JsonEOFException;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;

final class DefaultStorageRetryStrategy
implements StorageRetryStrategy {
    static final DefaultStorageRetryStrategy INSTANCE = new DefaultStorageRetryStrategy();
    private static final long serialVersionUID = 7928177703325504905L;
    private static final ExceptionHandler.Interceptor INTERCEPTOR_IDEMPOTENT = new InterceptorImpl(true, StorageException.RETRYABLE_ERRORS);
    private static final ExceptionHandler.Interceptor INTERCEPTOR_NON_IDEMPOTENT = new InterceptorImpl(false, ImmutableSet.of());
    private static final ExceptionHandler IDEMPOTENT_HANDLER = DefaultStorageRetryStrategy.newHandler(new EmptyJsonParsingExceptionInterceptor(), INTERCEPTOR_IDEMPOTENT);
    private static final ExceptionHandler NON_IDEMPOTENT_HANDLER = DefaultStorageRetryStrategy.newHandler(INTERCEPTOR_NON_IDEMPOTENT);

    private DefaultStorageRetryStrategy() {
    }

    public ExceptionHandler getIdempotentHandler() {
        return IDEMPOTENT_HANDLER;
    }

    public ExceptionHandler getNonidempotentHandler() {
        return NON_IDEMPOTENT_HANDLER;
    }

    private static ExceptionHandler newHandler(ExceptionHandler.Interceptor ... interceptors) {
        return ExceptionHandler.newBuilder().addInterceptors(interceptors).build();
    }

    private Object readResolve() {
        return INSTANCE;
    }

    private static class InterceptorImpl
    implements BaseInterceptor {
        private static final long serialVersionUID = 5283634944744417128L;
        private final boolean idempotent;
        private final ImmutableSet<BaseServiceException.Error> retryableErrors;

        private InterceptorImpl(boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
            this.idempotent = idempotent;
            this.retryableErrors = ImmutableSet.copyOf(retryableErrors);
        }

        @Override
        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            if (exception instanceof BaseServiceException) {
                BaseServiceException baseServiceException = (BaseServiceException)exception;
                return this.deepShouldRetry(baseServiceException);
            }
            if (exception instanceof HttpResponseException) {
                int code = ((HttpResponseException)exception).getStatusCode();
                return this.shouldRetryCodeReason(code, null);
            }
            if (exception instanceof Retryable) {
                Retryable retryable = (Retryable)((Object)exception);
                return this.idempotent && retryable.isRetryable() ? ExceptionHandler.Interceptor.RetryResult.RETRY : ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
            }
            if (exception instanceof IOException) {
                IOException ioException = (IOException)exception;
                return this.shouldRetryIOException(ioException);
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }

        private ExceptionHandler.Interceptor.RetryResult shouldRetryCodeReason(Integer code, String reason) {
            if (BaseServiceException.isRetryable(code, reason, this.idempotent, this.retryableErrors)) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
        }

        private ExceptionHandler.Interceptor.RetryResult shouldRetryIOException(IOException ioException) {
            if (ioException instanceof JsonEOFException && this.idempotent) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            if (ioException instanceof MalformedJsonException && this.idempotent) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            if (ioException instanceof SSLException && this.idempotent) {
                Throwable cause = ioException.getCause();
                if (cause instanceof SocketException) {
                    SocketException se = (SocketException)cause;
                    return this.shouldRetryIOException(se);
                }
            } else if (ioException instanceof UnknownHostException && this.idempotent) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            if (BaseServiceException.isRetryable(this.idempotent, ioException)) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.NO_RETRY;
        }

        private ExceptionHandler.Interceptor.RetryResult deepShouldRetry(BaseServiceException baseServiceException) {
            Throwable cause;
            if (baseServiceException.getCode() == 0 && baseServiceException.getReason() == null && (cause = baseServiceException.getCause()) instanceof IOException) {
                IOException ioException = (IOException)cause;
                return this.shouldRetryIOException(ioException);
            }
            int code = baseServiceException.getCode();
            String reason = baseServiceException.getReason();
            return this.shouldRetryCodeReason(code, reason);
        }
    }

    private static final class EmptyJsonParsingExceptionInterceptor
    implements BaseInterceptor {
        private static final long serialVersionUID = -3466977370399704805L;

        private EmptyJsonParsingExceptionInterceptor() {
        }

        @Override
        public ExceptionHandler.Interceptor.RetryResult beforeEval(Exception exception) {
            IllegalArgumentException illegalArgumentException;
            if (exception instanceof IllegalArgumentException && "no JSON input found".equals((illegalArgumentException = (IllegalArgumentException)exception).getMessage())) {
                return ExceptionHandler.Interceptor.RetryResult.RETRY;
            }
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }
    }

    private static interface BaseInterceptor
    extends ExceptionHandler.Interceptor {
        @Override
        default public ExceptionHandler.Interceptor.RetryResult afterEval(Exception exception, ExceptionHandler.Interceptor.RetryResult retryResult) {
            return ExceptionHandler.Interceptor.RetryResult.CONTINUE_EVALUATION;
        }
    }
}

