/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.SyncingFileChannel;
import com.google.cloud.storage.ThroughputSink;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;

final class RecoveryFile
implements AutoCloseable {
    private static final Set<OpenOption> writeOpsNew = ImmutableSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    private static final Set<OpenOption> writeOpsExisting = ImmutableSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    private static final Set<OpenOption> readOps = ImmutableSet.of(StandardOpenOption.READ);
    private final Path path;
    private final ThroughputSink throughputSink;
    private final Runnable onCloseCallback;
    private boolean newFile;

    RecoveryFile(Path path, ThroughputSink throughputSink, Runnable onCloseCallback) {
        this.path = path;
        this.throughputSink = throughputSink;
        this.onCloseCallback = onCloseCallback;
        this.newFile = true;
    }

    public Path getPath() {
        return this.path;
    }

    public Path touch() throws IOException {
        this.newFile = false;
        return Files.createFile(this.path, new FileAttribute[0]);
    }

    public SeekableByteChannel reader() throws IOException {
        return Files.newByteChannel(this.path, readOps, new FileAttribute[0]);
    }

    public WritableByteChannel writer() throws IOException {
        try {
            WritableByteChannel writableByteChannel = this.throughputSink.decorate(Files.newByteChannel(this.path, this.newFile ? writeOpsNew : writeOpsExisting, new FileAttribute[0]));
            return writableByteChannel;
        }
        finally {
            this.newFile = false;
        }
    }

    public GatheringByteChannel syncingChannel() throws IOException {
        try {
            GatheringByteChannel gatheringByteChannel = this.throughputSink.decorate(new SyncingFileChannel(FileChannel.open(this.path, this.newFile ? writeOpsNew : writeOpsExisting, new FileAttribute[0])));
            return gatheringByteChannel;
        }
        finally {
            this.newFile = false;
        }
    }

    @Override
    public void close() throws IOException {
        Files.deleteIfExists(this.path);
        this.onCloseCallback.run();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).add("throughputSink", this.throughputSink).add("onCloseCallback", this.onCloseCallback).toString();
    }

    Unsafe unsafe() {
        return new Unsafe();
    }

    final class Unsafe {
        Unsafe() {
        }

        public Path touch() throws UnsafeIOException {
            try {
                return RecoveryFile.this.touch();
            }
            catch (IOException e) {
                throw new UnsafeIOException(e);
            }
        }
    }

    static final class UnsafeIOException
    extends RuntimeException {
        private UnsafeIOException(IOException cause) {
            super(cause);
        }
    }
}

