/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.transfermanager;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.cloud.storage.transfermanager.ParallelUploadConfig;
import com.google.cloud.storage.transfermanager.UploadResult;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UploadJob {
    private final @NonNull List<ApiFuture<UploadResult>> uploadResults;
    private final @NonNull ParallelUploadConfig parallelUploadConfig;

    private UploadJob(@NonNull List<ApiFuture<UploadResult>> uploadResults, @NonNull ParallelUploadConfig parallelUploadConfig) {
        this.uploadResults = uploadResults;
        this.parallelUploadConfig = parallelUploadConfig;
    }

    public List<UploadResult> getUploadResults() {
        return ApiExceptions.callAndTranslateApiException(ApiFutures.allAsList(this.uploadResults));
    }

    public ParallelUploadConfig getParallelUploadConfig() {
        return this.parallelUploadConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadJob)) {
            return false;
        }
        UploadJob uploadJob = (UploadJob)o;
        return this.uploadResults.equals(uploadJob.uploadResults) && this.parallelUploadConfig.equals(uploadJob.parallelUploadConfig);
    }

    public int hashCode() {
        return Objects.hash(this.uploadResults, this.parallelUploadConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("uploadResults", this.uploadResults).add("parallelUploadConfig", this.parallelUploadConfig).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private @NonNull List<ApiFuture<UploadResult>> uploadResults = ImmutableList.of();
        private @MonotonicNonNull ParallelUploadConfig parallelUploadConfig;

        private Builder() {
        }

        public Builder setUploadResults(@NonNull List<ApiFuture<UploadResult>> uploadResults) {
            this.uploadResults = ImmutableList.copyOf(uploadResults);
            return this;
        }

        public Builder setParallelUploadConfig(@NonNull ParallelUploadConfig parallelUploadConfig) {
            this.parallelUploadConfig = parallelUploadConfig;
            return this;
        }

        public UploadJob build() {
            Preconditions.checkNotNull(this.uploadResults);
            Preconditions.checkNotNull(this.parallelUploadConfig);
            return new UploadJob(this.uploadResults, this.parallelUploadConfig);
        }
    }
}

