/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.storage.v2.BidiReadObjectRequest;
import com.google.storage.v2.BidiReadObjectResponse;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.CancelResumableWriteRequest;
import com.google.storage.v2.CancelResumableWriteResponse;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListBucketsResponse;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.ListObjectsResponse;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.MoveObjectRequest;
import com.google.storage.v2.Object;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.RestoreObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.GrpcStorageStub;
import com.google.storage.v2.stub.StorageStub;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableMap;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableSet;
import org.apache.pinot.shaded.com.google.common.collect.Lists;

public class StorageStubSettings
extends StubSettings<StorageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/cloud-platform.read-only")).add("https://www.googleapis.com/auth/devstorage.full_control")).add("https://www.googleapis.com/auth/devstorage.read_only")).add("https://www.googleapis.com/auth/devstorage.read_write")).build();
    private final UnaryCallSettings<DeleteBucketRequest, Empty> deleteBucketSettings;
    private final UnaryCallSettings<GetBucketRequest, Bucket> getBucketSettings;
    private final UnaryCallSettings<CreateBucketRequest, Bucket> createBucketSettings;
    private final PagedCallSettings<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings;
    private final UnaryCallSettings<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateBucketRequest, Bucket> updateBucketSettings;
    private final UnaryCallSettings<ComposeObjectRequest, Object> composeObjectSettings;
    private final UnaryCallSettings<DeleteObjectRequest, Empty> deleteObjectSettings;
    private final UnaryCallSettings<RestoreObjectRequest, Object> restoreObjectSettings;
    private final UnaryCallSettings<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings;
    private final UnaryCallSettings<GetObjectRequest, Object> getObjectSettings;
    private final ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
    private final StreamingCallSettings<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObjectSettings;
    private final UnaryCallSettings<UpdateObjectRequest, Object> updateObjectSettings;
    private final StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
    private final StreamingCallSettings<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectSettings;
    private final PagedCallSettings<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings;
    private final UnaryCallSettings<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings;
    private final UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
    private final UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;
    private final UnaryCallSettings<MoveObjectRequest, Object> moveObjectSettings;
    private static final PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, Bucket> LIST_BUCKETS_PAGE_STR_DESC = new PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, Bucket>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListBucketsRequest injectToken(ListBucketsRequest payload, String token) {
            return ListBucketsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListBucketsRequest injectPageSize(ListBucketsRequest payload, int pageSize) {
            return ListBucketsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListBucketsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListBucketsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Bucket> extractResources(ListBucketsResponse payload) {
            return payload.getBucketsList();
        }
    };
    private static final PagedListDescriptor<ListObjectsRequest, ListObjectsResponse, Object> LIST_OBJECTS_PAGE_STR_DESC = new PagedListDescriptor<ListObjectsRequest, ListObjectsResponse, Object>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListObjectsRequest injectToken(ListObjectsRequest payload, String token) {
            return ListObjectsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListObjectsRequest injectPageSize(ListObjectsRequest payload, int pageSize) {
            return ListObjectsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListObjectsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListObjectsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Object> extractResources(ListObjectsResponse payload) {
            return payload.getObjectsList();
        }
    };
    private static final PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> LIST_BUCKETS_PAGE_STR_FACT = new PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse>(){

        @Override
        public ApiFuture<StorageClient.ListBucketsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBucketsRequest, ListBucketsResponse> callable, ListBucketsRequest request, ApiCallContext context, ApiFuture<ListBucketsResponse> futureResponse) {
            PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> pageContext = PageContext.create(callable, LIST_BUCKETS_PAGE_STR_DESC, request, context);
            return StorageClient.ListBucketsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> LIST_OBJECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse>(){

        @Override
        public ApiFuture<StorageClient.ListObjectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListObjectsRequest, ListObjectsResponse> callable, ListObjectsRequest request, ApiCallContext context, ApiFuture<ListObjectsResponse> futureResponse) {
            PageContext<ListObjectsRequest, ListObjectsResponse, Object> pageContext = PageContext.create(callable, LIST_OBJECTS_PAGE_STR_DESC, request, context);
            return StorageClient.ListObjectsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteBucketRequest, Empty> deleteBucketSettings() {
        return this.deleteBucketSettings;
    }

    public UnaryCallSettings<GetBucketRequest, Bucket> getBucketSettings() {
        return this.getBucketSettings;
    }

    public UnaryCallSettings<CreateBucketRequest, Bucket> createBucketSettings() {
        return this.createBucketSettings;
    }

    public PagedCallSettings<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings() {
        return this.listBucketsSettings;
    }

    public UnaryCallSettings<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings() {
        return this.lockBucketRetentionPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateBucketRequest, Bucket> updateBucketSettings() {
        return this.updateBucketSettings;
    }

    public UnaryCallSettings<ComposeObjectRequest, Object> composeObjectSettings() {
        return this.composeObjectSettings;
    }

    public UnaryCallSettings<DeleteObjectRequest, Empty> deleteObjectSettings() {
        return this.deleteObjectSettings;
    }

    public UnaryCallSettings<RestoreObjectRequest, Object> restoreObjectSettings() {
        return this.restoreObjectSettings;
    }

    public UnaryCallSettings<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings() {
        return this.cancelResumableWriteSettings;
    }

    public UnaryCallSettings<GetObjectRequest, Object> getObjectSettings() {
        return this.getObjectSettings;
    }

    public ServerStreamingCallSettings<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
        return this.readObjectSettings;
    }

    public StreamingCallSettings<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObjectSettings() {
        return this.bidiReadObjectSettings;
    }

    public UnaryCallSettings<UpdateObjectRequest, Object> updateObjectSettings() {
        return this.updateObjectSettings;
    }

    public StreamingCallSettings<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
        return this.writeObjectSettings;
    }

    public StreamingCallSettings<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectSettings() {
        return this.bidiWriteObjectSettings;
    }

    public PagedCallSettings<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings() {
        return this.listObjectsSettings;
    }

    public UnaryCallSettings<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings() {
        return this.rewriteObjectSettings;
    }

    public UnaryCallSettings<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
        return this.startResumableWriteSettings;
    }

    public UnaryCallSettings<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
        return this.queryWriteStatusSettings;
    }

    public UnaryCallSettings<MoveObjectRequest, Object> moveObjectSettings() {
        return this.moveObjectSettings;
    }

    public StorageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "storage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "storage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.deleteBucketSettings = settingsBuilder.deleteBucketSettings().build();
        this.getBucketSettings = settingsBuilder.getBucketSettings().build();
        this.createBucketSettings = settingsBuilder.createBucketSettings().build();
        this.listBucketsSettings = settingsBuilder.listBucketsSettings().build();
        this.lockBucketRetentionPolicySettings = settingsBuilder.lockBucketRetentionPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateBucketSettings = settingsBuilder.updateBucketSettings().build();
        this.composeObjectSettings = settingsBuilder.composeObjectSettings().build();
        this.deleteObjectSettings = settingsBuilder.deleteObjectSettings().build();
        this.restoreObjectSettings = settingsBuilder.restoreObjectSettings().build();
        this.cancelResumableWriteSettings = settingsBuilder.cancelResumableWriteSettings().build();
        this.getObjectSettings = settingsBuilder.getObjectSettings().build();
        this.readObjectSettings = settingsBuilder.readObjectSettings().build();
        this.bidiReadObjectSettings = settingsBuilder.bidiReadObjectSettings().build();
        this.updateObjectSettings = settingsBuilder.updateObjectSettings().build();
        this.writeObjectSettings = settingsBuilder.writeObjectSettings().build();
        this.bidiWriteObjectSettings = settingsBuilder.bidiWriteObjectSettings().build();
        this.listObjectsSettings = settingsBuilder.listObjectsSettings().build();
        this.rewriteObjectSettings = settingsBuilder.rewriteObjectSettings().build();
        this.startResumableWriteSettings = settingsBuilder.startResumableWriteSettings().build();
        this.queryWriteStatusSettings = settingsBuilder.queryWriteStatusSettings().build();
        this.moveObjectSettings = settingsBuilder.moveObjectSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteBucketRequest, Empty> deleteBucketSettings;
        private final UnaryCallSettings.Builder<GetBucketRequest, Bucket> getBucketSettings;
        private final UnaryCallSettings.Builder<CreateBucketRequest, Bucket> createBucketSettings;
        private final PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings;
        private final UnaryCallSettings.Builder<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateBucketRequest, Bucket> updateBucketSettings;
        private final UnaryCallSettings.Builder<ComposeObjectRequest, Object> composeObjectSettings;
        private final UnaryCallSettings.Builder<DeleteObjectRequest, Empty> deleteObjectSettings;
        private final UnaryCallSettings.Builder<RestoreObjectRequest, Object> restoreObjectSettings;
        private final UnaryCallSettings.Builder<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings;
        private final UnaryCallSettings.Builder<GetObjectRequest, Object> getObjectSettings;
        private final ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings;
        private final StreamingCallSettings.Builder<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObjectSettings;
        private final UnaryCallSettings.Builder<UpdateObjectRequest, Object> updateObjectSettings;
        private final StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings;
        private final StreamingCallSettings.Builder<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectSettings;
        private final PagedCallSettings.Builder<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings;
        private final UnaryCallSettings.Builder<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings;
        private final UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings;
        private final UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings;
        private final UnaryCallSettings.Builder<MoveObjectRequest, Object> moveObjectSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBucketsSettings = PagedCallSettings.newBuilder(LIST_BUCKETS_PAGE_STR_FACT);
            this.lockBucketRetentionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.composeObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelResumableWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readObjectSettings = ServerStreamingCallSettings.newBuilder();
            this.bidiReadObjectSettings = StreamingCallSettings.newBuilder();
            this.updateObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.writeObjectSettings = StreamingCallSettings.newBuilder();
            this.bidiWriteObjectSettings = StreamingCallSettings.newBuilder();
            this.listObjectsSettings = PagedCallSettings.newBuilder(LIST_OBJECTS_PAGE_STR_FACT);
            this.rewriteObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startResumableWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryWriteStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveObjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteBucketSettings, this.getBucketSettings, this.createBucketSettings, this.listBucketsSettings, this.lockBucketRetentionPolicySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateBucketSettings, this.composeObjectSettings, this.deleteObjectSettings, this.restoreObjectSettings, new UnaryCallSettings.Builder[]{this.cancelResumableWriteSettings, this.getObjectSettings, this.updateObjectSettings, this.listObjectsSettings, this.rewriteObjectSettings, this.startResumableWriteSettings, this.queryWriteStatusSettings, this.moveObjectSettings});
            Builder.initDefaults(this);
        }

        protected Builder(StorageStubSettings settings) {
            super(settings);
            this.deleteBucketSettings = settings.deleteBucketSettings.toBuilder();
            this.getBucketSettings = settings.getBucketSettings.toBuilder();
            this.createBucketSettings = settings.createBucketSettings.toBuilder();
            this.listBucketsSettings = settings.listBucketsSettings.toBuilder();
            this.lockBucketRetentionPolicySettings = settings.lockBucketRetentionPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateBucketSettings = settings.updateBucketSettings.toBuilder();
            this.composeObjectSettings = settings.composeObjectSettings.toBuilder();
            this.deleteObjectSettings = settings.deleteObjectSettings.toBuilder();
            this.restoreObjectSettings = settings.restoreObjectSettings.toBuilder();
            this.cancelResumableWriteSettings = settings.cancelResumableWriteSettings.toBuilder();
            this.getObjectSettings = settings.getObjectSettings.toBuilder();
            this.readObjectSettings = settings.readObjectSettings.toBuilder();
            this.bidiReadObjectSettings = settings.bidiReadObjectSettings.toBuilder();
            this.updateObjectSettings = settings.updateObjectSettings.toBuilder();
            this.writeObjectSettings = settings.writeObjectSettings.toBuilder();
            this.bidiWriteObjectSettings = settings.bidiWriteObjectSettings.toBuilder();
            this.listObjectsSettings = settings.listObjectsSettings.toBuilder();
            this.rewriteObjectSettings = settings.rewriteObjectSettings.toBuilder();
            this.startResumableWriteSettings = settings.startResumableWriteSettings.toBuilder();
            this.queryWriteStatusSettings = settings.queryWriteStatusSettings.toBuilder();
            this.moveObjectSettings = settings.moveObjectSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteBucketSettings, this.getBucketSettings, this.createBucketSettings, this.listBucketsSettings, this.lockBucketRetentionPolicySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateBucketSettings, this.composeObjectSettings, this.deleteObjectSettings, this.restoreObjectSettings, new UnaryCallSettings.Builder[]{this.cancelResumableWriteSettings, this.getObjectSettings, this.updateObjectSettings, this.listObjectsSettings, this.rewriteObjectSettings, this.startResumableWriteSettings, this.queryWriteStatusSettings, this.moveObjectSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(StorageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(StorageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StorageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteBucketSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getBucketSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.createBucketSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            ((PagedCallSettings.Builder)builder.listBucketsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.lockBucketRetentionPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.updateBucketSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.composeObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.deleteObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.restoreObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.cancelResumableWriteSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.getObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.readObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.updateObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            ((PagedCallSettings.Builder)builder.listObjectsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.rewriteObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.startResumableWriteSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.queryWriteStatusSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.moveObjectSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteBucketRequest, Empty> deleteBucketSettings() {
            return this.deleteBucketSettings;
        }

        public UnaryCallSettings.Builder<GetBucketRequest, Bucket> getBucketSettings() {
            return this.getBucketSettings;
        }

        public UnaryCallSettings.Builder<CreateBucketRequest, Bucket> createBucketSettings() {
            return this.createBucketSettings;
        }

        public PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, StorageClient.ListBucketsPagedResponse> listBucketsSettings() {
            return this.listBucketsSettings;
        }

        public UnaryCallSettings.Builder<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicySettings() {
            return this.lockBucketRetentionPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateBucketRequest, Bucket> updateBucketSettings() {
            return this.updateBucketSettings;
        }

        public UnaryCallSettings.Builder<ComposeObjectRequest, Object> composeObjectSettings() {
            return this.composeObjectSettings;
        }

        public UnaryCallSettings.Builder<DeleteObjectRequest, Empty> deleteObjectSettings() {
            return this.deleteObjectSettings;
        }

        public UnaryCallSettings.Builder<RestoreObjectRequest, Object> restoreObjectSettings() {
            return this.restoreObjectSettings;
        }

        public UnaryCallSettings.Builder<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteSettings() {
            return this.cancelResumableWriteSettings;
        }

        public UnaryCallSettings.Builder<GetObjectRequest, Object> getObjectSettings() {
            return this.getObjectSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadObjectRequest, ReadObjectResponse> readObjectSettings() {
            return this.readObjectSettings;
        }

        public StreamingCallSettings.Builder<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObjectSettings() {
            return this.bidiReadObjectSettings;
        }

        public UnaryCallSettings.Builder<UpdateObjectRequest, Object> updateObjectSettings() {
            return this.updateObjectSettings;
        }

        public StreamingCallSettings.Builder<WriteObjectRequest, WriteObjectResponse> writeObjectSettings() {
            return this.writeObjectSettings;
        }

        public StreamingCallSettings.Builder<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectSettings() {
            return this.bidiWriteObjectSettings;
        }

        public PagedCallSettings.Builder<ListObjectsRequest, ListObjectsResponse, StorageClient.ListObjectsPagedResponse> listObjectsSettings() {
            return this.listObjectsSettings;
        }

        public UnaryCallSettings.Builder<RewriteObjectRequest, RewriteResponse> rewriteObjectSettings() {
            return this.rewriteObjectSettings;
        }

        public UnaryCallSettings.Builder<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteSettings() {
            return this.startResumableWriteSettings;
        }

        public UnaryCallSettings.Builder<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusSettings() {
            return this.queryWriteStatusSettings;
        }

        public UnaryCallSettings.Builder<MoveObjectRequest, Object> moveObjectSettings() {
            return this.moveObjectSettings;
        }

        public StorageStubSettings build() throws IOException {
            return new StorageStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_0_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

