/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.services;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.Descriptors;
import io.grpc.BindableService;
import io.grpc.ExperimentalApi;
import io.grpc.InternalServer;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.reflection.v1.ErrorResponse;
import io.grpc.reflection.v1.ExtensionNumberResponse;
import io.grpc.reflection.v1.ExtensionRequest;
import io.grpc.reflection.v1.FileDescriptorResponse;
import io.grpc.reflection.v1.ListServiceResponse;
import io.grpc.reflection.v1.ServerReflectionGrpc;
import io.grpc.reflection.v1.ServerReflectionRequest;
import io.grpc.reflection.v1.ServerReflectionResponse;
import io.grpc.reflection.v1.ServiceResponse;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2222")
public final class ProtoReflectionServiceV1
extends ServerReflectionGrpc.ServerReflectionImplBase {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<Server, ServerReflectionIndex> serverReflectionIndexes = new WeakHashMap<Server, ServerReflectionIndex>();

    private ProtoReflectionServiceV1() {
    }

    public static BindableService newInstance() {
        return new ProtoReflectionServiceV1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerReflectionIndex getRefreshedIndex() {
        Object object = this.lock;
        synchronized (object) {
            Server server = InternalServer.SERVER_CONTEXT_KEY.get();
            ServerReflectionIndex index = this.serverReflectionIndexes.get(server);
            if (index == null) {
                index = new ServerReflectionIndex(server.getImmutableServices(), server.getMutableServices());
                this.serverReflectionIndexes.put(server, index);
                return index;
            }
            HashSet<Descriptors.FileDescriptor> serverFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
            HashSet<String> serverServiceNames = new HashSet<String>();
            List<ServerServiceDefinition> serverMutableServices = server.getMutableServices();
            for (ServerServiceDefinition mutableService : serverMutableServices) {
                ServiceDescriptor serviceDescriptor = mutableService.getServiceDescriptor();
                if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                String serviceName = serviceDescriptor.getName();
                Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                serverFileDescriptors.add(fileDescriptor);
                serverServiceNames.add(serviceName);
            }
            FileDescriptorIndex mutableServicesIndex = index.getMutableServicesIndex();
            if (!mutableServicesIndex.getServiceFileDescriptors().equals(serverFileDescriptors) || !mutableServicesIndex.getServiceNames().equals(serverServiceNames)) {
                index = new ServerReflectionIndex(server.getImmutableServices(), serverMutableServices);
                this.serverReflectionIndexes.put(server, index);
            }
            return index;
        }
    }

    @Override
    public StreamObserver<ServerReflectionRequest> serverReflectionInfo(StreamObserver<ServerReflectionResponse> responseObserver) {
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        ProtoReflectionStreamObserver requestObserver = new ProtoReflectionStreamObserver(this.getRefreshedIndex(), serverCallStreamObserver);
        serverCallStreamObserver.setOnReadyHandler(requestObserver);
        serverCallStreamObserver.disableAutoRequest();
        serverCallStreamObserver.request(1);
        return requestObserver;
    }

    private static final class FileDescriptorIndex {
        private final Set<String> serviceNames = new HashSet<String>();
        private final Set<Descriptors.FileDescriptor> serviceFileDescriptors = new HashSet<Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsByName = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Descriptors.FileDescriptor> fileDescriptorsBySymbol = new HashMap<String, Descriptors.FileDescriptor>();
        private final Map<String, Map<Integer, Descriptors.FileDescriptor>> fileDescriptorsByExtensionAndNumber = new HashMap<String, Map<Integer, Descriptors.FileDescriptor>>();

        FileDescriptorIndex(List<ServerServiceDefinition> services) {
            ArrayDeque<Descriptors.FileDescriptor> fileDescriptorsToProcess = new ArrayDeque<Descriptors.FileDescriptor>();
            HashSet<String> seenFiles = new HashSet<String>();
            for (ServerServiceDefinition service : services) {
                ServiceDescriptor serviceDescriptor = service.getServiceDescriptor();
                if (!(serviceDescriptor.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier)) continue;
                Descriptors.FileDescriptor fileDescriptor = ((ProtoFileDescriptorSupplier)serviceDescriptor.getSchemaDescriptor()).getFileDescriptor();
                String serviceName = serviceDescriptor.getName();
                Preconditions.checkState(!this.serviceNames.contains(serviceName), "Service already defined: %s", (Object)serviceName);
                this.serviceFileDescriptors.add(fileDescriptor);
                this.serviceNames.add(serviceName);
                if (seenFiles.contains(fileDescriptor.getName())) continue;
                seenFiles.add(fileDescriptor.getName());
                fileDescriptorsToProcess.add(fileDescriptor);
            }
            while (!fileDescriptorsToProcess.isEmpty()) {
                Descriptors.FileDescriptor currentFd = (Descriptors.FileDescriptor)fileDescriptorsToProcess.remove();
                this.processFileDescriptor(currentFd);
                for (Descriptors.FileDescriptor dependencyFd : currentFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    fileDescriptorsToProcess.add(dependencyFd);
                }
            }
        }

        private Set<Descriptors.FileDescriptor> getServiceFileDescriptors() {
            return Collections.unmodifiableSet(this.serviceFileDescriptors);
        }

        private Set<String> getServiceNames() {
            return Collections.unmodifiableSet(this.serviceNames);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            return this.fileDescriptorsByName.get(name);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            return this.fileDescriptorsBySymbol.get(symbol);
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int number) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return this.fileDescriptorsByExtensionAndNumber.get(type).get(number);
            }
            return null;
        }

        @Nullable
        private Set<Integer> getExtensionNumbersOfType(String type) {
            if (this.fileDescriptorsByExtensionAndNumber.containsKey(type)) {
                return Collections.unmodifiableSet(this.fileDescriptorsByExtensionAndNumber.get(type).keySet());
            }
            return null;
        }

        private void processFileDescriptor(Descriptors.FileDescriptor fd) {
            String fdName = fd.getName();
            Preconditions.checkState(!this.fileDescriptorsByName.containsKey(fdName), "File name already used: %s", (Object)fdName);
            this.fileDescriptorsByName.put(fdName, fd);
            for (Descriptors.ServiceDescriptor service : fd.getServices()) {
                this.processService(service, fd);
            }
            for (Descriptors.Descriptor type : fd.getMessageTypes()) {
                this.processType(type, fd);
            }
            for (Descriptors.FieldDescriptor extension : fd.getExtensions()) {
                this.processExtension(extension, fd);
            }
        }

        private void processService(Descriptors.ServiceDescriptor service, Descriptors.FileDescriptor fd) {
            String serviceName = service.getFullName();
            Preconditions.checkState(!this.fileDescriptorsBySymbol.containsKey(serviceName), "Service already defined: %s", (Object)serviceName);
            this.fileDescriptorsBySymbol.put(serviceName, fd);
            for (Descriptors.MethodDescriptor method : service.getMethods()) {
                String methodName = method.getFullName();
                Preconditions.checkState(!this.fileDescriptorsBySymbol.containsKey(methodName), "Method already defined: %s", (Object)methodName);
                this.fileDescriptorsBySymbol.put(methodName, fd);
            }
        }

        private void processType(Descriptors.Descriptor type, Descriptors.FileDescriptor fd) {
            String typeName = type.getFullName();
            Preconditions.checkState(!this.fileDescriptorsBySymbol.containsKey(typeName), "Type already defined: %s", (Object)typeName);
            this.fileDescriptorsBySymbol.put(typeName, fd);
            for (Descriptors.FieldDescriptor extension : type.getExtensions()) {
                this.processExtension(extension, fd);
            }
            for (Descriptors.Descriptor nestedType : type.getNestedTypes()) {
                this.processType(nestedType, fd);
            }
        }

        private void processExtension(Descriptors.FieldDescriptor extension, Descriptors.FileDescriptor fd) {
            String extensionName = extension.getContainingType().getFullName();
            int extensionNumber = extension.getNumber();
            if (!this.fileDescriptorsByExtensionAndNumber.containsKey(extensionName)) {
                this.fileDescriptorsByExtensionAndNumber.put(extensionName, new HashMap());
            }
            Preconditions.checkState(!this.fileDescriptorsByExtensionAndNumber.get(extensionName).containsKey(extensionNumber), "Extension name and number already defined: %s, %s", (Object)extensionName, extensionNumber);
            this.fileDescriptorsByExtensionAndNumber.get(extensionName).put(extensionNumber, fd);
        }
    }

    private static final class ServerReflectionIndex {
        private final FileDescriptorIndex immutableServicesIndex;
        private final FileDescriptorIndex mutableServicesIndex;

        public ServerReflectionIndex(List<ServerServiceDefinition> immutableServices, List<ServerServiceDefinition> mutableServices) {
            this.immutableServicesIndex = new FileDescriptorIndex(immutableServices);
            this.mutableServicesIndex = new FileDescriptorIndex(mutableServices);
        }

        private FileDescriptorIndex getMutableServicesIndex() {
            return this.mutableServicesIndex;
        }

        private Set<String> getServiceNames() {
            Set immutableServiceNames = this.immutableServicesIndex.getServiceNames();
            Set mutableServiceNames = this.mutableServicesIndex.getServiceNames();
            HashSet<String> serviceNames = new HashSet<String>(immutableServiceNames.size() + mutableServiceNames.size());
            serviceNames.addAll(immutableServiceNames);
            serviceNames.addAll(mutableServiceNames);
            return serviceNames;
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByName(String name) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByName(name);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorByName(name);
            }
            return fd;
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorBySymbol(String symbol) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorBySymbol(symbol);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorBySymbol(symbol);
            }
            return fd;
        }

        @Nullable
        private Descriptors.FileDescriptor getFileDescriptorByExtensionAndNumber(String type, int extension) {
            Descriptors.FileDescriptor fd = this.immutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            if (fd == null) {
                fd = this.mutableServicesIndex.getFileDescriptorByExtensionAndNumber(type, extension);
            }
            return fd;
        }

        @Nullable
        private Set<Integer> getExtensionNumbersOfType(String type) {
            Set extensionNumbers = this.immutableServicesIndex.getExtensionNumbersOfType(type);
            if (extensionNumbers == null) {
                extensionNumbers = this.mutableServicesIndex.getExtensionNumbersOfType(type);
            }
            return extensionNumbers;
        }
    }

    private static class ProtoReflectionStreamObserver
    implements Runnable,
    StreamObserver<ServerReflectionRequest> {
        private final ServerReflectionIndex serverReflectionIndex;
        private final ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver;
        private boolean closeAfterSend = false;
        private ServerReflectionRequest request;

        ProtoReflectionStreamObserver(ServerReflectionIndex serverReflectionIndex, ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver) {
            this.serverReflectionIndex = serverReflectionIndex;
            this.serverCallStreamObserver = Preconditions.checkNotNull(serverCallStreamObserver, "observer");
        }

        @Override
        public void run() {
            if (this.request != null) {
                this.handleReflectionRequest();
            }
        }

        @Override
        public void onNext(ServerReflectionRequest request) {
            Preconditions.checkState(this.request == null);
            this.request = Preconditions.checkNotNull(request);
            this.handleReflectionRequest();
        }

        private void handleReflectionRequest() {
            if (this.serverCallStreamObserver.isReady()) {
                switch (this.request.getMessageRequestCase()) {
                    case FILE_BY_FILENAME: {
                        this.getFileByName(this.request);
                        break;
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        this.getFileContainingSymbol(this.request);
                        break;
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        this.getFileByExtension(this.request);
                        break;
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        this.getAllExtensions(this.request);
                        break;
                    }
                    case LIST_SERVICES: {
                        this.listServices(this.request);
                        break;
                    }
                    default: {
                        this.sendErrorResponse(this.request, Status.Code.UNIMPLEMENTED, "not implemented " + this.request.getMessageRequestCase());
                    }
                }
                this.request = null;
                if (this.closeAfterSend) {
                    this.serverCallStreamObserver.onCompleted();
                } else {
                    this.serverCallStreamObserver.request(1);
                }
            }
        }

        @Override
        public void onCompleted() {
            if (this.request != null) {
                this.closeAfterSend = true;
            } else {
                this.serverCallStreamObserver.onCompleted();
            }
        }

        @Override
        public void onError(Throwable cause) {
            this.serverCallStreamObserver.onError(cause);
        }

        private void getFileByName(ServerReflectionRequest request) {
            String name = request.getFileByFilename();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorByName(name);
            if (fd != null) {
                this.serverCallStreamObserver.onNext(this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "File not found.");
            }
        }

        private void getFileContainingSymbol(ServerReflectionRequest request) {
            String symbol = request.getFileContainingSymbol();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorBySymbol(symbol);
            if (fd != null) {
                this.serverCallStreamObserver.onNext(this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found.");
            }
        }

        private void getFileByExtension(ServerReflectionRequest request) {
            int extension;
            ExtensionRequest extensionRequest = request.getFileContainingExtension();
            String type = extensionRequest.getContainingType();
            Descriptors.FileDescriptor fd = this.serverReflectionIndex.getFileDescriptorByExtensionAndNumber(type, extension = extensionRequest.getExtensionNumber());
            if (fd != null) {
                this.serverCallStreamObserver.onNext(this.createServerReflectionResponse(request, fd));
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Extension not found.");
            }
        }

        private void getAllExtensions(ServerReflectionRequest request) {
            String type = request.getAllExtensionNumbersOfType();
            Set extensions = this.serverReflectionIndex.getExtensionNumbersOfType(type);
            if (extensions != null) {
                ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
                this.serverCallStreamObserver.onNext(ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build());
            } else {
                this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Type not found.");
            }
        }

        private void listServices(ServerReflectionRequest request) {
            ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
            for (String serviceName : this.serverReflectionIndex.getServiceNames()) {
                builder.addService(ServiceResponse.newBuilder().setName(serviceName));
            }
            this.serverCallStreamObserver.onNext(ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(builder).build());
        }

        private void sendErrorResponse(ServerReflectionRequest request, Status.Code code, String message) {
            ServerReflectionResponse response = ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.value()).setErrorMessage(message)).build();
            this.serverCallStreamObserver.onNext(response);
        }

        private ServerReflectionResponse createServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
            FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
            HashSet<String> seenFiles = new HashSet<String>();
            ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
            seenFiles.add(fd.getName());
            frontier.add(fd);
            while (!frontier.isEmpty()) {
                Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
                fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
                for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    frontier.add(dependencyFd);
                }
            }
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
        }
    }
}

