/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.rls.AdaptiveThrottler;
import io.grpc.rls.CachingRlsLbClient;
import io.grpc.rls.ChildLbResolvedAddressFactory;
import io.grpc.rls.LbPolicyConfiguration;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.MoreObjects;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

final class RlsLoadBalancer
extends LoadBalancer {
    private final ChannelLogger logger;
    private final LoadBalancer.Helper helper;
    @VisibleForTesting
    CachingRlsLbClientBuilderProvider cachingRlsLbClientBuilderProvider = new DefaultCachingRlsLbClientBuilderProvider();
    @Nullable
    private LbPolicyConfiguration lbPolicyConfiguration;
    @Nullable
    private CachingRlsLbClient routeLookupClient;

    RlsLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.logger = helper.getChannelLogger();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb created. Authority: {0}", helper.getAuthority());
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        LbPolicyConfiguration lbPolicyConfiguration = (LbPolicyConfiguration)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(lbPolicyConfiguration, "Missing RLS LB config");
        if (!lbPolicyConfiguration.equals(this.lbPolicyConfiguration)) {
            boolean needToConnect;
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "A new RLS LB config received: {0}", lbPolicyConfiguration);
            boolean bl = needToConnect = this.lbPolicyConfiguration == null || !this.lbPolicyConfiguration.getRouteLookupConfig().lookupService().equals(lbPolicyConfiguration.getRouteLookupConfig().lookupService());
            if (needToConnect) {
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS lookup service changed, need to connect");
                if (this.routeLookupClient != null) {
                    this.routeLookupClient.close();
                }
                this.routeLookupClient = this.cachingRlsLbClientBuilderProvider.get().setHelper(this.helper).setLbPolicyConfig(lbPolicyConfiguration).setResolvedAddressesFactory(new ChildLbResolvedAddressFactory(resolvedAddresses.getAddresses(), resolvedAddresses.getAttributes())).build();
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "LbPolicyConfiguration updated to {0}", lbPolicyConfiguration);
            }
            this.lbPolicyConfiguration = lbPolicyConfiguration;
        }
        return Status.OK;
    }

    @Override
    public void requestConnection() {
        if (this.routeLookupClient != null) {
            this.routeLookupClient.requestConnection();
        }
    }

    @Override
    public void handleNameResolutionError(final Status error) {
        if (this.routeLookupClient != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "closing the routeLookupClient on a name resolution error");
            this.routeLookupClient.close();
            this.routeLookupClient = null;
            this.lbPolicyConfiguration = null;
        }
        class ErrorPicker
        extends LoadBalancer.SubchannelPicker {
            ErrorPicker() {
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return LoadBalancer.PickResult.withError(error);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("error", error).toString();
            }
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ErrorPicker());
    }

    @Override
    public void shutdown() {
        if (this.routeLookupClient != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "closing the routeLookupClient because of RLS LB shutdown");
            this.routeLookupClient.close();
            this.routeLookupClient = null;
        }
    }

    static final class DefaultCachingRlsLbClientBuilderProvider
    implements CachingRlsLbClientBuilderProvider {
        DefaultCachingRlsLbClientBuilderProvider() {
        }

        @Override
        public CachingRlsLbClient.Builder get() {
            return CachingRlsLbClient.newBuilder().setThrottler(AdaptiveThrottler.builder().build());
        }
    }

    static interface CachingRlsLbClientBuilderProvider {
        public CachingRlsLbClient.Builder get();
    }
}

