/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import io.grpc.Internal;
import io.grpc.Status;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.ReferenceCounted;
import io.grpc.xds.client.Stats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.base.Stopwatch;
import org.apache.pinot.shaded.com.google.common.base.Supplier;
import org.apache.pinot.shaded.com.google.common.collect.Sets;

@ThreadSafe
@Internal
public final class LoadStatsManager2 {
    private final Map<String, Map<String, ReferenceCounted<ClusterDropStats>>> allDropStats = new HashMap<String, Map<String, ReferenceCounted<ClusterDropStats>>>();
    private final Map<String, Map<String, Map<Locality, ReferenceCounted<ClusterLocalityStats>>>> allLoadStats = new HashMap<String, Map<String, Map<Locality, ReferenceCounted<ClusterLocalityStats>>>>();
    private final Supplier<Stopwatch> stopwatchSupplier;

    @VisibleForTesting
    public LoadStatsManager2(Supplier<Stopwatch> stopwatchSupplier) {
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
    }

    @VisibleForTesting
    public synchronized ClusterDropStats getClusterDropStats(String cluster, @Nullable String edsServiceName) {
        Map<String, ReferenceCounted<ClusterDropStats>> perClusterCounters;
        if (!this.allDropStats.containsKey(cluster)) {
            this.allDropStats.put(cluster, new HashMap());
        }
        if (!(perClusterCounters = this.allDropStats.get(cluster)).containsKey(edsServiceName)) {
            perClusterCounters.put(edsServiceName, ReferenceCounted.wrap(new ClusterDropStats(cluster, edsServiceName, this.stopwatchSupplier.get())));
        }
        ReferenceCounted<ClusterDropStats> ref = perClusterCounters.get(edsServiceName);
        ref.retain();
        return ref.get();
    }

    private synchronized void releaseClusterDropCounter(String cluster, @Nullable String edsServiceName) {
        Preconditions.checkState(this.allDropStats.containsKey(cluster) && this.allDropStats.get(cluster).containsKey(edsServiceName), "stats for cluster %s, edsServiceName %s do not exist", (Object)cluster, (Object)edsServiceName);
        ReferenceCounted<ClusterDropStats> ref = this.allDropStats.get(cluster).get(edsServiceName);
        ref.release();
    }

    @VisibleForTesting
    public synchronized ClusterLocalityStats getClusterLocalityStats(String cluster, @Nullable String edsServiceName, Locality locality) {
        Map<Locality, ReferenceCounted<ClusterLocalityStats>> localityStats;
        Map<String, Map<Locality, ReferenceCounted<ClusterLocalityStats>>> perClusterCounters;
        if (!this.allLoadStats.containsKey(cluster)) {
            this.allLoadStats.put(cluster, new HashMap());
        }
        if (!(perClusterCounters = this.allLoadStats.get(cluster)).containsKey(edsServiceName)) {
            perClusterCounters.put(edsServiceName, new HashMap());
        }
        if (!(localityStats = perClusterCounters.get(edsServiceName)).containsKey(locality)) {
            localityStats.put(locality, ReferenceCounted.wrap(new ClusterLocalityStats(cluster, edsServiceName, locality, this.stopwatchSupplier.get())));
        }
        ReferenceCounted<ClusterLocalityStats> ref = localityStats.get(locality);
        ref.retain();
        return ref.get();
    }

    private synchronized void releaseClusterLocalityLoadCounter(String cluster, @Nullable String edsServiceName, Locality locality) {
        Preconditions.checkState(this.allLoadStats.containsKey(cluster) && this.allLoadStats.get(cluster).containsKey(edsServiceName) && this.allLoadStats.get(cluster).get(edsServiceName).containsKey(locality), "stats for cluster %s, edsServiceName %s, locality %s not exits", (Object)cluster, (Object)edsServiceName, (Object)locality);
        ReferenceCounted<ClusterLocalityStats> ref = this.allLoadStats.get(cluster).get(edsServiceName).get(locality);
        ref.release();
    }

    public synchronized List<Stats.ClusterStats> getClusterStatsReports(String cluster) {
        Stats.ClusterStats.Builder builder;
        HashSet<String> toDiscard;
        if (!this.allDropStats.containsKey(cluster) && !this.allLoadStats.containsKey(cluster)) {
            return Collections.emptyList();
        }
        Map<String, ReferenceCounted<ClusterDropStats>> clusterDropStats = this.allDropStats.get(cluster);
        Map<String, Map<Locality, ReferenceCounted<ClusterLocalityStats>>> clusterLoadStats = this.allLoadStats.get(cluster);
        HashMap<String, Stats.ClusterStats.Builder> statsReportBuilders = new HashMap<String, Stats.ClusterStats.Builder>();
        if (clusterDropStats != null) {
            toDiscard = new HashSet<String>();
            for (String edsServiceName : clusterDropStats.keySet()) {
                ReferenceCounted<ClusterDropStats> ref;
                builder = Stats.ClusterStats.newBuilder().clusterName(cluster);
                if (edsServiceName != null) {
                    builder.clusterServiceName(edsServiceName);
                }
                if ((ref = clusterDropStats.get(edsServiceName)).getReferenceCount() == 0) {
                    toDiscard.add(edsServiceName);
                }
                ClusterDropStatsSnapshot dropStatsSnapshot = ref.get().snapshot();
                long totalCategorizedDrops = 0L;
                for (Map.Entry entry : dropStatsSnapshot.categorizedDrops.entrySet()) {
                    builder.addDroppedRequests(Stats.DroppedRequests.create((String)entry.getKey(), (Long)entry.getValue()));
                    totalCategorizedDrops += ((Long)entry.getValue()).longValue();
                }
                builder.totalDroppedRequests(totalCategorizedDrops + dropStatsSnapshot.uncategorizedDrops);
                builder.loadReportIntervalNano(dropStatsSnapshot.durationNano);
                statsReportBuilders.put(edsServiceName, builder);
            }
            clusterDropStats.keySet().removeAll(toDiscard);
        }
        if (clusterLoadStats != null) {
            toDiscard = new HashSet();
            for (String edsServiceName : clusterLoadStats.keySet()) {
                builder = (Stats.ClusterStats.Builder)statsReportBuilders.get(edsServiceName);
                if (builder == null) {
                    builder = Stats.ClusterStats.newBuilder().clusterName(cluster);
                    if (edsServiceName != null) {
                        builder.clusterServiceName(edsServiceName);
                    }
                    statsReportBuilders.put(edsServiceName, builder);
                }
                Map<Locality, ReferenceCounted<ClusterLocalityStats>> localityStats = clusterLoadStats.get(edsServiceName);
                HashSet<Locality> localitiesToDiscard = new HashSet<Locality>();
                for (Locality locality : localityStats.keySet()) {
                    ReferenceCounted<ClusterLocalityStats> ref = localityStats.get(locality);
                    ClusterLocalityStatsSnapshot snapshot = ref.get().snapshot();
                    if (ref.getReferenceCount() == 0 && snapshot.callsInProgress == 0L) {
                        localitiesToDiscard.add(locality);
                    }
                    Stats.UpstreamLocalityStats upstreamLocalityStats = Stats.UpstreamLocalityStats.create(locality, snapshot.callsIssued, snapshot.callsSucceeded, snapshot.callsFailed, snapshot.callsInProgress, snapshot.loadMetricStatsMap);
                    builder.addUpstreamLocalityStats(upstreamLocalityStats);
                    builder.loadReportIntervalNano(Math.max(builder.loadReportIntervalNano(), snapshot.durationNano));
                }
                localityStats.keySet().removeAll(localitiesToDiscard);
                if (!localityStats.isEmpty()) continue;
                toDiscard.add(edsServiceName);
            }
            clusterLoadStats.keySet().removeAll(toDiscard);
        }
        ArrayList<Stats.ClusterStats> res = new ArrayList<Stats.ClusterStats>();
        for (Stats.ClusterStats.Builder builder2 : statsReportBuilders.values()) {
            res.add(builder2.build());
        }
        return Collections.unmodifiableList(res);
    }

    synchronized List<Stats.ClusterStats> getAllClusterStatsReports() {
        Sets.SetView<String> allClusters = Sets.union(this.allDropStats.keySet(), this.allLoadStats.keySet());
        ArrayList<Stats.ClusterStats> res = new ArrayList<Stats.ClusterStats>();
        for (String cluster : allClusters) {
            res.addAll(this.getClusterStatsReports(cluster));
        }
        return Collections.unmodifiableList(res);
    }

    private static final class ClusterLocalityStatsSnapshot {
        private final long callsSucceeded;
        private final long callsInProgress;
        private final long callsFailed;
        private final long callsIssued;
        private final long durationNano;
        private final Map<String, Stats.BackendLoadMetricStats> loadMetricStatsMap;

        private ClusterLocalityStatsSnapshot(long callsSucceeded, long callsInProgress, long callsFailed, long callsIssued, long durationNano, Map<String, Stats.BackendLoadMetricStats> loadMetricStatsMap) {
            this.callsSucceeded = callsSucceeded;
            this.callsInProgress = callsInProgress;
            this.callsFailed = callsFailed;
            this.callsIssued = callsIssued;
            this.durationNano = durationNano;
            this.loadMetricStatsMap = Collections.unmodifiableMap(Preconditions.checkNotNull(loadMetricStatsMap, "loadMetricStatsMap"));
        }
    }

    @ThreadSafe
    public final class ClusterLocalityStats {
        private final String clusterName;
        @Nullable
        private final String edsServiceName;
        private final Locality locality;
        private final Stopwatch stopwatch;
        private final AtomicLong callsInProgress = new AtomicLong();
        private final AtomicLong callsSucceeded = new AtomicLong();
        private final AtomicLong callsFailed = new AtomicLong();
        private final AtomicLong callsIssued = new AtomicLong();
        private Map<String, Stats.BackendLoadMetricStats> loadMetricStatsMap = new HashMap<String, Stats.BackendLoadMetricStats>();

        private ClusterLocalityStats(@Nullable String clusterName, String edsServiceName, Locality locality, Stopwatch stopwatch) {
            this.clusterName = Preconditions.checkNotNull(clusterName, "clusterName");
            this.edsServiceName = edsServiceName;
            this.locality = Preconditions.checkNotNull(locality, "locality");
            this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
            stopwatch.reset().start();
        }

        public void recordCallStarted() {
            this.callsIssued.getAndIncrement();
            this.callsInProgress.getAndIncrement();
        }

        public void recordCallFinished(Status status) {
            this.callsInProgress.getAndDecrement();
            if (status.isOk()) {
                this.callsSucceeded.getAndIncrement();
            } else {
                this.callsFailed.getAndIncrement();
            }
        }

        public synchronized void recordBackendLoadMetricStats(Map<String, Double> namedMetrics) {
            namedMetrics.forEach((name, value) -> {
                if (!this.loadMetricStatsMap.containsKey(name)) {
                    this.loadMetricStatsMap.put((String)name, new Stats.BackendLoadMetricStats(1L, (double)value));
                } else {
                    this.loadMetricStatsMap.get(name).addMetricValueAndIncrementRequestsFinished((double)value);
                }
            });
        }

        public void release() {
            LoadStatsManager2.this.releaseClusterLocalityLoadCounter(this.clusterName, this.edsServiceName, this.locality);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClusterLocalityStatsSnapshot snapshot() {
            Map<String, Stats.BackendLoadMetricStats> loadMetricStatsMapCopy;
            long duration = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.stopwatch.reset().start();
            ClusterLocalityStats clusterLocalityStats = this;
            synchronized (clusterLocalityStats) {
                loadMetricStatsMapCopy = Collections.unmodifiableMap(this.loadMetricStatsMap);
                this.loadMetricStatsMap = new HashMap<String, Stats.BackendLoadMetricStats>();
            }
            return new ClusterLocalityStatsSnapshot(this.callsSucceeded.getAndSet(0L), this.callsInProgress.get(), this.callsFailed.getAndSet(0L), this.callsIssued.getAndSet(0L), duration, loadMetricStatsMapCopy);
        }
    }

    private static final class ClusterDropStatsSnapshot {
        private final Map<String, Long> categorizedDrops;
        private final long uncategorizedDrops;
        private final long durationNano;

        private ClusterDropStatsSnapshot(Map<String, Long> categorizedDrops, long uncategorizedDrops, long durationNano) {
            this.categorizedDrops = Collections.unmodifiableMap(Preconditions.checkNotNull(categorizedDrops, "categorizedDrops"));
            this.uncategorizedDrops = uncategorizedDrops;
            this.durationNano = durationNano;
        }
    }

    @ThreadSafe
    public final class ClusterDropStats {
        private final String clusterName;
        @Nullable
        private final String edsServiceName;
        private final AtomicLong uncategorizedDrops = new AtomicLong();
        private final ConcurrentMap<String, AtomicLong> categorizedDrops = new ConcurrentHashMap<String, AtomicLong>();
        private final Stopwatch stopwatch;

        private ClusterDropStats(@Nullable String clusterName, String edsServiceName, Stopwatch stopwatch) {
            this.clusterName = Preconditions.checkNotNull(clusterName, "clusterName");
            this.edsServiceName = edsServiceName;
            this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
            stopwatch.reset().start();
        }

        public void recordDroppedRequest(String category) {
            AtomicLong counter = this.categorizedDrops.putIfAbsent(category, new AtomicLong(1L));
            if (counter != null) {
                counter.getAndIncrement();
            }
        }

        public void recordDroppedRequest() {
            this.uncategorizedDrops.getAndIncrement();
        }

        public void release() {
            LoadStatsManager2.this.releaseClusterDropCounter(this.clusterName, this.edsServiceName);
        }

        private ClusterDropStatsSnapshot snapshot() {
            HashMap<String, Long> drops = new HashMap<String, Long>();
            for (Map.Entry entry : this.categorizedDrops.entrySet()) {
                drops.put((String)entry.getKey(), ((AtomicLong)entry.getValue()).get());
            }
            this.categorizedDrops.clear();
            long duration = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.stopwatch.reset().start();
            return new ClusterDropStatsSnapshot(drops, this.uncategorizedDrops.getAndSet(0L), duration);
        }
    }
}

