/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.CuratorConnectionLossException;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.drivers.OperationTrace;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.imps.EnsembleTracker;
import org.apache.curator.framework.imps.FailedDeleteManager;
import org.apache.curator.framework.imps.FailedRemoveWatchManager;
import org.apache.curator.framework.imps.FrameworkUtils;
import org.apache.curator.framework.imps.InternalConnectionHandler;
import org.apache.curator.framework.imps.NamespaceFacadeCache;
import org.apache.curator.framework.imps.NamespaceImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.imps.StandardInternalConnectionHandler;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.curator.framework.schema.SchemaSet;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateErrorPolicy;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.framework.state.ConnectionStateManager;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZookeeperCompatibility;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CuratorFrameworkImpl
extends CuratorFrameworkBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorZookeeperClient client;
    private final StandardListenerManager<CuratorListener> listeners;
    private final StandardListenerManager<UnhandledErrorListener> unhandledErrorListeners;
    private final ThreadFactory threadFactory;
    private final int maxCloseWaitMs;
    private final BlockingQueue<OperationAndData<?>> backgroundOperations;
    private final BlockingQueue<OperationAndData<?>> forcedSleepOperations;
    private final NamespaceImpl namespace;
    private final ConnectionStateManager connectionStateManager;
    private final List<AuthInfo> authInfos;
    private final byte[] defaultData;
    private final FailedDeleteManager failedDeleteManager;
    private final FailedRemoveWatchManager failedRemoveWatcherManager;
    private final CompressionProvider compressionProvider;
    private final boolean compressionEnabled;
    private final ACLProvider aclProvider;
    private final NamespaceFacadeCache namespaceFacadeCache;
    private final boolean useContainerParentsIfAvailable;
    private final ConnectionStateErrorPolicy connectionStateErrorPolicy;
    private final AtomicLong currentInstanceIndex = new AtomicLong(-1L);
    private final InternalConnectionHandler internalConnectionHandler;
    private final EnsembleTracker ensembleTracker;
    private final SchemaSet schemaSet;
    private final Executor runSafeService;
    private final ZookeeperCompatibility zookeeperCompatibility;
    private volatile ExecutorService executorService;
    private final AtomicBoolean logAsErrorConnectionErrors = new AtomicBoolean(false);
    private static final boolean LOG_ALL_CONNECTION_ISSUES_AS_ERROR_LEVEL = !Boolean.getBoolean("curator-log-only-first-connection-issue-as-error-level");
    volatile DebugBackgroundListener debugListener = null;
    @VisibleForTesting
    public volatile UnhandledErrorListener debugUnhandledErrorListener = null;
    private final AtomicReference<CuratorFrameworkState> state;
    private final Object closeLock = new Object();
    @VisibleForTesting
    volatile CountDownLatch debugCheckBackgroundRetryLatch;
    @VisibleForTesting
    volatile CountDownLatch debugCheckBackgroundRetryReadyLatch;
    @VisibleForTesting
    volatile KeeperException.Code injectedCode;
    @VisibleForTesting
    volatile long sleepAndQueueOperationSeconds = 1L;

    public CuratorFrameworkImpl(CuratorFrameworkFactory.Builder builder) {
        ZookeeperFactory localZookeeperFactory = this.makeZookeeperFactory(builder.getZookeeperFactory(), builder.getZkClientConfig());
        this.client = new CuratorZookeeperClient(localZookeeperFactory, builder.getEnsembleProvider(), builder.getSessionTimeoutMs(), builder.getConnectionTimeoutMs(), builder.getWaitForShutdownTimeoutMs(), new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                CuratorEventImpl event = new CuratorEventImpl(CuratorFrameworkImpl.this, CuratorEventType.WATCHED, watchedEvent.getState().getIntValue(), CuratorFrameworkImpl.this.unfixForNamespace(watchedEvent.getPath()), null, null, null, null, null, watchedEvent, null, null);
                CuratorFrameworkImpl.this.processEvent(event);
            }
        }, builder.getRetryPolicy(), builder.canBeReadOnly());
        this.internalConnectionHandler = new StandardInternalConnectionHandler();
        this.listeners = StandardListenerManager.standard();
        this.unhandledErrorListeners = StandardListenerManager.standard();
        this.backgroundOperations = new DelayQueue();
        this.forcedSleepOperations = new LinkedBlockingQueue();
        this.namespace = new NamespaceImpl(this, builder.getNamespace());
        this.threadFactory = this.getThreadFactory(builder);
        this.maxCloseWaitMs = builder.getMaxCloseWaitMs();
        this.connectionStateManager = new ConnectionStateManager(this, builder.getThreadFactory(), builder.getSessionTimeoutMs(), builder.getSimulatedSessionExpirationPercent(), builder.getConnectionStateListenerManagerFactory());
        this.compressionProvider = builder.getCompressionProvider();
        this.compressionEnabled = builder.compressionEnabled();
        this.aclProvider = builder.getAclProvider();
        this.state = new AtomicReference<CuratorFrameworkState>(CuratorFrameworkState.LATENT);
        this.useContainerParentsIfAvailable = builder.useContainerParentsIfAvailable();
        this.connectionStateErrorPolicy = Preconditions.checkNotNull(builder.getConnectionStateErrorPolicy(), "errorPolicy cannot be null");
        this.schemaSet = Preconditions.checkNotNull(builder.getSchemaSet(), "schemaSet cannot be null");
        byte[] builderDefaultData = builder.getDefaultData();
        this.defaultData = builderDefaultData != null ? Arrays.copyOf(builderDefaultData, builderDefaultData.length) : new byte[]{};
        this.authInfos = this.buildAuths(builder);
        this.failedDeleteManager = new FailedDeleteManager(this);
        this.failedRemoveWatcherManager = new FailedRemoveWatchManager(this);
        this.namespaceFacadeCache = new NamespaceFacadeCache(this);
        this.ensembleTracker = builder.withEnsembleTracker() ? new EnsembleTracker(this, builder.getEnsembleProvider()) : null;
        this.runSafeService = this.makeRunSafeService(builder);
        this.zookeeperCompatibility = builder.getZookeeperCompatibility();
    }

    private Executor makeRunSafeService(CuratorFrameworkFactory.Builder builder) {
        if (builder.getRunSafeService() != null) {
            return builder.getRunSafeService();
        }
        ThreadFactory threadFactory = builder.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory("SafeNotifyService");
        }
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    private List<AuthInfo> buildAuths(CuratorFrameworkFactory.Builder builder) {
        ImmutableList.Builder builder1 = ImmutableList.builder();
        if (builder.getAuthInfos() != null) {
            builder1.addAll(builder.getAuthInfos());
        }
        return builder1.build();
    }

    @Override
    public CompletableFuture<Void> runSafe(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.runSafeService);
    }

    @Override
    public QuorumVerifier getCurrentConfig() {
        return this.ensembleTracker != null ? this.ensembleTracker.getCurrentConfig() : null;
    }

    private ZookeeperFactory makeZookeeperFactory(final ZookeeperFactory actualZookeeperFactory, final ZKClientConfig zkClientConfig) {
        return new ZookeeperFactory(){
            final /* synthetic */ CuratorFrameworkImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
                ZooKeeper zooKeeper = actualZookeeperFactory.newZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly, zkClientConfig);
                this.this$0.addAuthInfos(zooKeeper);
                return zooKeeper;
            }
        };
    }

    private void addAuthInfos(ZooKeeper zooKeeper) {
        for (AuthInfo auth : this.authInfos) {
            zooKeeper.addAuthInfo(auth.getScheme(), auth.getAuth());
        }
    }

    private ThreadFactory getThreadFactory(CuratorFrameworkFactory.Builder builder) {
        ThreadFactory threadFactory = builder.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = ThreadUtils.newThreadFactory("Framework");
        }
        return threadFactory;
    }

    @Override
    public void clearWatcherReferences(Watcher watcher) {
    }

    @Override
    public CuratorFrameworkState getState() {
        return this.state.get();
    }

    @Override
    @Deprecated
    public boolean isStarted() {
        return this.state.get() == CuratorFrameworkState.STARTED;
    }

    @Override
    public boolean blockUntilConnected(int maxWaitTime, TimeUnit units) throws InterruptedException {
        return this.connectionStateManager.blockUntilConnected(maxWaitTime, units);
    }

    @Override
    public void blockUntilConnected() throws InterruptedException {
        this.blockUntilConnected(0, null);
    }

    @Override
    public ConnectionStateErrorPolicy getConnectionStateErrorPolicy() {
        return this.connectionStateErrorPolicy;
    }

    @Override
    public void start() {
        this.log.info("Starting");
        if (!this.state.compareAndSet(CuratorFrameworkState.LATENT, CuratorFrameworkState.STARTED)) {
            throw new IllegalStateException("Cannot be started more than once");
        }
        try {
            this.connectionStateManager.start();
            ConnectionStateListener listener = new ConnectionStateListener(){

                @Override
                public void stateChanged(CuratorFramework client, ConnectionState newState) {
                    if (ConnectionState.CONNECTED == newState || ConnectionState.RECONNECTED == newState) {
                        CuratorFrameworkImpl.this.logAsErrorConnectionErrors.set(true);
                    }
                }

                @Override
                public boolean doNotProxy() {
                    return true;
                }
            };
            this.getConnectionStateListenable().addListener(listener);
            this.client.start();
            this.executorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            this.executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CuratorFrameworkImpl.this.backgroundOperationsLoop();
                    return null;
                }
            });
            if (this.ensembleTracker != null) {
                this.ensembleTracker.start();
            }
            this.log.info(this.schemaSet.toDocumentation());
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.handleBackgroundOperationException(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeWithLock() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.state.compareAndSet(CuratorFrameworkState.STARTED, CuratorFrameworkState.STOPPED);
        }
    }

    @Override
    public void close() {
        this.log.debug("Closing");
        if (this.closeWithLock()) {
            this.listeners.forEach(listener -> {
                CuratorEventImpl event = new CuratorEventImpl(this, CuratorEventType.CLOSING, 0, null, null, null, null, null, null, null, null, null);
                try {
                    listener.eventReceived(this, event);
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    this.log.error("Exception while sending Closing event", e);
                }
            });
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(this.maxCloseWaitMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.ensembleTracker != null) {
                this.ensembleTracker.close();
            }
            this.backgroundOperations.forEach(OperationAndData::clearSleep);
            ArrayList droppedOperations = new ArrayList(this.backgroundOperations.size());
            this.backgroundOperations.drainTo(droppedOperations);
            droppedOperations.forEach(this::closeOperation);
            this.listeners.clear();
            this.unhandledErrorListeners.clear();
            this.connectionStateManager.close();
            this.client.close();
        }
    }

    @Override
    NamespaceImpl getNamespaceImpl() {
        return this.namespace;
    }

    @Override
    public CuratorFramework usingNamespace(String newNamespace) {
        this.checkState();
        return this.namespaceFacadeCache.get(newNamespace);
    }

    @Override
    public Listenable<ConnectionStateListener> getConnectionStateListenable() {
        return this.connectionStateManager.getListenable();
    }

    @Override
    public Listenable<CuratorListener> getCuratorListenable() {
        return this.listeners;
    }

    @Override
    public Listenable<UnhandledErrorListener> getUnhandledErrorListenable() {
        return this.unhandledErrorListeners;
    }

    @Override
    public CuratorZookeeperClient getZookeeperClient() {
        return this.client;
    }

    @Override
    public ZookeeperCompatibility getZookeeperCompatibility() {
        return this.zookeeperCompatibility;
    }

    @Override
    public EnsurePath newNamespaceAwareEnsurePath(String path) {
        return this.namespace.newNamespaceAwareEnsurePath(path);
    }

    @Override
    public SchemaSet getSchemaSet() {
        return this.schemaSet;
    }

    @Override
    public boolean compressionEnabled() {
        return this.compressionEnabled;
    }

    @Override
    ACLProvider getAclProvider() {
        return this.aclProvider;
    }

    @Override
    FailedDeleteManager getFailedDeleteManager() {
        return this.failedDeleteManager;
    }

    @Override
    FailedRemoveWatchManager getFailedRemoveWatcherManager() {
        return this.failedRemoveWatcherManager;
    }

    RetryLoop newRetryLoop() {
        return this.client.newRetryLoop();
    }

    @Override
    CompressionProvider getCompressionProvider() {
        return this.compressionProvider;
    }

    @Override
    boolean useContainerParentsIfAvailable() {
        return this.useContainerParentsIfAvailable;
    }

    @Override
    <DATA_TYPE> void processBackgroundOperation(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        boolean isInitialExecution;
        boolean bl = isInitialExecution = event == null;
        if (isInitialExecution) {
            this.performBackgroundOperation(operationAndData);
            return;
        }
        boolean doQueueOperation = false;
        KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
        if (code != KeeperException.Code.OK && this.getZookeeperClient().getRetryPolicy().allowRetry(KeeperException.create((KeeperException.Code)code))) {
            doQueueOperation = this.checkBackgroundRetry(operationAndData, event);
        } else if (operationAndData.getCallback() != null) {
            this.sendToBackgroundCallback(operationAndData, event);
        } else {
            this.processEvent(event);
        }
        if (doQueueOperation) {
            this.queueOperation(operationAndData);
        }
    }

    private void abortOperation(OperationAndData<?> operation, Throwable e) {
        if (operation.getCallback() == null) {
            return;
        }
        CuratorEventImpl event = e instanceof KeeperException ? new CuratorEventImpl(this, operation.getEventType(), ((KeeperException)e).code().intValue(), ((KeeperException)e).getPath(), null, operation.getContext(), null, null, null, null, null, null) : (this.getState() == CuratorFrameworkState.STARTED ? new CuratorEventImpl(this, operation.getEventType(), KeeperException.Code.SYSTEMERROR.intValue(), null, null, operation.getContext(), null, null, null, null, null, null) : new CuratorEventImpl(this, operation.getEventType(), KeeperException.Code.SESSIONEXPIRED.intValue(), null, null, operation.getContext(), null, null, null, null, null, null));
        this.sendToBackgroundCallback(operation, event);
    }

    private void closeOperation(OperationAndData<?> operation) {
        if (operation.getCallback() == null) {
            return;
        }
        CuratorEventImpl event = new CuratorEventImpl(this, operation.getEventType(), KeeperException.Code.SESSIONEXPIRED.intValue(), null, null, operation.getContext(), null, null, null, null, null, null);
        this.sendToBackgroundCallback(operation, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requeueSleepOperation(OperationAndData<?> operationAndData) {
        operationAndData.clearSleep();
        Object object = this.closeLock;
        synchronized (object) {
            if (this.getState() == CuratorFrameworkState.STARTED) {
                if (this.backgroundOperations.remove(operationAndData)) {
                    this.backgroundOperations.offer(operationAndData);
                }
                return;
            }
        }
        if (this.backgroundOperations.remove(operationAndData)) {
            this.closeOperation(operationAndData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <DATA_TYPE> boolean queueOperation(OperationAndData<DATA_TYPE> operationAndData) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.getState() == CuratorFrameworkState.STARTED) {
                this.backgroundOperations.offer(operationAndData);
                return true;
            }
        }
        this.closeOperation(operationAndData);
        return false;
    }

    @Override
    void logError(String reason, Throwable e) {
        if (reason == null || reason.length() == 0) {
            reason = "n/a";
        }
        if (!Boolean.getBoolean("curator-dont-log-connection-problems") || !(e instanceof KeeperException)) {
            if (e instanceof KeeperException.ConnectionLossException) {
                if (LOG_ALL_CONNECTION_ISSUES_AS_ERROR_LEVEL || this.logAsErrorConnectionErrors.compareAndSet(true, false)) {
                    this.log.error(reason, e);
                } else {
                    this.log.debug(reason, e);
                }
            } else {
                this.log.error(reason, e);
            }
        }
        String localReason = reason;
        this.unhandledErrorListeners.forEach(l -> l.unhandledError(localReason, e));
        if (this.debugUnhandledErrorListener != null) {
            this.debugUnhandledErrorListener.unhandledError(reason, e);
        }
    }

    @Override
    byte[] getDefaultData() {
        return this.defaultData;
    }

    @Override
    NamespaceFacadeCache getNamespaceFacadeCache() {
        return this.namespaceFacadeCache;
    }

    @Override
    void validateConnection(Watcher.Event.KeeperState state) {
        if (state == Watcher.Event.KeeperState.Disconnected) {
            this.internalConnectionHandler.suspendConnection(this);
        } else if (state == Watcher.Event.KeeperState.Expired) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        } else if (state == Watcher.Event.KeeperState.SyncConnected) {
            this.internalConnectionHandler.checkNewConnection(this);
            this.connectionStateManager.addStateChange(ConnectionState.RECONNECTED);
            this.unSleepBackgroundOperations();
        } else if (state == Watcher.Event.KeeperState.ConnectedReadOnly) {
            this.internalConnectionHandler.checkNewConnection(this);
            this.connectionStateManager.addStateChange(ConnectionState.READ_ONLY);
        }
    }

    void checkInstanceIndex() {
        long instanceIndex = this.client.getInstanceIndex();
        long newInstanceIndex = this.currentInstanceIndex.getAndSet(instanceIndex);
        if (newInstanceIndex >= 0L && instanceIndex != newInstanceIndex) {
            this.connectionStateManager.addStateChange(ConnectionState.LOST);
        }
    }

    boolean setToSuspended() {
        return this.connectionStateManager.setToSuspended();
    }

    void addStateChange(ConnectionState newConnectionState) {
        this.connectionStateManager.addStateChange(newConnectionState);
    }

    @Override
    EnsembleTracker getEnsembleTracker() {
        return this.ensembleTracker;
    }

    private <DATA_TYPE> boolean checkBackgroundRetry(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        boolean doRetry = false;
        if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs(), operationAndData)) {
            doRetry = true;
        } else {
            if (operationAndData.getErrorCallback() != null) {
                operationAndData.getErrorCallback().retriesExhausted(operationAndData);
            }
            if (operationAndData.getCallback() != null) {
                this.sendToBackgroundCallback(operationAndData, event);
            }
            KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
            Throwable e = null;
            try {
                e = code != null ? KeeperException.create((KeeperException.Code)code) : null;
            }
            catch (Throwable t2) {
                ThreadUtils.checkInterrupted(t2);
            }
            if (e == null) {
                e = new Exception("Unknown result codegetResultCode()");
            }
            if (this.debugCheckBackgroundRetryLatch != null) {
                if (this.debugCheckBackgroundRetryReadyLatch != null) {
                    this.debugCheckBackgroundRetryReadyLatch.countDown();
                }
                try {
                    this.debugCheckBackgroundRetryLatch.await();
                    if (this.injectedCode != null) {
                        code = this.injectedCode;
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.validateConnection(FrameworkUtils.codeToState(code));
            this.logError("Background operation retry gave up", e);
        }
        return doRetry;
    }

    private <DATA_TYPE> void sendToBackgroundCallback(OperationAndData<DATA_TYPE> operationAndData, CuratorEvent event) {
        try {
            operationAndData.getCallback().processResult(this, event);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.handleBackgroundOperationException(null, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private <DATA_TYPE> void handleBackgroundOperationException(OperationAndData<DATA_TYPE> operationAndData, Throwable e) {
        if (operationAndData != null && this.getZookeeperClient().getRetryPolicy().allowRetry(e)) {
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry-able exception received", e);
            }
            if (this.client.getRetryPolicy().allowRetry(operationAndData.getThenIncrementRetryCount(), operationAndData.getElapsedTimeMs(), operationAndData)) {
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retrying operation");
                }
                this.queueOperation(operationAndData);
                return;
            }
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry policy did not allow retry");
            }
            if (operationAndData.getErrorCallback() != null) {
                operationAndData.getErrorCallback().retriesExhausted(operationAndData);
            }
        }
        if (operationAndData != null) {
            this.abortOperation(operationAndData, e);
        }
        this.logError("Background exception was not retry-able or retry gave up", e);
    }

    private void backgroundOperationsLoop() {
        try {
            while (this.state.get() == CuratorFrameworkState.STARTED) {
                try {
                    OperationAndData<?> operationAndData = this.backgroundOperations.take();
                    if (this.debugListener != null) {
                        this.debugListener.listen(operationAndData);
                    }
                    this.performBackgroundOperation(operationAndData);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.log.info("backgroundOperationsLoop exiting");
        }
    }

    void performBackgroundOperation(OperationAndData<?> operationAndData) {
        try {
            if (!operationAndData.isConnectionRequired() || this.client.isConnected()) {
                operationAndData.callPerformBackgroundOperation();
                return;
            }
            this.client.getZooKeeper();
            if (operationAndData.getElapsedTimeMs() < (long)this.client.getConnectionTimeoutMs()) {
                this.sleepAndQueueOperation(operationAndData);
                return;
            }
            CuratorEventImpl event = new CuratorEventImpl(this, operationAndData.getEventType(), KeeperException.Code.CONNECTIONLOSS.intValue(), null, null, operationAndData.getContext(), null, null, null, null, null, null);
            if (this.checkBackgroundRetry(operationAndData, event)) {
                this.queueOperation(operationAndData);
            } else {
                this.logError("Background retry gave up", (Throwable)((Object)new CuratorConnectionLossException()));
            }
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted(e);
            this.handleBackgroundOperationException(operationAndData, e);
        }
    }

    private void sleepAndQueueOperation(OperationAndData<?> operationAndData) throws InterruptedException {
        operationAndData.sleepFor(this.sleepAndQueueOperationSeconds, TimeUnit.SECONDS);
        if (this.queueOperation(operationAndData)) {
            this.forcedSleepOperations.add(operationAndData);
        }
    }

    private void unSleepBackgroundOperations() {
        ArrayList drain = new ArrayList(this.forcedSleepOperations.size());
        this.forcedSleepOperations.drainTo(drain);
        this.log.debug("Clearing sleep for {} operations", (Object)drain.size());
        drain.forEach(this::requeueSleepOperation);
    }

    private void processEvent(CuratorEvent curatorEvent) {
        if (curatorEvent.getType() == CuratorEventType.WATCHED) {
            this.validateConnection(curatorEvent.getWatchedEvent().getState());
        }
        this.listeners.forEach(listener -> {
            try {
                OperationTrace trace = this.client.startAdvancedTracer("EventListener");
                listener.eventReceived(this, curatorEvent);
                trace.commit();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                this.logError("Event listener threw exception", e);
            }
        });
    }

    static interface DebugBackgroundListener {
        public void listen(OperationAndData<?> var1);
    }
}

