/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@XmlRootElement(name="metric")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineMetric {
    private Type type;
    private String id;
    private TimelineMetricOperation realtimeAggregationOp = TimelineMetricOperation.NOP;
    private TreeMap<Long, Number> values = new TreeMap(Collections.reverseOrder());

    public TimelineMetric() {
        this(Type.SINGLE_VALUE);
    }

    public TimelineMetric(Type type) {
        this.type = type;
    }

    @XmlElement(name="type")
    public Type getType() {
        return this.type;
    }

    public void setType(Type metricType) {
        this.type = metricType;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String metricId) {
        this.id = metricId;
    }

    @XmlElement(name="aggregationOp")
    public TimelineMetricOperation getRealtimeAggregationOp() {
        return this.realtimeAggregationOp;
    }

    public void setRealtimeAggregationOp(TimelineMetricOperation op) {
        this.realtimeAggregationOp = op;
    }

    @InterfaceAudience.Private
    @XmlElement(name="values")
    public TreeMap<Long, Number> getValuesJAXB() {
        return this.values;
    }

    public Map<Long, Number> getValues() {
        return this.values;
    }

    public void setValues(Map<Long, Number> vals) {
        if (this.type == Type.SINGLE_VALUE) {
            this.overwrite(vals);
        } else if (vals != null) {
            this.values = new TreeMap(Collections.reverseOrder());
            this.values.putAll(vals);
        } else {
            this.values = null;
        }
    }

    public void addValues(Map<Long, Number> vals) {
        if (this.type == Type.SINGLE_VALUE) {
            this.overwrite(vals);
        } else {
            this.values.putAll(vals);
        }
    }

    public void addValue(long timestamp, Number value) {
        if (this.type == Type.SINGLE_VALUE) {
            this.values.clear();
        }
        this.values.put(timestamp, value);
    }

    private void overwrite(Map<Long, Number> vals) {
        if (vals.size() > 1) {
            throw new IllegalArgumentException("Values cannot contain more than one point in " + (Object)((Object)Type.SINGLE_VALUE) + " mode");
        }
        this.values.clear();
        this.values.putAll(vals);
    }

    public boolean isValid() {
        return this.id != null;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimelineMetric)) {
            return false;
        }
        TimelineMetric m4 = (TimelineMetric)o;
        if (!this.id.equals(m4.id)) {
            return false;
        }
        return this.type == m4.type;
    }

    public String toString() {
        return "{id: " + this.id + ", type: " + (Object)((Object)this.type) + ", realtimeAggregationOp: " + (Object)((Object)this.realtimeAggregationOp) + "; " + this.values.toString() + "}";
    }

    public static TimelineMetric getLatestSingleValueMetric(TimelineMetric metric) {
        if (metric.getType() == Type.SINGLE_VALUE) {
            return metric;
        }
        TimelineMetric singleValueMetric = new TimelineMetric(Type.SINGLE_VALUE);
        Long firstKey = metric.values.firstKey();
        if (firstKey != null) {
            Number firstValue = metric.values.get(firstKey);
            singleValueMetric.addValue(firstKey, firstValue);
        }
        return singleValueMetric;
    }

    public long getSingleDataTimestamp() {
        if (this.type == Type.SINGLE_VALUE) {
            if (this.values.size() == 0) {
                throw new YarnRuntimeException("Values for this timeline metric is empty.");
            }
            return this.values.firstKey();
        }
        throw new YarnRuntimeException("Type for this timeline metric is not SINGLE_VALUE.");
    }

    public Number getSingleDataValue() {
        if (this.type == Type.SINGLE_VALUE) {
            if (this.values.size() == 0) {
                return null;
            }
            return this.values.get(this.values.firstKey());
        }
        throw new YarnRuntimeException("Type for this timeline metric is not SINGLE_VALUE.");
    }

    public static TimelineMetric aggregateTo(TimelineMetric incomingMetric, TimelineMetric baseAggregatedMetric) {
        return TimelineMetric.aggregateTo(incomingMetric, baseAggregatedMetric, null);
    }

    public static TimelineMetric aggregateTo(TimelineMetric incomingMetric, TimelineMetric baseAggregatedMetric, Map<Object, Object> state) {
        TimelineMetricOperation operation = incomingMetric.getRealtimeAggregationOp();
        return operation.aggregate(incomingMetric, baseAggregatedMetric, state);
    }

    public static enum Type {
        SINGLE_VALUE,
        TIME_SERIES;

    }
}

