/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.ingestion.batch.common;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.common.utils.TarCompressionUtils;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.spec.SegmentNameGeneratorSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentGenerationJobUtils
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGenerationJobUtils.class);

    private SegmentGenerationJobUtils() {
    }

    public static boolean useGlobalDirectorySequenceId(SegmentNameGeneratorSpec spec) {
        String useLocalDirectorySequenceId;
        if (spec == null || spec.getConfigs() == null) {
            return false;
        }
        String useGlobalDirectorySequenceId = (String)spec.getConfigs().get("use.global.directory.sequence.id");
        if (useGlobalDirectorySequenceId == null && (useLocalDirectorySequenceId = (String)spec.getConfigs().get("local.directory.sequence.id")) != null) {
            return !Boolean.parseBoolean(useLocalDirectorySequenceId);
        }
        return Boolean.parseBoolean(useGlobalDirectorySequenceId);
    }

    public static void createSegmentMetadataTarGz(File localSegmentDir, File localMetadataTarFile) throws Exception {
        final ArrayList metadataFiles = new ArrayList();
        Files.walkFileTree(localSegmentDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.getFileName().toString().equals("metadata.properties") || file.getFileName().toString().equals("creation.meta")) {
                    metadataFiles.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        LOGGER.info("Tarring metadata files from: [{}] to: {}", (Object)metadataFiles, (Object)localMetadataTarFile);
        TarCompressionUtils.createCompressedTarFile((File[])metadataFiles.toArray(new File[0]), (File)localMetadataTarFile);
    }

    public static void moveLocalTarFileToRemote(File localMetadataTarFile, URI outputMetadataTarURI, boolean overwrite) throws Exception {
        LOGGER.info("Trying to move metadata tar file from: [{}] to [{}]", (Object)localMetadataTarFile, (Object)outputMetadataTarURI);
        PinotFS outputPinotFS = PinotFSFactory.create((String)outputMetadataTarURI.getScheme());
        if (!overwrite && outputPinotFS.exists(outputMetadataTarURI)) {
            LOGGER.warn("Not overwrite existing output metadata tar file: {}", (Object)outputPinotFS.exists(outputMetadataTarURI));
        } else {
            outputPinotFS.copyFromLocalFile(localMetadataTarFile, outputMetadataTarURI);
        }
        FileUtils.deleteQuietly(localMetadataTarFile);
    }

    public static void moveFiles(PinotFS fs, URI sourceDir, URI destDir, boolean overwrite) throws IOException, URISyntaxException {
        for (String sourcePath : fs.listFiles(sourceDir, true)) {
            URI sourceFileUri = SegmentGenerationUtils.getFileURI((String)sourcePath, (URI)sourceDir);
            String sourceFilename = SegmentGenerationUtils.getFileName((URI)sourceFileUri);
            URI destFileUri = SegmentGenerationUtils.getRelativeOutputPath((URI)sourceDir, (URI)sourceFileUri, (URI)destDir).resolve(sourceFilename);
            if (!overwrite && fs.exists(destFileUri)) {
                LOGGER.warn("Can't overwrite existing output segment tar file: {}", (Object)destFileUri);
                continue;
            }
            fs.move(sourceFileUri, destFileUri, true);
        }
    }
}

