/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.thrift;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.plugin.inputformat.thrift.ThriftRecordExtractorConfig;
import org.apache.pinot.shaded.com.google.common.collect.Maps;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftRecordExtractor
extends BaseRecordExtractor<TBase> {
    private Map<String, Integer> _fieldIds;
    private Set<String> _fields;
    private boolean _extractAll = false;

    public void init(@Nullable Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        this._fieldIds = ((ThriftRecordExtractorConfig)recordExtractorConfig).getFieldIds();
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Set.of();
        } else {
            this._fields = Set.copyOf(fields);
        }
    }

    public GenericRow extract(TBase from, GenericRow to) {
        if (this._extractAll) {
            for (Map.Entry<String, Integer> nameToId : this._fieldIds.entrySet()) {
                Object value = from.getFieldValue(from.fieldForId(nameToId.getValue().intValue()));
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(nameToId.getKey(), value);
            }
        } else {
            for (String fieldName : this._fields) {
                Object value = null;
                Integer fieldId = this._fieldIds.get(fieldName);
                if (fieldId != null) {
                    value = from.getFieldValue(from.fieldForId(fieldId.intValue()));
                }
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldName, value);
            }
        }
        return to;
    }

    protected boolean isRecord(Object value) {
        return value instanceof TBase;
    }

    protected Map<Object, Object> convertRecord(Object value) {
        TBase record = (TBase)value;
        Set fields = FieldMetaData.getStructMetaDataMap(record.getClass()).keySet();
        HashMap convertedRecord = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (TFieldIdEnum field : fields) {
            Object fieldValue = record.getFieldValue(field);
            Object convertedValue = fieldValue != null ? this.convert(fieldValue) : null;
            convertedRecord.put(field.getFieldName(), convertedValue);
        }
        return convertedRecord;
    }
}

