/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="ExtendedSchema")
public class ExtendedSchema
extends Schema {
    public static final String ALIASES_DESC = "Aliases for the given subject";
    private List<String> aliases;

    @JsonCreator
    public ExtendedSchema(@JsonProperty(value="subject") String subject, @JsonProperty(value="version") Integer version, @JsonProperty(value="id") Integer id, @JsonProperty(value="schemaType") String schemaType, @JsonProperty(value="references") List<SchemaReference> references, @JsonProperty(value="metadata") Metadata metadata, @JsonProperty(value="ruleset") RuleSet ruleSet, @JsonProperty(value="schema") String schema2, @JsonProperty(value="aliases") List<String> aliases) {
        super(subject, version, id, schemaType, references, metadata, ruleSet, schema2);
        this.aliases = aliases;
    }

    public ExtendedSchema(Schema schema2, List<String> aliases) {
        super(schema2.getSubject(), schema2.getVersion(), schema2.getId(), schema2.getSchemaType(), schema2.getReferences(), schema2.getMetadata(), schema2.getRuleSet(), schema2.getSchema());
        this.aliases = aliases;
    }

    @Override
    public ExtendedSchema copy() {
        return new ExtendedSchema(this, this.aliases);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Aliases for the given subject")
    @JsonProperty(value="aliases")
    public List<String> getAliases() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedSchema that = (ExtendedSchema)o;
        return Objects.equals(this.aliases, that.aliases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aliases);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{subject=" + this.getSubject() + ",");
        sb.append("version=" + this.getVersion() + ",");
        sb.append("id=" + this.getId() + ",");
        sb.append("schemaType=" + this.getSchemaType() + ",");
        sb.append("references=" + this.getReferences() + ",");
        sb.append("metadata=" + this.getMetadata() + ",");
        sb.append("ruleSet=" + this.getRuleSet() + ",");
        sb.append("schema=" + this.getSchema() + ",");
        sb.append("schemaTags=" + this.getSchemaTags() + ",");
        sb.append("aliases=" + this.getAliases() + "}");
        return sb.toString();
    }
}

