/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.jackson;

import com.github.erosb.jsonsKema.JsonArray;
import com.github.erosb.jsonsKema.JsonBoolean;
import com.github.erosb.jsonsKema.JsonNull;
import com.github.erosb.jsonsKema.JsonNumber;
import com.github.erosb.jsonsKema.JsonObject;
import com.github.erosb.jsonsKema.JsonString;
import com.github.erosb.jsonsKema.JsonValue;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaBaseSerializer;
import io.confluent.kafka.schemaregistry.json.jackson.JsonSkemaObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public class JsonSkemaArraySerializer
extends JsonSkemaBaseSerializer<JsonArray> {
    private static final long serialVersionUID = 1L;
    public static final JsonSkemaArraySerializer instance = new JsonSkemaArraySerializer();

    public JsonSkemaArraySerializer() {
        super(JsonArray.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, JsonArray value) {
        return value == null || value.length() == 0;
    }

    @Override
    public void serialize(JsonArray value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeStartArray();
        this.serializeContents(value, g2, provider);
        g2.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonArray value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g2.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.START_ARRAY));
        this.serializeContents(value, g2, provider);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JsonArray value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            JsonValue ob = value.get(i);
            if (ob instanceof JsonNull) {
                g2.writeNull();
                continue;
            }
            if (ob instanceof JsonObject) {
                JsonSkemaObjectSerializer.instance.serialize((JsonObject)ob, g2, provider);
                continue;
            }
            if (ob instanceof JsonArray) {
                this.serialize((JsonArray)ob, g2, provider);
                continue;
            }
            if (ob instanceof JsonString) {
                g2.writeString(((JsonString)ob).getValue());
                continue;
            }
            if (ob instanceof JsonNumber) {
                Number num = ((JsonNumber)ob).getValue();
                if (num instanceof Double) {
                    g2.writeNumber(num.doubleValue());
                    continue;
                }
                if (num instanceof Float) {
                    g2.writeNumber(num.floatValue());
                    continue;
                }
                if (num instanceof Long) {
                    g2.writeNumber(num.longValue());
                    continue;
                }
                g2.writeNumber(num.intValue());
                continue;
            }
            if (ob instanceof JsonBoolean) {
                g2.writeBoolean(((JsonBoolean)ob).getValue());
                continue;
            }
            provider.defaultSerializeValue(ob, g2);
        }
    }
}

