/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleKind;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.rules.FieldTransform;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RuleExecutor;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldRuleExecutor
implements RuleExecutor {
    Logger log = LoggerFactory.getLogger(FieldRuleExecutor.class);
    public static final String PRESERVE_SOURCE_FIELDS = "preserve.source.fields";
    private Boolean preserveSource;

    @Override
    public void configure(Map<String, ?> configs) {
        Object preserveSourceConfig = configs.get(PRESERVE_SOURCE_FIELDS);
        if (preserveSourceConfig != null) {
            this.preserveSource = Boolean.parseBoolean(preserveSourceConfig.toString());
        }
    }

    public boolean isPreserveSource() {
        return Boolean.TRUE.equals(this.preserveSource);
    }

    public abstract FieldTransform newTransform(RuleContext var1) throws RuleException;

    @Override
    public Object transform(RuleContext ctx2, Object message) throws RuleException {
        String preserveValueConfig;
        if (this.preserveSource == null && (preserveValueConfig = ctx2.getParameter(PRESERVE_SOURCE_FIELDS)) != null) {
            this.preserveSource = Boolean.parseBoolean(preserveValueConfig);
        }
        switch (ctx2.ruleMode()) {
            case WRITE: 
            case UPGRADE: {
                Rule otherRule;
                int i;
                for (i = 0; i < ctx2.index(); ++i) {
                    otherRule = ctx2.rules().get(i);
                    if (!FieldRuleExecutor.areTransformsWithSameTags(ctx2.rule(), otherRule)) continue;
                    this.log.debug("Ignoring rule '{}' during {} as rule '{}' has the same tag(s)", new Object[]{ctx2.rule().getName(), ctx2.ruleMode(), otherRule.getName()});
                    return message;
                }
                break;
            }
            case READ: 
            case DOWNGRADE: {
                Rule otherRule;
                int i;
                for (i = ctx2.index() + 1; i < ctx2.rules().size(); ++i) {
                    otherRule = ctx2.rules().get(i);
                    if (!FieldRuleExecutor.areTransformsWithSameTags(ctx2.rule(), otherRule)) continue;
                    this.log.debug("Ignoring rule '{}' during {} as rule '{}' has the same tag(s)", new Object[]{ctx2.rule().getName(), ctx2.ruleMode(), otherRule.getName()});
                    return message;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rule mode " + (Object)((Object)ctx2.ruleMode()));
            }
        }
        try (FieldTransform transform = this.newTransform(ctx2);){
            if (transform != null) {
                if (ctx2.ruleMode() == RuleMode.WRITE && ctx2.rule().getKind() == RuleKind.TRANSFORM && this.isPreserveSource()) {
                    try {
                        message = ctx2.target().copyMessage(message);
                    }
                    catch (IOException e) {
                        throw new RuleException("Could not copy source message", e);
                    }
                }
                Object object = ctx2.target().transformMessage(ctx2, transform, message);
                return object;
            }
            Object object = message;
            return object;
        }
    }

    static boolean areTransformsWithSameTags(Rule rule1, Rule rule2) {
        return rule1.getTags().size() > 0 && rule1.getKind() == RuleKind.TRANSFORM && rule1.getKind() == rule2.getKind() && rule1.getMode() == rule2.getMode() && Objects.equals(rule1.getType(), rule2.getType()) && Objects.equals(rule1.getTags(), rule2.getTags());
    }
}

