/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.WrapperKeyDeserializerConfig;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class WrapperKeyDeserializer<T>
implements Deserializer<T> {
    private Deserializer<T> inner;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new WrapperKeyDeserializerConfig(configs), isKey);
    }

    protected void configure(WrapperKeyDeserializerConfig config, boolean isKey) {
        if (!isKey) {
            throw new IllegalArgumentException("WrapperKeyDeserializer is only for keys");
        }
        this.inner = config.getConfiguredInstance("wrapped.key.deserializer", Deserializer.class);
    }

    @Override
    public T deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T deserialize(String topic, Headers headers, byte[] bytes) {
        try {
            T t2 = this.inner.deserialize(topic, headers, bytes);
            return t2;
        }
        finally {
            AbstractKafkaSchemaSerDe.setKey(bytes);
        }
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

