/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava;

import java.io.Serializable;
import java.util.Set;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.Serializers;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.type.ReferenceType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.util.StdConverter;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.CacheSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.GuavaOptionalSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.MultimapSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.RangeSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.RangeSetSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser.TableSerializer;
import org.apache.pinot.shaded.com.google.common.base.Optional;
import org.apache.pinot.shaded.com.google.common.cache.Cache;
import org.apache.pinot.shaded.com.google.common.cache.CacheBuilder;
import org.apache.pinot.shaded.com.google.common.cache.CacheBuilderSpec;
import org.apache.pinot.shaded.com.google.common.collect.FluentIterable;
import org.apache.pinot.shaded.com.google.common.collect.Multimap;
import org.apache.pinot.shaded.com.google.common.collect.Range;
import org.apache.pinot.shaded.com.google.common.collect.RangeSet;
import org.apache.pinot.shaded.com.google.common.collect.Table;
import org.apache.pinot.shaded.com.google.common.hash.HashCode;
import org.apache.pinot.shaded.com.google.common.net.HostAndPort;
import org.apache.pinot.shaded.com.google.common.net.InternetDomainName;

public class GuavaSerializers
extends Serializers.Base
implements Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class<?> raw = refType.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
            return new GuavaOptionalSerializer(refType, staticTyping, contentTypeSerializer, contentValueSerializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        if (type.isTypeOrSubTypeOf(RangeSet.class)) {
            return new RangeSetSerializer();
        }
        if (type.isTypeOrSubTypeOf(Range.class)) {
            return new RangeSerializer(this._findDeclared(type, Range.class));
        }
        if (type.isTypeOrSubTypeOf(HostAndPort.class)) {
            return ToStringSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(InternetDomainName.class)) {
            return ToStringSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(CacheBuilderSpec.class) || type.isTypeOrSubTypeOf(CacheBuilder.class)) {
            return ToStringSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(HashCode.class)) {
            return ToStringSerializer.instance;
        }
        if (type.isTypeOrSubTypeOf(FluentIterable.class)) {
            JavaType iterableType = this._findDeclared(type, Iterable.class);
            return new StdDelegatingSerializer(FluentConverter.instance, iterableType, null);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (type.isTypeOrSubTypeOf(Multimap.class)) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            Object filterId = intr.findFilterId(beanDesc.getClassInfo());
            JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Multimap.class, beanDesc.getClassInfo());
            Set<String> ignored = ignorals == null ? null : ignorals.getIgnored();
            return new MultimapSerializer(type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer, ignored, filterId);
        }
        if (type.isTypeOrSubTypeOf(Cache.class)) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            Object filterId = intr.findFilterId(beanDesc.getClassInfo());
            JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Cache.class, beanDesc.getClassInfo());
            Set<String> ignored = ignorals == null ? null : ignorals.getIgnored();
            return new CacheSerializer(type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer, ignored, filterId);
        }
        if (type.isTypeOrSubTypeOf(Table.class)) {
            return new TableSerializer(type);
        }
        return null;
    }

    private JavaType _findDeclared(JavaType subtype, Class<?> target) {
        JavaType decl = subtype.findSuperType(target);
        if (decl == null) {
            throw new IllegalArgumentException("Strange " + target.getName() + " sub-type, " + subtype + ", can not find type parameters");
        }
        return decl;
    }

    static class FluentConverter
    extends StdConverter<Object, Iterable<?>> {
        static final FluentConverter instance = new FluentConverter();

        FluentConverter() {
        }

        @Override
        public Iterable<?> convert(Object value) {
            return (Iterable)value;
        }
    }
}

