/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.guava.deser.util.RangeHelper;
import org.apache.pinot.shaded.com.google.common.collect.BoundType;
import org.apache.pinot.shaded.com.google.common.collect.Range;

public class RangeSerializer
extends StdSerializer<Range<?>>
implements ContextualSerializer {
    protected final JavaType _rangeType;
    protected final JsonSerializer<Object> _endpointSerializer;
    protected final RangeHelper.RangeProperties _fieldNames;
    protected final JsonFormat.Shape _shape;

    public RangeSerializer(JavaType type) {
        this(type, null);
    }

    @Deprecated
    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer) {
        this(type, endpointSer, RangeHelper.standardNames());
    }

    @Deprecated
    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer, RangeHelper.RangeProperties fieldNames) {
        this(type, endpointSer, fieldNames, JsonFormat.Shape.ANY);
    }

    public RangeSerializer(JavaType type, JsonSerializer<?> endpointSer, RangeHelper.RangeProperties fieldNames, JsonFormat.Shape shape) {
        super(type);
        this._rangeType = type;
        this._endpointSerializer = endpointSer;
        this._fieldNames = fieldNames;
        this._shape = shape;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Range<?> value) {
        return value.isEmpty();
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(prov, property, this.handledType());
        JsonFormat.Shape shape = format.getShape();
        PropertyNamingStrategy propertyNamingStrategy = prov.getConfig().getPropertyNamingStrategy();
        RangeHelper.RangeProperties nameMapping = RangeHelper.getPropertyNames(prov.getConfig(), propertyNamingStrategy);
        JsonSerializer<Object> endpointSer = this._endpointSerializer;
        if (endpointSer == null) {
            JavaType endpointType = this._rangeType.containedTypeOrUnknown(0);
            if (endpointType != null && !endpointType.hasRawClass(Object.class)) {
                JsonSerializer<Object> ser = prov.findValueSerializer(endpointType, property);
                return new RangeSerializer(this._rangeType, ser, nameMapping, shape);
            }
        } else if (endpointSer instanceof ContextualSerializer) {
            endpointSer = ((ContextualSerializer)((Object)endpointSer)).createContextual(prov, property);
        }
        if (endpointSer != this._endpointSerializer || nameMapping != null) {
            return new RangeSerializer(this._rangeType, endpointSer, nameMapping, shape);
        }
        return this;
    }

    @Override
    public void serialize(Range<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._shape == JsonFormat.Shape.STRING) {
            gen.writeString(this.getStringFormat(value));
        } else {
            gen.writeStartObject(value);
            this._writeContents(value, gen, provider);
            gen.writeEndObject();
        }
    }

    @Override
    public void serializeWithType(Range<?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.assignCurrentValue(value);
        if (this._shape == JsonFormat.Shape.STRING) {
            String rangeString = this.getStringFormat(value);
            WritableTypeId typeId = typeSer.writeTypeSuffix(gen, typeSer.typeId(rangeString, JsonToken.VALUE_STRING));
            typeSer.writeTypeSuffix(gen, typeId);
        } else {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
            this._writeContents(value, gen, provider);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }
    }

    protected String getStringFormat(Range<?> range) {
        StringBuilder builder = new StringBuilder();
        if (range.hasLowerBound()) {
            builder.append(range.lowerBoundType() == BoundType.CLOSED ? (char)'[' : '(').append(range.lowerEndpoint());
        } else {
            builder.append("(-\u221e");
        }
        builder.append("..");
        if (range.hasUpperBound()) {
            builder.append(range.upperEndpoint()).append(range.upperBoundType() == BoundType.CLOSED ? (char)']' : ')');
        } else {
            builder.append("+\u221e)");
        }
        return builder.toString();
    }

    protected void _writeContents(Range<?> value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        String fieldName;
        if (value.hasLowerBound()) {
            fieldName = this._fieldNames.lowerEndpoint;
            if (this._endpointSerializer != null) {
                g2.writeFieldName(fieldName);
                this._endpointSerializer.serialize(value.lowerEndpoint(), g2, provider);
            } else {
                provider.defaultSerializeField(fieldName, value.lowerEndpoint(), g2);
            }
            g2.writeStringField(this._fieldNames.lowerBoundType, value.lowerBoundType().name());
        }
        if (value.hasUpperBound()) {
            fieldName = this._fieldNames.upperEndpoint;
            if (this._endpointSerializer != null) {
                g2.writeFieldName(fieldName);
                this._endpointSerializer.serialize(value.upperEndpoint(), g2, provider);
            } else {
                provider.defaultSerializeField(fieldName, value.upperEndpoint(), g2);
            }
            g2.writeStringField(this._fieldNames.upperBoundType, value.upperBoundType().name());
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonObjectFormatVisitor objectVisitor;
        if (visitor != null && (objectVisitor = visitor.expectObjectFormat(typeHint)) != null && this._endpointSerializer != null) {
            JavaType endpointType = this._rangeType.containedType(0);
            JavaType btType = visitor.getProvider().constructType((Type)((Object)BoundType.class));
            JsonSerializer<Object> btSer = visitor.getProvider().findValueSerializer(btType, null);
            objectVisitor.property(this._fieldNames.lowerEndpoint, this._endpointSerializer, endpointType);
            objectVisitor.property(this._fieldNames.lowerBoundType, btSer, btType);
            objectVisitor.property(this._fieldNames.upperEndpoint, this._endpointSerializer, endpointType);
            objectVisitor.property(this._fieldNames.upperBoundType, btSer, btType);
        }
    }
}

