/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClient;
import com.azure.core.http.netty.implementation.AzureNettyHttpClientContext;
import com.azure.core.http.netty.implementation.AzureSdkHandler;
import com.azure.core.http.netty.implementation.HttpProxyHandler;
import com.azure.core.http.netty.implementation.NettyUtility;
import com.azure.core.implementation.util.HttpUtils;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpResponseDecoderSpec;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.ProxyProvider;

public class NettyAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(NettyAsyncHttpClientBuilder.class);
    private final reactor.netty.http.client.HttpClient baseHttpClient;
    private ProxyOptions proxyOptions;
    private ConnectionProvider connectionProvider;
    private boolean enableWiretap;
    private int port = 80;
    private EventLoopGroup eventLoopGroup;
    private Configuration configuration;
    private boolean disableBufferCopy;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;

    public NettyAsyncHttpClientBuilder() {
        this.baseHttpClient = null;
    }

    public NettyAsyncHttpClientBuilder(reactor.netty.http.client.HttpClient nettyHttpClient) {
        this.baseHttpClient = Objects.requireNonNull(nettyHttpClient, "'nettyHttpClient' cannot be null.");
    }

    public HttpClient build() {
        AtomicReference proxyChallengeHolder;
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions buildProxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration(buildConfiguration, true) : this.proxyOptions;
        boolean useCustomProxyHandler = NettyAsyncHttpClientBuilder.shouldUseCustomProxyHandler(buildProxyOptions);
        AuthorizationChallengeHandler handler = useCustomProxyHandler ? new AuthorizationChallengeHandler(buildProxyOptions.getUsername(), buildProxyOptions.getPassword()) : null;
        AtomicReference atomicReference = proxyChallengeHolder = useCustomProxyHandler ? new AtomicReference() : null;
        reactor.netty.http.client.HttpClient nettyHttpClient = this.baseHttpClient != null ? this.baseHttpClient : (this.connectionProvider != null ? reactor.netty.http.client.HttpClient.create(this.connectionProvider) : reactor.netty.http.client.HttpClient.create());
        if (this.proxyOptions == null) {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.resolver(DefaultAddressResolverGroup.INSTANCE);
        }
        long writeTimeout = HttpUtils.getTimeout(this.writeTimeout, HttpUtils.getDefaultWriteTimeout()).toMillis();
        long responseTimeout = HttpUtils.getTimeout(this.responseTimeout, HttpUtils.getDefaultResponseTimeout()).toMillis();
        long readTimeout = HttpUtils.getTimeout(this.readTimeout, HttpUtils.getDefaultReadTimeout()).toMillis();
        HttpResponseDecoderSpec initialSpec = ((HttpClientConfig)nettyHttpClient.configuration()).decoder();
        LoggingHandler loggingHandler = ((HttpClientConfig)(nettyHttpClient = ((reactor.netty.http.client.HttpClient)nettyHttpClient.port(this.port).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)HttpUtils.getTimeout(this.connectTimeout, HttpUtils.getDefaultConnectTimeout()).toMillis())).httpResponseDecoder(httpResponseDecoderSpec -> {
            int maxHeaderSize = initialSpec.maxHeaderSize();
            if (maxHeaderSize == 8192) {
                maxHeaderSize = 262144;
            }
            return (HttpResponseDecoderSpec)((HttpResponseDecoderSpec)initialSpec.validateHeaders(false)).maxHeaderSize(maxHeaderSize);
        }).doOnRequest((request, connection) -> NettyAsyncHttpClientBuilder.addHandler(request, connection, writeTimeout, responseTimeout, readTimeout)).doAfterResponseSuccess((ignored, connection) -> NettyAsyncHttpClientBuilder.removeHandler(connection))).configuration()).loggingHandler();
        if (loggingHandler == null) {
            nettyHttpClient.wiretap(this.enableWiretap);
        }
        boolean addProxyHandler = false;
        if (this.eventLoopGroup != null) {
            nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.runOn(this.eventLoopGroup);
        }
        if (buildProxyOptions != null) {
            if (handler != null) {
                addProxyHandler = true;
                Pattern nonProxyHostsPattern = CoreUtils.isNullOrEmpty(buildProxyOptions.getNonProxyHosts()) ? null : Pattern.compile(buildProxyOptions.getNonProxyHosts(), 2);
                AddressResolverGroup<?> resolver = ((HttpClientConfig)(nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.doOnChannelInit((connectionObserver, channel, socketAddress) -> {
                    if (NettyAsyncHttpClientBuilder.shouldApplyProxy(socketAddress, nonProxyHostsPattern)) {
                        channel.pipeline().addFirst("reactor.left.proxyHandler", (ChannelHandler)new HttpProxyHandler(AddressUtils.replaceWithResolved(buildProxyOptions.getAddress()), handler, proxyChallengeHolder));
                    }
                })).configuration()).resolver();
                if (resolver == null) {
                    nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.resolver(NoopAddressResolverGroup.INSTANCE);
                }
            } else {
                nettyHttpClient = (reactor.netty.http.client.HttpClient)nettyHttpClient.proxy((? super ProxyProvider.TypeSpec proxy) -> proxy.type(NettyAsyncHttpClientBuilder.toReactorNettyProxyType(buildProxyOptions.getType())).address(buildProxyOptions.getAddress()).username(buildProxyOptions.getUsername()).password(ignored -> buildProxyOptions.getPassword()).nonProxyHosts(buildProxyOptions.getNonProxyHosts()));
            }
        }
        return new NettyAsyncHttpClient(nettyHttpClient, this.disableBufferCopy, addProxyHandler);
    }

    public NettyAsyncHttpClientBuilder connectionProvider(ConnectionProvider connectionProvider) {
        if (connectionProvider != null) {
            LOGGER.verbose("Setting ConnectionProvider for the Reactor Netty HttpClient. Please be aware of the differences in runtime behavior when creating a default Reactor Netty HttpClient vs an HttpClientwith a specified ConnectionProvider. For more details see https://aka.ms/azsdk/java/docs/configure-httpclient.");
        }
        this.connectionProvider = connectionProvider;
        return this;
    }

    NettyAsyncHttpClientBuilder connectionProviderInternal(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public NettyAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder wiretap(boolean enableWiretap) {
        this.enableWiretap = enableWiretap;
        return this;
    }

    public NettyAsyncHttpClientBuilder port(int port) {
        this.port = port;
        return this;
    }

    @Deprecated
    public NettyAsyncHttpClientBuilder nioEventLoopGroup(NioEventLoopGroup nioEventLoopGroup) {
        this.eventLoopGroup = nioEventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public NettyAsyncHttpClientBuilder disableBufferCopy(boolean disableBufferCopy) {
        this.disableBufferCopy = disableBufferCopy;
        return this;
    }

    public NettyAsyncHttpClientBuilder connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public NettyAsyncHttpClientBuilder readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private static boolean shouldUseCustomProxyHandler(ProxyOptions options) {
        return options != null && options.getUsername() != null && options.getType() == ProxyOptions.Type.HTTP;
    }

    private static ProxyProvider.Proxy toReactorNettyProxyType(ProxyOptions.Type azureProxyType) {
        switch (azureProxyType) {
            case HTTP: {
                return ProxyProvider.Proxy.HTTP;
            }
            case SOCKS4: {
                return ProxyProvider.Proxy.SOCKS4;
            }
            case SOCKS5: {
                return ProxyProvider.Proxy.SOCKS5;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unknown 'ProxyOptions.Type' enum value"));
    }

    private static boolean shouldApplyProxy(SocketAddress socketAddress, Pattern nonProxyHostsPattern) {
        if (nonProxyHostsPattern == null) {
            return true;
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            return true;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        return !nonProxyHostsPattern.matcher(inetSocketAddress.getHostString()).matches();
    }

    private static void addHandler(HttpClientRequest request, Connection connection, long writeTimeout, long responseTimeout, long readTimeout) {
        AzureNettyHttpClientContext attr = request.currentContextView().getOrDefault("azure-sdk-pipeline-data", null);
        connection.addHandlerLast("azureSdkHandler", new AzureSdkHandler(attr, writeTimeout, responseTimeout, readTimeout));
    }

    private static void removeHandler(Connection connection) {
        connection.removeHandler("azureSdkHandler");
    }

    static {
        NettyUtility.validateNettyVersions();
    }
}

