/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.implementation.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;

final class AdditionalPropertiesDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 700052863615540646L;
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesDeserializer(Class<?> vc, JsonDeserializer<?> defaultDeserializer, ObjectMapper mapper) {
        super(vc);
        this.defaultDeserializer = defaultDeserializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                for (Class<?> c : TypeUtil.getAllClasses(beanDesc.getBeanClass())) {
                    Field[] fields;
                    for (Field field : fields = c.getDeclaredFields()) {
                        JsonProperty property;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (property = field.getAnnotation(JsonProperty.class)) == null || !property.value().isEmpty()) continue;
                        return new AdditionalPropertiesDeserializer(beanDesc.getBeanClass(), deserializer, mapper);
                    }
                }
                return deserializer;
            }
        });
        return module;
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectNode root = (ObjectNode)this.mapper.readTree(jp);
        ObjectNode copy = root.deepCopy();
        Class<?> tClass = this.defaultDeserializer.handledType();
        boolean isJsonFlatten = tClass.getAnnotation(JsonFlatten.class) != null;
        for (Class<?> c : TypeUtil.getAllClasses(tClass)) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                String key;
                if (field.isSynthetic()) continue;
                JsonProperty property = field.getAnnotation(JsonProperty.class);
                String string = key = isJsonFlatten ? AdditionalPropertiesDeserializer.jsonFlattenSplit(property.value()) : property.value();
                if (key.isEmpty() || !copy.has(key)) continue;
                copy.remove(key);
            }
        }
        root.set("additionalProperties", copy);
        JsonParser parser = new JsonFactory().createParser(root.toString());
        parser.nextToken();
        return this.defaultDeserializer.deserialize(parser, ctxt);
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)((Object)this.defaultDeserializer)).resolve(ctxt);
    }

    private static String jsonFlattenSplit(String str) {
        int indexOfSplit = AdditionalPropertiesDeserializer.indexOfSplit(str);
        return indexOfSplit == -1 ? str : str.substring(0, indexOfSplit);
    }

    private static int indexOfSplit(String str) {
        int index = 0;
        while ((index = str.indexOf(46, index)) != -1) {
            if (index - 2 < 0) {
                return index;
            }
            if (str.charAt(index - 1) == '\\' && str.charAt(index - 2) == '\\') continue;
            return index;
        }
        return -1;
    }
}

