/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.filesystem;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class AzurePinotFSUtil {
    private static final String DIRECTORY_DELIMITER = File.separator;

    private AzurePinotFSUtil() {
    }

    public static String convertUriToAzureStylePath(URI uri) {
        String path = URLDecoder.decode(uri.getRawPath(), StandardCharsets.UTF_8);
        if (path.startsWith(DIRECTORY_DELIMITER)) {
            path = path.substring(1);
        }
        if (path.endsWith(DIRECTORY_DELIMITER)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String convertAzureStylePathToUriStylePath(String path) {
        if (!((String)path).startsWith(DIRECTORY_DELIMITER)) {
            path = DIRECTORY_DELIMITER + (String)path;
        }
        if (((String)path).endsWith(DIRECTORY_DELIMITER)) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }
}

