/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.lib.partition.KeyFieldHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyFieldBasedPartitioner<K2, V2>
extends Partitioner<K2, V2>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(KeyFieldBasedPartitioner.class.getName());
    public static String PARTITIONER_OPTIONS = "mapreduce.partition.keypartitioner.options";
    private int numOfPartitionFields;
    private KeyFieldHelper keyFieldHelper = new KeyFieldHelper();
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.keyFieldHelper = new KeyFieldHelper();
        String keyFieldSeparator = conf.get("mapreduce.map.output.key.field.separator", "\t");
        this.keyFieldHelper.setKeyFieldSeparator(keyFieldSeparator);
        if (conf.get("num.key.fields.for.partition") != null) {
            LOG.warn("Using deprecated num.key.fields.for.partition. Use mapreduce.partition.keypartitioner.options instead");
            this.numOfPartitionFields = conf.getInt("num.key.fields.for.partition", 0);
            this.keyFieldHelper.setKeyFieldSpec(1, this.numOfPartitionFields);
        } else {
            String option = conf.get(PARTITIONER_OPTIONS);
            this.keyFieldHelper.parseOption(option);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public int getPartition(K2 key, V2 value, int numReduceTasks) {
        List<KeyFieldHelper.KeyDescription> allKeySpecs = this.keyFieldHelper.keySpecs();
        if (allKeySpecs.size() == 0) {
            return this.getPartition(key.toString().hashCode(), numReduceTasks);
        }
        byte[] keyBytes = key.toString().getBytes(StandardCharsets.UTF_8);
        if (keyBytes.length == 0) {
            return 0;
        }
        int[] lengthIndicesFirst = this.keyFieldHelper.getWordLengths(keyBytes, 0, keyBytes.length);
        int currentHash = 0;
        for (KeyFieldHelper.KeyDescription keySpec : allKeySpecs) {
            int startChar = this.keyFieldHelper.getStartOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            if (startChar < 0) continue;
            int endChar = this.keyFieldHelper.getEndOffset(keyBytes, 0, keyBytes.length, lengthIndicesFirst, keySpec);
            currentHash = this.hashCode(keyBytes, startChar, endChar, currentHash);
        }
        return this.getPartition(currentHash, numReduceTasks);
    }

    protected int hashCode(byte[] b, int start, int end, int currentHash) {
        for (int i = start; i <= end; ++i) {
            currentHash = 31 * currentHash + b[i];
        }
        return currentHash;
    }

    protected int getPartition(int hash, int numReduceTasks) {
        return (hash & Integer.MAX_VALUE) % numReduceTasks;
    }

    public void setKeyFieldPartitionerOptions(Job job, String keySpec) {
        job.getConfiguration().set(PARTITIONER_OPTIONS, keySpec);
    }

    public String getKeyFieldPartitionerOption(JobContext job) {
        return job.getConfiguration().get(PARTITIONER_OPTIONS);
    }
}

