/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SpillRecord;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.security.IntermediateEncryptedStream;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.Fetcher;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleSchedulerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalFetcher<K, V>
extends Fetcher<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFetcher.class);
    private static final MapHost LOCALHOST = new MapHost("local", "local");
    private JobConf job;
    private Map<TaskAttemptID, MapOutputFile> localMapFiles;

    public LocalFetcher(JobConf job, TaskAttemptID reduceId, ShuffleSchedulerImpl<K, V> scheduler, MergeManager<K, V> merger, Reporter reporter, ShuffleClientMetrics metrics, ExceptionReporter exceptionReporter, SecretKey shuffleKey, Map<TaskAttemptID, MapOutputFile> localMapFiles) {
        super(job, reduceId, scheduler, merger, reporter, metrics, exceptionReporter, shuffleKey);
        this.job = job;
        this.localMapFiles = localMapFiles;
        this.setName("localfetcher#" + this.id);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        HashSet<TaskAttemptID> maps = new HashSet<TaskAttemptID>();
        for (TaskAttemptID map : this.localMapFiles.keySet()) {
            maps.add(map);
        }
        while (maps.size() > 0) {
            try {
                this.merger.waitForResource();
                this.metrics.threadBusy();
                this.doCopy(maps);
                this.metrics.threadFree();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t2) {
                this.exceptionReporter.reportException(t2);
            }
        }
    }

    private void doCopy(Set<TaskAttemptID> maps) throws IOException {
        Iterator<TaskAttemptID> iter = maps.iterator();
        while (iter.hasNext()) {
            TaskAttemptID map = iter.next();
            LOG.debug("LocalFetcher " + this.id + " going to fetch: " + map);
            if (!this.copyMapOutput(map)) break;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyMapOutput(TaskAttemptID mapTaskId) throws IOException {
        Path mapOutputFileName = this.localMapFiles.get(mapTaskId).getOutputFile();
        Path indexFileName = mapOutputFileName.suffix(".index");
        SpillRecord sr = new SpillRecord(indexFileName, this.job);
        IndexRecord ir = sr.getIndex(this.reduce);
        long compressedLength = ir.partLength;
        long decompressedLength = ir.rawLength;
        compressedLength -= (long)CryptoUtils.cryptoPadding(this.job);
        MapOutput mapOutput = this.merger.reserve(mapTaskId, decompressedLength -= (long)CryptoUtils.cryptoPadding(this.job), this.id);
        if (mapOutput == null) {
            LOG.info("fetcher#" + this.id + " - MergeManager returned Status.WAIT ...");
            return false;
        }
        LOG.info("localfetcher#" + this.id + " about to shuffle output of map " + mapOutput.getMapId() + " decomp: " + decompressedLength + " len: " + compressedLength + " to " + mapOutput.getDescription());
        FileSystem localFs = FileSystem.getLocal((Configuration)this.job).getRaw();
        FSDataInputStream inStream = localFs.open(mapOutputFileName);
        try {
            inStream.seek(ir.startOffset);
            inStream = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.job, inStream, mapOutputFileName);
            mapOutput.shuffle(LOCALHOST, (InputStream)inStream, compressedLength, decompressedLength, this.metrics, this.reporter);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{inStream});
        this.scheduler.copySucceeded(mapTaskId, LOCALHOST, compressedLength, 0L, 0L, mapOutput);
        return true;
    }
}

