/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher;
import kafka.tools.TopicPartitionReplica;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

public final class ReplicaVerificationTool$
implements Logging {
    public static ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(Time.SYSTEM.milliseconds()));
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void addShutdownHook_shutdownHook;
        void addShutdownHook_name;
        void var24_24;
        void var23_23;
        Seq<TopicDescription> seq;
        scala.collection.immutable.Map<Object, Node> map;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x100000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo(".*", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(30000L), (Long[])((Object[])new Long[0]));
        AbstractOptionSpec helpOpt = parser.accepts("help", "Print usage information.").forHelp();
        AbstractOptionSpec versionOpt = parser.accepts("version", "Print version information and exit.").forHelp();
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has(helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        if (options.has(versionOpt)) {
            throw CommandLineUtils$.MODULE$.printVersionAndDie();
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = options.valueOf(topicWhiteListOpt);
        IncludeList topicWhiteListFiler = new IncludeList(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException(new StringBuilder(21).append(regex).append(" is an invalid regex.").toString());
        }
        int fetchSize = options.valueOf(fetchSizeOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        long initialOffsetTime = options.valueOf(initialOffsetTimeOpt);
        long reportInterval = options.valueOf(reportIntervalOpt);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$1()));
        }
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Admin adminClient = this.createAdminClient(brokerList);
        try {
            map = this.brokerDetails(adminClient);
            seq = this.listTopicsMetadata(adminClient);
        }
        finally {
            CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> adminClient.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Seq<TopicDescription> topicsMetadata = seq;
        scala.collection.immutable.Map<Object, Node> brokerInfo = map;
        void topicsMetadata2 = var23_23;
        void brokerInfo2 = var24_24;
        Seq filteredTopicMetadata = (Seq)topicsMetadata2.filter((Function1<TopicDescription, Object> & Serializable & scala.Serializable)topicMetaData -> BoxesRunTime.boxToBoolean(topicWhiteListFiler.isTopicAllowed(topicMetaData.name(), false)));
        if (filteredTopicMetadata.isEmpty()) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$4(topicWhiteListOpt)));
            }
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        Seq topicPartitionReplicas = filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable & scala.Serializable)topicMetadata -> ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).flatMap((Function1<TopicPartitionInfo, Buffer> & Serializable & scala.Serializable)partitionMetadata -> ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1<Node, TopicPartitionReplica> & Serializable & scala.Serializable)node -> new TopicPartitionReplica(topicMetadata.name(), partitionMetadata.partition(), node.id()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$8(topicPartitionReplicas)));
        }
        scala.collection.immutable.Map brokerToTopicPartitions = topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.replicaId())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            int brokerId = x0$1._1$mcI$sp();
            Seq partitions = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(brokerId)), partitions.map((Function1<TopicPartitionReplica, TopicPartition> & Serializable & scala.Serializable)partition -> new TopicPartition(partition.topic(), partition.partitionId()), Seq$.MODULE$.canBuildFrom()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$12(brokerToTopicPartitions)));
        }
        scala.collection.immutable.Map<TopicPartition, Object> expectedReplicasPerTopicPartition = topicPartitionReplicas.groupBy((Function1<TopicPartitionReplica, TopicPartition> & Serializable & scala.Serializable)replica -> new TopicPartition(replica.topic(), replica.partitionId())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError((Object)null);
            }
            TopicPartition topicAndPartition = (TopicPartition)x0$2._1();
            Seq replicaSet = (Seq)x0$2._2();
            Tuple2<TopicPartition, Integer> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), BoxesRunTime.boxToInteger(replicaSet.size()));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$15(expectedReplicasPerTopicPartition)));
        }
        Seq<TopicPartition> topicPartitions = filteredTopicMetadata.flatMap((Function1<TopicDescription, Buffer> & Serializable & scala.Serializable)topicMetaData -> ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetaData.partitions()).asScala()).map((Function1<TopicPartitionInfo, TopicPartition> & Serializable & scala.Serializable)partitionMetadata -> new TopicPartition(topicMetaData.name(), partitionMetadata.partition()), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Properties consumerProps = this.consumerConfig(brokerList);
        ReplicaBuffer replicaBuffer = new ReplicaBuffer(expectedReplicasPerTopicPartition, this.initialOffsets(topicPartitions, consumerProps, initialOffsetTime), brokerToTopicPartitions.size(), reportInterval);
        int verificationBrokerId = ((Tuple2)brokerToTopicPartitions.head())._1$mcI$sp();
        AtomicInteger counter2 = new AtomicInteger(0);
        Iterable fetcherThreads = brokerToTopicPartitions.map(arg_0 -> ReplicaVerificationTool$.$anonfun$main$18((scala.collection.immutable.Map)brokerInfo2, replicaBuffer, fetchSize, maxWaitMs, verificationBrokerId, consumerProps, counter2, arg_0), Iterable$.MODULE$.canBuildFrom());
        JFunction0$mcV$sp & scala.Serializable intersect = (JFunction0$mcV$sp & scala.Serializable)() -> {
            ReplicaVerificationTool$ replicaVerificationTool$ = MODULE$;
            if (replicaVerificationTool$ == null) {
                throw null;
            }
            ReplicaVerificationTool$ info_this = replicaVerificationTool$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(ReplicaVerificationTool$.$anonfun$main$20()));
            }
            fetcherThreads.foreach((Function1<ReplicaFetcher, Object> & Serializable & scala.Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
        };
        String string = "ReplicaVerificationToolShutdownHook";
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.addShutdownHook((String)addShutdownHook_name, () -> Exit$.$anonfun$addShutdownHook$1((Function0)addShutdownHook_shutdownHook));
        fetcherThreads.foreach((Function1<ReplicaFetcher, Object> & Serializable & scala.Serializable)x$4 -> {
            x$4.start();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println(new StringBuilder(34).append(this.getCurrentTimeString()).append(": verification process is started.").toString());
    }

    private Seq<TopicDescription> listTopicsMetadata(Admin adminClient) {
        Set<String> topics = adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get();
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeTopics(topics).all().get().values()).asScala()).toBuffer();
    }

    private scala.collection.immutable.Map<Object, Node> brokerDetails(Admin adminClient) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(adminClient.describeCluster().nodes().get()).asScala()).map((Function1<Node, Tuple2> & Serializable & scala.Serializable)n -> new Tuple2<Integer, Node>(BoxesRunTime.boxToInteger(n.id()), (Node)n), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Admin createAdminClient(String brokerUrl) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokerUrl);
        return Admin.create(props);
    }

    private Map<TopicPartition, Object> initialOffsets(Seq<TopicPartition> topicPartitions, Properties consumerConfig, long initialOffsetTime) {
        Map map;
        try (KafkaConsumer<String, String> consumer = this.createConsumer(consumerConfig);){
            if (-1L == initialOffsetTime) {
                map = ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection<TopicPartition>)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError((Object)null);
                    }
                    TopicPartition k = (TopicPartition)x0$1._1();
                    Long v = (Long)x0$1._2();
                    Tuple2<TopicPartition, Long> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), BoxesRunTime.boxToLong(v));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            } else if (-2L == initialOffsetTime) {
                map = ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection<TopicPartition>)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError((Object)null);
                    }
                    TopicPartition k = (TopicPartition)x0$2._1();
                    Long v = (Long)x0$2._2();
                    Tuple2<TopicPartition, Long> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), BoxesRunTime.boxToLong(v));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            } else {
                scala.collection.immutable.Map timestampsToSearch = ((TraversableOnce)topicPartitions.map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)tp -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Predef$.MODULE$.long2Long(initialOffsetTime)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                map = ((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(CollectionConverters$.MODULE$.mapAsJavaMapConverter(timestampsToSearch).asJava())).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 == null) {
                        throw new MatchError((Object)null);
                    }
                    TopicPartition k = (TopicPartition)x0$3._1();
                    OffsetAndTimestamp v = (OffsetAndTimestamp)x0$3._2();
                    Tuple2<TopicPartition, Long> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), BoxesRunTime.boxToLong(v.offset()));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfig(String brokerUrl) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", brokerUrl);
        properties.put("group.id", "ReplicaVerification");
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        return var2_2;
    }

    private KafkaConsumer<String, String> createConsumer(Properties consumerConfig) {
        return new KafkaConsumer<String, String>(consumerConfig);
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Getting topic metadata...";
    }

    public static final /* synthetic */ String $anonfun$main$4(ArgumentAcceptingOptionSpec topicWhiteListOpt$1) {
        return new StringBuilder(88).append("No topics found. ").append(topicWhiteListOpt$1).append(" if specified, is either filtering out all topics or there is no topic.").toString();
    }

    public static final /* synthetic */ String $anonfun$main$8(Seq topicPartitionReplicas$1) {
        return new StringBuilder(27).append("Selected topic partitions: ").append(topicPartitionReplicas$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$12(scala.collection.immutable.Map brokerToTopicPartitions$1) {
        return new StringBuilder(29).append("Topic partitions per broker: ").append(brokerToTopicPartitions$1).toString();
    }

    public static final /* synthetic */ String $anonfun$main$15(scala.collection.immutable.Map expectedReplicasPerTopicPartition$1) {
        return new StringBuilder(39).append("Expected replicas per topic partition: ").append(expectedReplicasPerTopicPartition$1).toString();
    }

    public static final /* synthetic */ ReplicaFetcher $anonfun$main$18(scala.collection.immutable.Map brokerInfo$1, ReplicaBuffer replicaBuffer$1, int fetchSize$1, int maxWaitMs$1, int verificationBrokerId$1, Properties consumerProps$1, AtomicInteger counter$1, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError((Object)null);
        }
        int brokerId = x0$3._1$mcI$sp();
        Seq topicPartitions = (Seq)x0$3._2();
        ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringBuilder(15).append("ReplicaFetcher-").append(brokerId).toString(), (Node)brokerInfo$1.apply(BoxesRunTime.boxToInteger(brokerId)), topicPartitions, replicaBuffer$1, 30000, 256000, fetchSize$1, maxWaitMs$1, 1, brokerId == verificationBrokerId$1, consumerProps$1, counter$1.incrementAndGet());
        return replicaFetcher;
    }

    public static final /* synthetic */ String $anonfun$main$20() {
        return "Stopping all fetchers";
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

