/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20.server;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamDataProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDataProducer
implements StreamDataProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaDataProducer.class);
    private Producer<byte[], byte[]> _producer;

    public void init(Properties props) {
        if (!props.containsKey("bootstrap.servers")) {
            props.put("bootstrap.servers", props.get("metadata.broker.list"));
        }
        if (!props.containsKey("key.serializer")) {
            props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (!props.containsKey("value.serializer")) {
            props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        }
        if (props.containsKey("partitioner.class")) {
            props.remove("partitioner.class");
        }
        props.remove("metadata.broker.list");
        props.remove("request.required.acks");
        props.remove("serializer.class");
        try {
            this._producer = new KafkaProducer<byte[], byte[]>(props);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create a Kafka 2 Producer.", e);
        }
    }

    public void produce(String topic, byte[] payload) {
        this._producer.send(new ProducerRecord(topic, payload));
        this._producer.flush();
    }

    public void produce(String topic, byte[] key, byte[] payload) {
        this._producer.send(new ProducerRecord<byte[], byte[]>(topic, key, payload));
        this._producer.flush();
    }

    public void produce(String topic, byte[] key, byte[] payload, GenericRow headers) {
        ArrayList<Header> headerList = new ArrayList<Header>();
        long nowMs = System.currentTimeMillis();
        headerList.add(new RecordHeader("producerTimestamp", String.valueOf(nowMs).getBytes(StandardCharsets.UTF_8)));
        if (headers != null) {
            headers.getFieldToValueMap().forEach((k, v) -> {
                Header header = this.convertToKafkaHeader((String)k, v);
                if (header != null) {
                    headerList.add(header);
                }
            });
        }
        this._producer.send(new ProducerRecord<byte[], byte[]>(topic, null, nowMs, key, payload, headerList));
        this._producer.flush();
    }

    public Header convertToKafkaHeader(String key, Object value) {
        if (value != null) {
            if (value instanceof String) {
                return new RecordHeader(key, ((String)value).getBytes(StandardCharsets.UTF_8));
            }
            if (value instanceof Long) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.putLong((Long)value);
                return new RecordHeader(key, buffer.array());
            }
        }
        return null;
    }

    public void close() {
        this._producer.close();
    }
}

