/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.FlattenedByteArray;
import com.yscope.clp.compressorfrontend.FlattenedByteArrayFactory;
import com.yscope.clp.compressorfrontend.NativeLibraryLoader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MessageDecoder {
    public MessageDecoder(@NotNull String variablesSchemaVersion, @NotNull String variableEncodingMethodsVersion) throws UnsupportedOperationException {
        Objects.requireNonNull(variablesSchemaVersion);
        Objects.requireNonNull(variableEncodingMethodsVersion);
        byte[] schemaVersionBytes = variablesSchemaVersion.getBytes(StandardCharsets.ISO_8859_1);
        byte[] encodingMethodsVersionBytes = variableEncodingMethodsVersion.getBytes(StandardCharsets.ISO_8859_1);
        this.setVariableHandlingRuleVersions(schemaVersionBytes, schemaVersionBytes.length, encodingMethodsVersionBytes, encodingMethodsVersionBytes.length);
    }

    private native void setVariableHandlingRuleVersions(byte[] var1, int var2, byte[] var3, int var4) throws UnsupportedOperationException;

    public String decodeMessage(@NotNull String logtype, String[] dictionaryVars, long[] encodedVars) throws IOException {
        byte[] message = this.decodeMessageAsBytes(logtype, dictionaryVars, encodedVars);
        return new String(message, StandardCharsets.UTF_8);
    }

    public String decodeMessage(byte @NotNull [] logtype, FlattenedByteArray dictionaryVars, long[] encodedVars) throws IOException {
        return new String(this.decodeMessageAsBytes(logtype, dictionaryVars, encodedVars), StandardCharsets.UTF_8);
    }

    public byte[] decodeMessageAsBytes(byte @NotNull [] logtype, FlattenedByteArray dictionaryVars, long[] encodedVars) throws IOException {
        Objects.requireNonNull(logtype);
        if (null == dictionaryVars) {
            return this.decodeMessageNative(logtype, logtype.length, null, 0, null, 0, encodedVars, null == encodedVars ? 0 : encodedVars.length);
        }
        return this.decodeMessageNative(logtype, logtype.length, dictionaryVars.getFlattenedElems(), dictionaryVars.getFlattenedElems().length, dictionaryVars.getElemEndOffsets(), dictionaryVars.getElemEndOffsets().length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
    }

    private byte[] decodeMessageAsBytes(@NotNull String logtype, String[] dictionaryVars, long[] encodedVars) throws IOException {
        Objects.requireNonNull(logtype);
        return this.decodeMessageAsBytes(logtype.getBytes(StandardCharsets.ISO_8859_1), null == dictionaryVars ? null : FlattenedByteArrayFactory.fromStrings(dictionaryVars), encodedVars);
    }

    private native byte[] decodeMessageNative(byte[] var1, int var2, byte[] var3, int var4, int[] var5, int var6, long[] var7, int var8) throws IOException;

    public boolean wildcardQueryMatchesAnyIntVar(@NotNull String wildcardQuery, @NotNull String logtype, long[] encodedVars) throws IOException {
        Objects.requireNonNull(wildcardQuery);
        Objects.requireNonNull(logtype);
        byte[] wildcardQueryBytes = wildcardQuery.getBytes(StandardCharsets.ISO_8859_1);
        byte[] logtypeBytes = logtype.getBytes(StandardCharsets.ISO_8859_1);
        return this.wildcardQueryMatchesAnyIntVarNative(wildcardQueryBytes, wildcardQueryBytes.length, logtypeBytes, logtypeBytes.length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
    }

    private native boolean wildcardQueryMatchesAnyIntVarNative(byte[] var1, int var2, byte[] var3, int var4, long[] var5, int var6) throws IOException;

    public boolean wildcardQueryMatchesAnyFloatVar(@NotNull String wildcardQuery, @NotNull String logtype, long[] encodedVars) throws IOException {
        Objects.requireNonNull(wildcardQuery);
        Objects.requireNonNull(logtype);
        byte[] wildcardQueryBytes = wildcardQuery.getBytes(StandardCharsets.ISO_8859_1);
        byte[] logtypeBytes = logtype.getBytes(StandardCharsets.ISO_8859_1);
        return this.wildcardQueryMatchesAnyFloatVarNative(wildcardQueryBytes, wildcardQueryBytes.length, logtypeBytes, logtypeBytes.length, encodedVars, null == encodedVars ? 0 : encodedVars.length);
    }

    private native boolean wildcardQueryMatchesAnyFloatVarNative(byte[] var1, int var2, byte[] var3, int var4, long[] var5, int var6) throws IOException;

    public void batchEncodedVarsWildcardMatch(@NotNull byte[][] logtypes, @NotNull long[][] encodedVarArrays, @NotNull byte[] wildcardVarPlaceholders, @NotNull byte[] serializedVarWildcardQueries, @NotNull int[] varWildcardQueryEndIndexes, @NotNull int[] matchResults) throws IOException {
        Objects.requireNonNull(logtypes);
        Objects.requireNonNull(encodedVarArrays);
        Objects.requireNonNull(wildcardVarPlaceholders);
        Objects.requireNonNull(serializedVarWildcardQueries);
        Objects.requireNonNull(varWildcardQueryEndIndexes);
        Objects.requireNonNull(matchResults);
        if (logtypes.length != matchResults.length) {
            throw new IllegalArgumentException("Number of logtypes given doesn't match size of output array.");
        }
        if (encodedVarArrays.length != matchResults.length) {
            throw new IllegalArgumentException("Number of encoded variable arrays given doesn't match size of output array.");
        }
        int lastIdx = 0;
        for (int i : varWildcardQueryEndIndexes) {
            if (i < lastIdx) {
                throw new IllegalArgumentException("Invalid wildcard variable query end index: i (" + i + ") < lastIdx (" + lastIdx + ")");
            }
            if (i > serializedVarWildcardQueries.length) {
                throw new IllegalArgumentException("Invalid wildcard variable query end index: i (" + i + ") > serializedVarWildcardQueries.length (" + lastIdx + ")");
            }
            lastIdx = i;
        }
        this.batchEncodedVarsWildcardMatchNative(logtypes.length, logtypes, encodedVarArrays, wildcardVarPlaceholders, wildcardVarPlaceholders.length, serializedVarWildcardQueries, serializedVarWildcardQueries.length, varWildcardQueryEndIndexes, varWildcardQueryEndIndexes.length, matchResults);
    }

    private native void batchEncodedVarsWildcardMatchNative(int var1, byte[][] var2, long[][] var3, byte[] var4, int var5, byte[] var6, int var7, int[] var8, int var9, int[] var10) throws IOException;

    static {
        NativeLibraryLoader.load();
    }
}

