/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.BinaryNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class JoinGroupRequestDataJsonConverter {
    public static JoinGroupRequestData read(JsonNode _node, short _version) {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection _collection;
        JoinGroupRequestData _object = new JoinGroupRequestData();
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("JoinGroupRequestData: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (!_groupIdNode.isTextual()) {
            throw new RuntimeException("JoinGroupRequestData expected a string type, but got " + _node.getNodeType());
        }
        _object.groupId = _groupIdNode.asText();
        JsonNode _sessionTimeoutMsNode = _node.get("sessionTimeoutMs");
        if (_sessionTimeoutMsNode == null) {
            throw new RuntimeException("JoinGroupRequestData: unable to locate field 'sessionTimeoutMs', which is mandatory in version " + _version);
        }
        _object.sessionTimeoutMs = MessageUtil.jsonNodeToInt(_sessionTimeoutMsNode, "JoinGroupRequestData");
        JsonNode _rebalanceTimeoutMsNode = _node.get("rebalanceTimeoutMs");
        if (_rebalanceTimeoutMsNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("JoinGroupRequestData: unable to locate field 'rebalanceTimeoutMs', which is mandatory in version " + _version);
            }
            _object.rebalanceTimeoutMs = -1;
        } else {
            _object.rebalanceTimeoutMs = MessageUtil.jsonNodeToInt(_rebalanceTimeoutMsNode, "JoinGroupRequestData");
        }
        JsonNode _memberIdNode = _node.get("memberId");
        if (_memberIdNode == null) {
            throw new RuntimeException("JoinGroupRequestData: unable to locate field 'memberId', which is mandatory in version " + _version);
        }
        if (!_memberIdNode.isTextual()) {
            throw new RuntimeException("JoinGroupRequestData expected a string type, but got " + _node.getNodeType());
        }
        _object.memberId = _memberIdNode.asText();
        JsonNode _groupInstanceIdNode = _node.get("groupInstanceId");
        if (_groupInstanceIdNode == null) {
            if (_version >= 5) {
                throw new RuntimeException("JoinGroupRequestData: unable to locate field 'groupInstanceId', which is mandatory in version " + _version);
            }
            _object.groupInstanceId = null;
        } else if (_groupInstanceIdNode.isNull()) {
            _object.groupInstanceId = null;
        } else {
            if (!_groupInstanceIdNode.isTextual()) {
                throw new RuntimeException("JoinGroupRequestData expected a string type, but got " + _node.getNodeType());
            }
            _object.groupInstanceId = _groupInstanceIdNode.asText();
        }
        JsonNode _protocolTypeNode = _node.get("protocolType");
        if (_protocolTypeNode == null) {
            throw new RuntimeException("JoinGroupRequestData: unable to locate field 'protocolType', which is mandatory in version " + _version);
        }
        if (!_protocolTypeNode.isTextual()) {
            throw new RuntimeException("JoinGroupRequestData expected a string type, but got " + _node.getNodeType());
        }
        _object.protocolType = _protocolTypeNode.asText();
        JsonNode _protocolsNode = _node.get("protocols");
        if (_protocolsNode == null) {
            throw new RuntimeException("JoinGroupRequestData: unable to locate field 'protocols', which is mandatory in version " + _version);
        }
        if (!_protocolsNode.isArray()) {
            throw new RuntimeException("JoinGroupRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        _object.protocols = _collection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(_protocolsNode.size());
        for (JsonNode _element : _protocolsNode) {
            _collection.add(JoinGroupRequestProtocolJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(JoinGroupRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("groupId", (JsonNode)new TextNode(_object.groupId));
        _node.set("sessionTimeoutMs", (JsonNode)new IntNode(_object.sessionTimeoutMs));
        if (_version >= 1) {
            _node.set("rebalanceTimeoutMs", (JsonNode)new IntNode(_object.rebalanceTimeoutMs));
        }
        _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
        if (_version >= 5) {
            if (_object.groupInstanceId == null) {
                _node.set("groupInstanceId", (JsonNode)NullNode.instance);
            } else {
                _node.set("groupInstanceId", (JsonNode)new TextNode(_object.groupInstanceId));
            }
        } else if (_object.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        _node.set("protocolType", (JsonNode)new TextNode(_object.protocolType));
        ArrayNode _protocolsArray = new ArrayNode(JsonNodeFactory.instance);
        for (JoinGroupRequestData.JoinGroupRequestProtocol _element : _object.protocols) {
            _protocolsArray.add(JoinGroupRequestProtocolJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("protocols", (JsonNode)_protocolsArray);
        return _node;
    }

    public static JsonNode write(JoinGroupRequestData _object, short _version) {
        return JoinGroupRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class JoinGroupRequestProtocolJsonConverter {
        public static JoinGroupRequestData.JoinGroupRequestProtocol read(JsonNode _node, short _version) {
            JoinGroupRequestData.JoinGroupRequestProtocol _object = new JoinGroupRequestData.JoinGroupRequestProtocol();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("JoinGroupRequestProtocol: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("JoinGroupRequestProtocol expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _metadataNode = _node.get("metadata");
            if (_metadataNode == null) {
                throw new RuntimeException("JoinGroupRequestProtocol: unable to locate field 'metadata', which is mandatory in version " + _version);
            }
            _object.metadata = MessageUtil.jsonNodeToBinary(_metadataNode, "JoinGroupRequestProtocol");
            return _object;
        }

        public static JsonNode write(JoinGroupRequestData.JoinGroupRequestProtocol _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("metadata", (JsonNode)new BinaryNode(Arrays.copyOf(_object.metadata, _object.metadata.length)));
            return _node;
        }

        public static JsonNode write(JoinGroupRequestData.JoinGroupRequestProtocol _object, short _version) {
            return JoinGroupRequestProtocolJsonConverter.write(_object, _version, true);
        }
    }
}

