/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf.codegen;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtobufInternalUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCodeGen {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageCodeGen.class);
    public static final String EXTRACTOR_PACKAGE_NAME = "org.apache.pinot.plugin.inputformat.protobuf.decoder";
    public static final String EXTRACTOR_CLASS_NAME = "ProtobufRecorderMessageExtractor";
    public static final String EXTRACTOR_METHOD_NAME = "execute";

    public String codegen(Descriptors.Descriptor descriptor, Set<String> fieldsToRead) {
        HashMap<String, MessageDecoderMethod> msgDecodeCode = this.generateMessageDeserializeCode(descriptor, fieldsToRead);
        return this.generateRecordExtractorCode(descriptor, fieldsToRead, msgDecodeCode);
    }

    public String generateRecordExtractorCode(Descriptors.Descriptor descriptor, Set<String> fieldsToRead, HashMap<String, MessageDecoderMethod> msgDecodeCode) {
        String fullyQualifiedMsgName = ProtoBufUtils.getFullJavaName(descriptor);
        StringBuilder code = new StringBuilder();
        code.append(this.completeLine("package org.apache.pinot.plugin.inputformat.protobuf.decoder", 0));
        code.append(this.addImports(List.of("org.apache.pinot.spi.data.readers.GenericRow", "java.util.ArrayList", "java.util.HashMap", "java.util.List", "java.util.Map")));
        code.append("\n");
        code.append(String.format("public class %s {\n", EXTRACTOR_CLASS_NAME));
        int indent = 1;
        code.append(this.addIndent(String.format("public static GenericRow %s(byte[] from, GenericRow to) throws Exception {", EXTRACTOR_METHOD_NAME), indent));
        code.append(this.completeLine(String.format("Map<String, Object> msgMap = %s(%s.parseFrom(from))", msgDecodeCode.get(ProtoBufUtils.getFullJavaName(descriptor)).getMethodName(), fullyQualifiedMsgName), ++indent));
        List<Object> allDesc = new ArrayList();
        if (fieldsToRead != null && !fieldsToRead.isEmpty()) {
            for (String string : fieldsToRead.stream().sorted().collect(Collectors.toList())) {
                if (descriptor.findFieldByName(string) == null) {
                    LOGGER.debug("Field " + string + " not found in the descriptor");
                    continue;
                }
                allDesc.add(descriptor.findFieldByName(string));
            }
        } else {
            allDesc = descriptor.getFields();
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : allDesc) {
            code.append(this.completeLine(String.format("to.putValue(\"%s\", msgMap.getOrDefault(\"%s\", null))", fieldDescriptor.getName(), fieldDescriptor.getName()), indent));
        }
        code.append(this.completeLine("return to", indent));
        code.append(this.addIndent("}", --indent));
        for (MessageDecoderMethod messageDecoderMethod : msgDecodeCode.values()) {
            code.append("\n");
            code.append(messageDecoderMethod.getCode());
        }
        code.append(this.addIndent("}", --indent));
        return code.toString();
    }

    public HashMap<String, MessageDecoderMethod> generateMessageDeserializeCode(Descriptors.Descriptor mainDescriptor, Set<String> fieldsToRead) {
        HashMap<String, MessageDecoderMethod> msgDecodeCode = new HashMap<String, MessageDecoderMethod>();
        ArrayDeque<Descriptors.Descriptor> queue = new ArrayDeque<Descriptors.Descriptor>();
        queue.add(mainDescriptor);
        this.generateDecodeCodeForAMessage(msgDecodeCode, queue, fieldsToRead);
        while (!queue.isEmpty()) {
            this.generateDecodeCodeForAMessage(msgDecodeCode, queue, new HashSet<String>());
        }
        return msgDecodeCode;
    }

    void generateDecodeCodeForAMessage(Map<String, MessageDecoderMethod> msgDecodeCode, Queue<Descriptors.Descriptor> queue, Set<String> fieldsToRead) {
        Descriptors.Descriptor descriptor = queue.remove();
        String fullyQualifiedMsgName = ProtoBufUtils.getFullJavaName(descriptor);
        int varNum = 1;
        if (msgDecodeCode.containsKey(fullyQualifiedMsgName)) {
            return;
        }
        StringBuilder code = new StringBuilder();
        String methodNameOfDecoder = this.getDecoderMethodName(fullyQualifiedMsgName);
        int indent = 1;
        code.append(this.addIndent(String.format("public static Map<String, Object> %s(%s msg) {", methodNameOfDecoder, fullyQualifiedMsgName), indent));
        code.append(this.completeLine("Map<String, Object> msgMap = new HashMap<>()", ++indent));
        List<Object> descriptorsToDerive = new ArrayList();
        if (fieldsToRead != null && !fieldsToRead.isEmpty()) {
            for (String string : fieldsToRead.stream().sorted().collect(Collectors.toList())) {
                if (null == descriptor.findFieldByName(string)) {
                    LOGGER.debug("Field " + string + " not found in the descriptor");
                    continue;
                }
                descriptorsToDerive.add(descriptor.findFieldByName(string));
            }
        } else {
            descriptorsToDerive = descriptor.getFields();
        }
        block8: for (Descriptors.FieldDescriptor fieldDescriptor : descriptorsToDerive) {
            Descriptors.FieldDescriptor.Type type = fieldDescriptor.getType();
            String fieldNameInCode = ProtobufInternalUtils.underScoreToCamelCase(fieldDescriptor.getName(), true);
            switch (type) {
                case STRING: 
                case INT32: 
                case INT64: 
                case UINT64: 
                case FIXED64: 
                case FIXED32: 
                case UINT32: 
                case SFIXED32: 
                case SFIXED64: 
                case SINT32: 
                case SINT64: 
                case DOUBLE: 
                case FLOAT: {
                    code.append((CharSequence)this.codeForScalarFieldExtraction(fieldDescriptor, fieldNameInCode, indent));
                    continue block8;
                }
                case BOOL: {
                    code.append((CharSequence)this.codeForComplexFieldExtraction(fieldDescriptor, fieldNameInCode, "String", indent, ++varNum, "String.valueOf", ""));
                    continue block8;
                }
                case BYTES: {
                    code.append((CharSequence)this.codeForComplexFieldExtraction(fieldDescriptor, fieldNameInCode, "com.google.protobuf.ByteString", indent, ++varNum, "", ".toByteArray()"));
                    continue block8;
                }
                case ENUM: {
                    code.append((CharSequence)this.codeForComplexFieldExtraction(fieldDescriptor, fieldNameInCode, ProtoBufUtils.getFullJavaNameForEnum(fieldDescriptor.getEnumType()), indent, ++varNum, "", ".name()"));
                    continue block8;
                }
                case MESSAGE: {
                    String messageType = ProtoBufUtils.getFullJavaName(fieldDescriptor.getMessageType());
                    if (fieldDescriptor.isMapField()) {
                        Descriptors.FieldDescriptor valueDescriptor = fieldDescriptor.getMessageType().findFieldByName("value");
                        if (valueDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                            String valueDescClassName = ProtoBufUtils.getFullJavaName(valueDescriptor.getMessageType());
                            if (!msgDecodeCode.containsKey(valueDescClassName)) {
                                queue.add(valueDescriptor.getMessageType());
                            }
                            code.append((CharSequence)this.codeForMapWithValueMessageType(fieldDescriptor, fieldNameInCode, valueDescClassName, indent, varNum));
                            continue block8;
                        }
                        code.append(this.completeLine(this.putFieldInMsgMapCode(fieldDescriptor.getName(), this.getProtoFieldMethodName(fieldNameInCode + "Map"), null, null), indent));
                        continue block8;
                    }
                    if (!msgDecodeCode.containsKey(messageType)) {
                        queue.add(fieldDescriptor.getMessageType());
                    }
                    code.append((CharSequence)this.codeForComplexFieldExtraction(fieldDescriptor, fieldNameInCode, messageType, indent, ++varNum, this.getDecoderMethodName(messageType), ""));
                    continue block8;
                }
            }
            LOGGER.error(String.format("Protobuf type %s is not supported by pinot yet. Skipping this field %s", new Object[]{type, fieldDescriptor.getName()}));
        }
        code.append(this.completeLine("return msgMap", indent));
        code.append(this.addIndent("}", --indent));
        msgDecodeCode.put(fullyQualifiedMsgName, new MessageDecoderMethod(methodNameOfDecoder, code.toString()));
    }

    StringBuilder codeForMapWithValueMessageType(Descriptors.FieldDescriptor desc, String fieldNameInCode, String valueDescClassName, int indent, int varNum) {
        StringBuilder code = new StringBuilder();
        String mapVarName = "map" + ++varNum;
        StringBuilder code1 = new StringBuilder();
        code.append(this.completeLine(String.format("Map<Object, Map<String, Object>> %s = new HashMap<>()", mapVarName), indent));
        code.append(this.addIndent(String.format("for (Map.Entry<%s, %s> entry: msg.%s().entrySet()) {", ProtoBufUtils.getTypeStrFromProto(desc.getMessageType().findFieldByName("key")), ProtoBufUtils.getTypeStrFromProto(desc), this.getProtoFieldMethodName(fieldNameInCode + "Map")), indent));
        code.append(this.completeLine(String.format("%s.put(entry.getKey(), %s( (%s) entry.getValue()))", mapVarName, this.getDecoderMethodName(valueDescClassName), valueDescClassName), ++indent));
        code.append(this.addIndent("}", --indent));
        code.append(this.completeLine(String.format("msgMap.put(\"%s\", %s)", desc.getName(), mapVarName), indent));
        return code;
    }

    StringBuilder codeForScalarFieldExtraction(Descriptors.FieldDescriptor desc, String fieldNameInCode, int indent) {
        StringBuilder code = new StringBuilder();
        if (desc.isRepeated()) {
            code.append(this.addIndent(String.format("if (msg.%s() > 0) {", this.getCountMethodName(fieldNameInCode)), indent));
            code.append(this.completeLine(this.putFieldInMsgMapCode(desc.getName(), this.getProtoFieldListMethodName(fieldNameInCode) + "().toArray", null, null), ++indent));
            code.append(this.addIndent("}", --indent));
        } else if (desc.hasPresence()) {
            code.append(this.addIndent(String.format("if (msg.%s()) {", this.hasPresenceMethodName(fieldNameInCode)), indent));
            code.append(this.completeLine(this.putFieldInMsgMapCode(desc.getName(), this.getProtoFieldMethodName(fieldNameInCode), null, null), ++indent));
            code.append(this.addIndent("}", --indent));
        } else {
            code.append(this.completeLine(this.putFieldInMsgMapCode(desc.getName(), this.getProtoFieldMethodName(fieldNameInCode), null, null), indent));
        }
        return code;
    }

    StringBuilder codeForComplexFieldExtraction(Descriptors.FieldDescriptor desc, String fieldNameInCode, String javaFieldType, int indent, int varNum, String decoderMethod, String additionalExtractions) {
        StringBuilder code = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)additionalExtractions)) {
            additionalExtractions = "";
        }
        if (desc.isRepeated()) {
            String listVarName = "list" + ++varNum;
            code.append(this.completeLine(String.format("List<Object> %s = new ArrayList<>()", listVarName), indent));
            code.append(this.addIndent(String.format("for (%s row: msg.%s()) {", javaFieldType, this.getProtoFieldListMethodName(fieldNameInCode)), indent));
            if (!StringUtils.isBlank((CharSequence)decoderMethod)) {
                code.append(this.completeLine(String.format("%s.add(%s(row%s))", listVarName, decoderMethod, additionalExtractions), ++indent));
            } else {
                code.append(this.completeLine(String.format("%s.add(row%s)", listVarName, additionalExtractions), ++indent));
            }
            code.append(this.addIndent("}", --indent));
            code.append(this.addIndent(String.format("if (!%s.isEmpty()) {", listVarName), indent));
            code.append(this.completeLine(String.format("msgMap.put(\"%s\", %s.toArray())", desc.getName(), listVarName), ++indent));
            code.append(this.addIndent("}", --indent));
        } else if (desc.hasPresence()) {
            code.append(this.addIndent(String.format("if (msg.%s()) {", this.hasPresenceMethodName(fieldNameInCode)), indent));
            code.append(this.completeLine(this.putFieldInMsgMapCode(desc.getName(), this.getProtoFieldMethodName(fieldNameInCode), decoderMethod, additionalExtractions), ++indent));
            code.append(this.addIndent("}", --indent));
        } else {
            code.append(this.completeLine(this.putFieldInMsgMapCode(desc.getName(), this.getProtoFieldMethodName(fieldNameInCode), decoderMethod, additionalExtractions), indent));
        }
        return code;
    }

    private String getDecoderMethodName(String fullJavaType) {
        return String.format("decode%sMessage", fullJavaType.replace('.', '_'));
    }

    private String getProtoFieldMethodName(String msgNameInCode) {
        return String.format("get%s", msgNameInCode);
    }

    private String getProtoFieldListMethodName(String msgNameInCode) {
        return String.format("get%sList", msgNameInCode);
    }

    private String hasPresenceMethodName(String msgNameInCode) {
        return String.format("has%s", msgNameInCode);
    }

    private String getCountMethodName(String msgNameInCode) {
        return String.format("get%sCount", msgNameInCode);
    }

    protected String putFieldInMsgMapCode(String fieldNameInProto, String getFieldMethodName, String optionalDecodeMethod, String optionalAdditionalCalls) {
        if (StringUtils.isBlank((CharSequence)optionalAdditionalCalls)) {
            optionalAdditionalCalls = "";
        }
        if (!StringUtils.isBlank((CharSequence)optionalDecodeMethod)) {
            return String.format("msgMap.put(\"%s\", %s(msg.%s()%s))", fieldNameInProto, optionalDecodeMethod, getFieldMethodName, optionalAdditionalCalls);
        }
        return String.format("msgMap.put(\"%s\", msg.%s()%s)", fieldNameInProto, getFieldMethodName, optionalAdditionalCalls);
    }

    protected String addImports(List<String> classNames) {
        StringBuilder code = new StringBuilder();
        for (String className : classNames) {
            code.append("import ").append(className).append(";\n");
        }
        return code.toString();
    }

    protected String completeLine(String line, int indent) {
        return "  ".repeat(Math.max(0, indent)) + line + ";\n";
    }

    protected String addIndent(String line, int indent) {
        return "  ".repeat(Math.max(0, indent)) + line + "\n";
    }

    static class MessageDecoderMethod {
        private final String _methodName;
        private final String _code;

        MessageDecoderMethod(String methodName, String code) {
            this._methodName = methodName;
            this._code = code;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public String getCode() {
            return this._code;
        }
    }
}

