/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.helix.HelixAdmin;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.restlet.resources.ValidDocIdsBitmapResponse;
import org.apache.pinot.common.utils.RoaringBitmapUtils;
import org.apache.pinot.common.utils.ServiceStatus;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.util.ServerSegmentMetadataReader;
import org.apache.pinot.minion.MinionContext;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionTaskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinionTaskUtils.class);
    private static final String DEFAULT_DIR_PATH_TERMINATOR = "/";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC = "UTC";

    private MinionTaskUtils() {
    }

    public static PinotFS getInputPinotFS(Map<String, String> taskConfigs, URI fileURI) throws Exception {
        String fileURIScheme = fileURI.getScheme();
        if (fileURIScheme == null) {
            return new LocalPinotFS();
        }
        String fsClass = taskConfigs.get("input.fs.className");
        if (fsClass != null) {
            PinotFS pinotFS = (PinotFS)PluginManager.get().createInstance(fsClass);
            PinotConfiguration fsProps = IngestionConfigUtils.getInputFsProps(taskConfigs);
            pinotFS.init(fsProps);
            return pinotFS;
        }
        return PinotFSFactory.create((String)fileURIScheme);
    }

    public static PinotFS getOutputPinotFS(Map<String, String> taskConfigs, URI fileURI) throws Exception {
        String fileURIScheme;
        String string = fileURIScheme = fileURI == null ? null : fileURI.getScheme();
        if (fileURIScheme == null) {
            return new LocalPinotFS();
        }
        String fsClass = taskConfigs.get("output.fs.className");
        if (fsClass != null) {
            PinotFS pinotFS = (PinotFS)PluginManager.get().createInstance(fsClass);
            PinotConfiguration fsProps = IngestionConfigUtils.getOutputFsProps(taskConfigs);
            pinotFS.init(fsProps);
            return pinotFS;
        }
        return PinotFSFactory.create((String)fileURIScheme);
    }

    public static Map<String, String> getPushTaskConfig(String tableName, Map<String, String> taskConfigs, ClusterInfoAccessor clusterInfoAccessor) {
        try {
            String pushMode = IngestionConfigUtils.getPushMode(taskConfigs);
            HashMap<String, String> singleFileGenerationTaskConfig = new HashMap<String, String>(taskConfigs);
            if (pushMode == null || pushMode.toUpperCase().contentEquals(BatchConfigProperties.SegmentPushType.TAR.toString())) {
                singleFileGenerationTaskConfig.put("push.mode", BatchConfigProperties.SegmentPushType.TAR.toString());
            } else {
                URI outputDirURI = URI.create(MinionTaskUtils.normalizeDirectoryURI(clusterInfoAccessor.getDataDir()) + TableNameBuilder.extractRawTableName((String)tableName));
                String outputDirURIScheme = outputDirURI.getScheme();
                if (!MinionTaskUtils.isLocalOutputDir(outputDirURIScheme)) {
                    singleFileGenerationTaskConfig.put("output.segment.dir.uri", outputDirURI.toString());
                    if (pushMode.toUpperCase().contentEquals(BatchConfigProperties.SegmentPushType.URI.toString())) {
                        LOGGER.warn("URI push type is not supported in this task. Switching to METADATA push");
                        pushMode = BatchConfigProperties.SegmentPushType.METADATA.toString();
                    }
                    singleFileGenerationTaskConfig.put("push.mode", pushMode);
                } else {
                    LOGGER.warn("segment upload with METADATA push is not supported with local output dir: {}. Switching to TAR push.", (Object)outputDirURI);
                    singleFileGenerationTaskConfig.put("push.mode", BatchConfigProperties.SegmentPushType.TAR.toString());
                }
            }
            singleFileGenerationTaskConfig.put("push.controllerUri", clusterInfoAccessor.getVipUrl());
            return singleFileGenerationTaskConfig;
        }
        catch (Exception e) {
            return taskConfigs;
        }
    }

    public static boolean isLocalOutputDir(String outputDirURIScheme) {
        return outputDirURIScheme == null || outputDirURIScheme.startsWith("file");
    }

    public static PinotFS getLocalPinotFs() {
        return new LocalPinotFS();
    }

    public static String normalizeDirectoryURI(URI dirURI) {
        return MinionTaskUtils.normalizeDirectoryURI(dirURI.toString());
    }

    public static String normalizeDirectoryURI(String dirInStr) {
        if (!dirInStr.endsWith(DEFAULT_DIR_PATH_TERMINATOR)) {
            return dirInStr + DEFAULT_DIR_PATH_TERMINATOR;
        }
        return dirInStr;
    }

    public static List<String> getServers(String segmentName, String tableNameWithType, HelixAdmin helixAdmin, String clusterName) {
        ExternalView externalView = helixAdmin.getResourceExternalView(clusterName, tableNameWithType);
        if (externalView == null) {
            throw new IllegalStateException("External view does not exist for table: " + tableNameWithType);
        }
        Map instanceStateMap = externalView.getStateMap(segmentName);
        if (instanceStateMap == null) {
            throw new IllegalStateException("Failed to find segment: " + segmentName);
        }
        ArrayList<String> servers = new ArrayList<String>();
        for (Map.Entry entry : instanceStateMap.entrySet()) {
            if (!((String)entry.getValue()).equals("ONLINE")) continue;
            servers.add((String)entry.getKey());
        }
        if (servers.isEmpty()) {
            throw new IllegalStateException("Failed to find any ONLINE servers for segment: " + segmentName);
        }
        return servers;
    }

    public static boolean extractMinionAllowDownloadFromServer(TableConfig tableConfig, String taskType, boolean defaultValue) {
        Map configs;
        TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
        if (tableTaskConfig != null && (configs = tableTaskConfig.getConfigsForTaskType(taskType)) != null && !configs.isEmpty()) {
            return Boolean.parseBoolean(configs.getOrDefault("allowDownloadFromServer", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    @Nullable
    public static RoaringBitmap getValidDocIdFromServerMatchingCrc(String tableNameWithType, String segmentName, String validDocIdsType, MinionContext minionContext, String expectedCrc) {
        String clusterName = minionContext.getHelixManager().getClusterName();
        HelixAdmin helixAdmin = minionContext.getHelixManager().getClusterManagmentTool();
        RoaringBitmap validDocIds = null;
        List<String> servers = MinionTaskUtils.getServers(segmentName, tableNameWithType, helixAdmin, clusterName);
        for (String server : servers) {
            String message;
            ValidDocIdsBitmapResponse validDocIdsBitmapResponse;
            InstanceConfig instanceConfig = helixAdmin.getInstanceConfig(clusterName, server);
            String endpoint = InstanceUtils.getServerAdminEndpoint((InstanceConfig)instanceConfig);
            ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader();
            try {
                validDocIdsBitmapResponse = serverSegmentMetadataReader.getValidDocIdsBitmapFromServer(tableNameWithType, segmentName, endpoint, validDocIdsType, 60000);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to retrieve validDocIds bitmap for segment: " + segmentName + " from endpoint: " + endpoint, (Throwable)e);
                continue;
            }
            String crcFromValidDocIdsBitmap = validDocIdsBitmapResponse.getSegmentCrc();
            if (!expectedCrc.equals(crcFromValidDocIdsBitmap)) {
                message = "CRC mismatch for segment: " + segmentName + ", expected value based on task generator: " + expectedCrc + ", actual crc from validDocIdsBitmapResponse from endpoint " + endpoint + ": " + crcFromValidDocIdsBitmap;
                LOGGER.warn(message);
                continue;
            }
            if (validDocIdsBitmapResponse.getServerStatus() != null && !validDocIdsBitmapResponse.getServerStatus().equals((Object)ServiceStatus.Status.GOOD)) {
                message = "Server " + validDocIdsBitmapResponse.getInstanceId() + " is in " + String.valueOf(validDocIdsBitmapResponse.getServerStatus()) + " state, skipping it for execution for segment: " + validDocIdsBitmapResponse.getSegmentName() + ". Will try other servers.";
                LOGGER.warn(message);
                continue;
            }
            validDocIds = RoaringBitmapUtils.deserialize((byte[])validDocIdsBitmapResponse.getBitmap());
            break;
        }
        return validDocIds;
    }

    public static String toUTCString(long epochMillis) {
        Date date = new Date(epochMillis);
        SimpleDateFormat isoFormat = new SimpleDateFormat(DATETIME_PATTERN);
        isoFormat.setTimeZone(TimeZone.getTimeZone(UTC));
        return isoFormat.format(date);
    }

    public static long fromUTCString(String utcString) {
        return Instant.parse(utcString).toEpochMilli();
    }
}

