/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MergeRollupTaskUtils {
    private static final String[] VALID_CONFIG_KEYS = new String[]{"bucketTimePeriod", "bufferTimePeriod", "roundBucketTimePeriod", "mergeType", "maxNumRecordsPerSegment", "maxNumRecordsPerTask", "maxNumParallelBuckets", "eraseDimensionValues"};

    private MergeRollupTaskUtils() {
    }

    public static Map<String, Map<String, String>> getLevelToConfigMap(Map<String, String> taskConfig) {
        TreeMap<String, Map<String, String>> levelToConfigMap = new TreeMap<String, Map<String, String>>();
        Pattern pattern = Pattern.compile("(\\w+)\\.aggregationFunctionParameters\\.(\\w+)\\.(\\w+)");
        for (Map.Entry<String, String> entry : taskConfig.entrySet()) {
            String key = entry.getKey();
            for (String configKey : VALID_CONFIG_KEYS) {
                if (key.endsWith(configKey)) {
                    if (key.length() - configKey.length() < 2) {
                        throw new IllegalStateException("Configuration key: " + key + " should be prefixed by merge level, e.g. '1day.'");
                    }
                    String level = key.substring(0, key.length() - configKey.length() - 1);
                    levelToConfigMap.computeIfAbsent(level, k -> new TreeMap()).put(configKey, entry.getValue());
                    continue;
                }
                Matcher matcher = pattern.matcher(key);
                if (!matcher.matches()) continue;
                String level = matcher.group(1).trim();
                String metric = matcher.group(2).trim();
                String param = matcher.group(3).trim();
                String metricParam = "aggregationFunctionParameters." + metric + "." + param;
                levelToConfigMap.computeIfAbsent(level, k -> new TreeMap()).put(metricParam, entry.getValue());
            }
        }
        return levelToConfigMap;
    }

    public static String buildMergeLevelKeyPrefix(String key, Map<String, String> taskConfig) {
        String mergeLevel = taskConfig.get("mergeLevel");
        if (mergeLevel == null) {
            return key;
        }
        return mergeLevel + "." + key;
    }

    public static Set<String> getDimensionsToErase(Map<String, String> taskConfig) {
        if (taskConfig == null) {
            return new HashSet<String>();
        }
        String key = MergeRollupTaskUtils.buildMergeLevelKeyPrefix("eraseDimensionValues", taskConfig);
        String dimensionsToErase = taskConfig.get(key);
        if (dimensionsToErase == null) {
            return new HashSet<String>();
        }
        return Arrays.stream(dimensionsToErase.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    public static Map<String, Map<String, String>> getAggregationFunctionParameters(Map<String, String> taskConfig) {
        HashMap<String, Map<String, String>> aggregationFunctionParameters = new HashMap<String, Map<String, String>>();
        String prefix = MergeRollupTaskUtils.buildMergeLevelKeyPrefix("aggregationFunctionParameters.", taskConfig);
        for (Map.Entry<String, String> entry : taskConfig.entrySet()) {
            String[] parts;
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(prefix) || (parts = key.substring(prefix.length()).split("\\.", 2)).length != 2) continue;
            String metricColumn = parts[0];
            String paramName = parts[1];
            aggregationFunctionParameters.computeIfAbsent(metricColumn, k -> new HashMap()).put(paramName, value);
        }
        return aggregationFunctionParameters;
    }

    @VisibleForTesting
    public static List<String> getValidConfigKeys() {
        return Arrays.asList(VALID_CONFIG_KEYS);
    }
}

