/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.segmentgenerationandpush;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.segment.generation.SegmentGenerationUtils;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.ingestion.batch.BatchConfigProperties;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.Obfuscator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class SegmentGenerationAndPushTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentGenerationAndPushTaskGenerator.class);
    private static final BatchConfigProperties.SegmentPushType DEFAULT_SEGMENT_PUSH_TYPE = BatchConfigProperties.SegmentPushType.TAR;

    public String getTaskType() {
        return "SegmentGenerationAndPushTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            int tableNumTasks;
            int tableMaxNumTasks;
            String tableNameWithType = tableConfig.getTableName();
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            Preconditions.checkNotNull((Object)tableTaskConfig);
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType("SegmentGenerationAndPushTask");
            Preconditions.checkNotNull((Object)taskConfigs, (String)"Task config shouldn't be null for Table: %s", (Object)tableNameWithType);
            String tableMaxNumTasksConfig = (String)taskConfigs.get("tableMaxNumTasks");
            if (tableMaxNumTasksConfig != null) {
                try {
                    tableMaxNumTasks = Integer.parseInt(tableMaxNumTasksConfig);
                }
                catch (NumberFormatException e) {
                    tableMaxNumTasks = Integer.MAX_VALUE;
                }
            } else {
                tableMaxNumTasks = Integer.MAX_VALUE;
            }
            if ((tableNumTasks = 0) == tableMaxNumTasks) break;
            String batchSegmentIngestionType = IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig);
            BatchIngestionConfig batchIngestionConfig = tableConfig.getIngestionConfig().getBatchIngestionConfig();
            List batchConfigMaps = batchIngestionConfig.getBatchConfigMaps();
            for (Map batchConfigMap : batchConfigMaps) {
                try {
                    URI inputDirURI = SegmentGenerationUtils.getDirectoryURI((String)((String)batchConfigMap.get("inputDirURI")));
                    this.updateRecordReaderConfigs(batchConfigMap);
                    List segmentsZKMetadata = Collections.emptyList();
                    if (BatchConfigProperties.SegmentIngestionType.APPEND.name().equalsIgnoreCase(batchSegmentIngestionType)) {
                        segmentsZKMetadata = this.getSegmentsZKMetadataForTable(tableNameWithType);
                    }
                    Set<String> existingSegmentInputFiles = this.getExistingSegmentInputFiles(segmentsZKMetadata);
                    Set<String> inputFilesFromRunningTasks = this.getInputFilesFromRunningTasks(tableNameWithType);
                    existingSegmentInputFiles.addAll(inputFilesFromRunningTasks);
                    LOGGER.info("Trying to extract input files from path: {}, and exclude input files from existing segments metadata: {}, and input files from running tasks: {}", new Object[]{inputDirURI, existingSegmentInputFiles, inputFilesFromRunningTasks});
                    List<URI> inputFileURIs = this.getInputFilesFromDirectory(batchConfigMap, inputDirURI, existingSegmentInputFiles);
                    if (inputFileURIs.size() < 10) {
                        LOGGER.info("Final input files for task config generation: {}", inputFileURIs);
                    } else {
                        LOGGER.info("Final input files for task config generation: {}...", inputFileURIs.subList(0, 10));
                    }
                    for (URI inputFileURI : inputFileURIs) {
                        Map<String, String> singleFileGenerationTaskConfig = this.getSingleFileGenerationTaskConfig(tableNameWithType, tableNumTasks, batchConfigMap, inputFileURI, null);
                        pinotTaskConfigs.add(new PinotTaskConfig("SegmentGenerationAndPushTask", singleFileGenerationTaskConfig));
                        if (++tableNumTasks != tableMaxNumTasks) continue;
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("Unable to generate the SegmentGenerationAndPush task. [ table configs: {}, task configs: {} ]", new Object[]{Obfuscator.DEFAULT.toJsonString((Object)tableConfig), Obfuscator.DEFAULT.toJsonString((Object)taskConfigs), e});
                }
            }
        }
        return pinotTaskConfigs;
    }

    public List<PinotTaskConfig> generateTasks(TableConfig tableConfig, Map<String, String> taskConfigs) throws Exception {
        String taskUUID = UUID.randomUUID().toString();
        String tableNameWithType = tableConfig.getTableName();
        HashMap<String, String> batchConfigMap = new HashMap<String, String>();
        TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
        if (tableTaskConfig != null) {
            batchConfigMap.putAll(tableTaskConfig.getConfigsForTaskType("SegmentGenerationAndPushTask"));
        }
        batchConfigMap.putAll(taskConfigs);
        int tableNumTasks = 0;
        try {
            URI inputDirURI = SegmentGenerationUtils.getDirectoryURI((String)((String)batchConfigMap.get("inputDirURI")));
            List<URI> inputFileURIs = this.getInputFilesFromDirectory(batchConfigMap, inputDirURI, Collections.emptySet());
            if (inputFileURIs.isEmpty()) {
                LOGGER.warn("Skip generating SegmentGenerationAndPushTask, no input files found : {}", (Object)inputDirURI);
                return ImmutableList.of();
            }
            if (!batchConfigMap.containsKey("inputFormat")) {
                batchConfigMap.put("inputFormat", this.extractFormatFromFileSuffix(inputFileURIs.get(0).getPath()));
            }
            this.updateRecordReaderConfigs(batchConfigMap);
            ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
            LOGGER.info("Final input files for task config generation: {}", inputFileURIs);
            for (URI inputFileURI : inputFileURIs) {
                Map<String, String> singleFileGenerationTaskConfig = this.getSingleFileGenerationTaskConfig(tableNameWithType, tableNumTasks, batchConfigMap, inputFileURI, this.generateFixedSegmentName(tableNameWithType, taskUUID, tableNumTasks));
                pinotTaskConfigs.add(new PinotTaskConfig("SegmentGenerationAndPushTask", singleFileGenerationTaskConfig));
                ++tableNumTasks;
            }
            if (!batchConfigMap.containsKey("inputFormat")) {
                batchConfigMap.put("inputFormat", this.extractFormatFromFileSuffix(inputFileURIs.get(0).getPath()));
                this.updateRecordReaderConfigs(batchConfigMap);
            }
            return pinotTaskConfigs;
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unable to generate the SegmentGenerationAndPush task. [ table configs: {}, task configs: {} ]", new Object[]{Obfuscator.DEFAULT.toJsonString((Object)tableConfig), Obfuscator.DEFAULT.toJsonString(taskConfigs), e});
            }
            throw e;
        }
    }

    private String generateFixedSegmentName(String tableName, String taskUUID, int tableNumTasks) {
        return String.format("%s_%s_%d", tableName, taskUUID, tableNumTasks);
    }

    private String extractFormatFromFileSuffix(String path) {
        int lastDotPosition = path.lastIndexOf(".");
        if (lastDotPosition < 0) {
            throw new UnsupportedOperationException("No file extension found");
        }
        return path.substring(lastDotPosition + 1);
    }

    private Set<String> getInputFilesFromRunningTasks(String tableName) {
        HashSet<String> inputFilesFromRunningTasks = new HashSet<String>();
        TaskGeneratorUtils.forRunningTasks((String)tableName, (String)"SegmentGenerationAndPushTask", (ClusterInfoAccessor)this._clusterInfoAccessor, taskConfig -> {
            String inputFileURI = (String)taskConfig.get("input.data.file.uri");
            if (inputFileURI != null) {
                inputFilesFromRunningTasks.add(inputFileURI);
            }
        });
        return inputFilesFromRunningTasks;
    }

    private Map<String, String> getSingleFileGenerationTaskConfig(String tableName, int sequenceID, Map<String, String> batchConfigMap, URI inputFileURI, @Nullable String segmentName) throws URISyntaxException {
        URI inputDirURI = SegmentGenerationUtils.getDirectoryURI((String)batchConfigMap.get("inputDirURI"));
        URI outputDirURI = null;
        if (batchConfigMap.containsKey("outputDirURI")) {
            outputDirURI = SegmentGenerationUtils.getDirectoryURI((String)batchConfigMap.get("outputDirURI"));
        }
        String pushMode = IngestionConfigUtils.getPushMode(batchConfigMap);
        HashMap<String, String> singleFileGenerationTaskConfig = new HashMap<String, String>(batchConfigMap);
        singleFileGenerationTaskConfig.put("tableName", tableName);
        singleFileGenerationTaskConfig.put("input.data.file.uri", inputFileURI.toString());
        if (outputDirURI != null) {
            URI outputSegmentDirURI = SegmentGenerationUtils.getRelativeOutputPath((URI)inputDirURI, (URI)inputFileURI, (URI)outputDirURI);
            singleFileGenerationTaskConfig.put("output.segment.dir.uri", outputSegmentDirURI.toString());
        }
        singleFileGenerationTaskConfig.put("sequenceId", String.valueOf(sequenceID));
        if (!singleFileGenerationTaskConfig.containsKey("segmentNameGenerator.type")) {
            if (segmentName == null) {
                singleFileGenerationTaskConfig.put("segmentNameGenerator.type", "simple");
            } else {
                singleFileGenerationTaskConfig.put("segmentNameGenerator.type", "fixed");
                singleFileGenerationTaskConfig.put("segmentNameGenerator.configs.segment.name", segmentName);
            }
        }
        singleFileGenerationTaskConfig.put("append.uuid.to.segment.name", Boolean.toString(true));
        if (outputDirURI == null || pushMode == null) {
            singleFileGenerationTaskConfig.put("push.mode", DEFAULT_SEGMENT_PUSH_TYPE.toString());
        } else {
            singleFileGenerationTaskConfig.put("push.mode", pushMode);
        }
        singleFileGenerationTaskConfig.put("push.controllerUri", this._clusterInfoAccessor.getVipUrl());
        return singleFileGenerationTaskConfig;
    }

    private void updateRecordReaderConfigs(Map<String, String> batchConfigMap) {
        String recordReaderConfigClassName;
        String inputFormat = batchConfigMap.get("inputFormat");
        String recordReaderClassName = PluginManager.get().getRecordReaderClassName(inputFormat);
        if (recordReaderClassName != null) {
            batchConfigMap.putIfAbsent("recordReader.className", recordReaderClassName);
        }
        if ((recordReaderConfigClassName = PluginManager.get().getRecordReaderConfigClassName(inputFormat)) != null) {
            batchConfigMap.putIfAbsent("recordReader.configClassName", recordReaderConfigClassName);
        }
    }

    private List<URI> getInputFilesFromDirectory(Map<String, String> batchConfigMap, URI inputDirURI, Set<String> existingSegmentInputFileURIs) throws Exception {
        PinotFS inputDirFS = MinionTaskUtils.getInputPinotFS(batchConfigMap, inputDirURI);
        try {
            String[] files;
            String includeFileNamePattern = batchConfigMap.get("includeFileNamePattern");
            String excludeFileNamePattern = batchConfigMap.get("excludeFileNamePattern");
            try {
                files = inputDirFS.listFiles(inputDirURI, true);
            }
            catch (IOException e) {
                LOGGER.error("Unable to list files under URI: {}", (Object)inputDirURI, (Object)e);
                List<URI> list = Collections.emptyList();
                if (inputDirFS != null) {
                    inputDirFS.close();
                }
                return list;
            }
            PathMatcher includeFilePathMatcher = null;
            if (includeFileNamePattern != null) {
                includeFilePathMatcher = FileSystems.getDefault().getPathMatcher(includeFileNamePattern);
            }
            PathMatcher excludeFilePathMatcher = null;
            if (excludeFileNamePattern != null) {
                excludeFilePathMatcher = FileSystems.getDefault().getPathMatcher(excludeFileNamePattern);
            }
            ArrayList<URI> inputFileURIs = new ArrayList<URI>();
            for (String file : files) {
                LOGGER.debug("Processing file: {}", (Object)file);
                if (includeFilePathMatcher != null && !includeFilePathMatcher.matches(Paths.get(file, new String[0]))) {
                    LOGGER.debug("Exclude file {} as it's not matching includeFilePathMatcher: {}", (Object)file, (Object)includeFileNamePattern);
                    continue;
                }
                if (excludeFilePathMatcher != null && excludeFilePathMatcher.matches(Paths.get(file, new String[0]))) {
                    LOGGER.debug("Exclude file {} as it's matching excludeFilePathMatcher: {}", (Object)file, (Object)excludeFileNamePattern);
                    continue;
                }
                try {
                    URI inputFileURI = SegmentGenerationUtils.getFileURI((String)file, (URI)inputDirURI);
                    if (existingSegmentInputFileURIs.contains(inputFileURI.toString())) {
                        LOGGER.debug("Skipping already processed inputFileURI: {}", (Object)inputFileURI);
                        continue;
                    }
                    if (inputDirFS.isDirectory(inputFileURI)) {
                        LOGGER.debug("Skipping directory: {}", (Object)inputFileURI);
                        continue;
                    }
                    inputFileURIs.add(inputFileURI);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to construct inputFileURI for path: {}, parent directory URI: {}", new Object[]{file, inputDirURI, e});
                }
            }
            ArrayList<URI> arrayList = inputFileURIs;
            return arrayList;
        }
        finally {
            if (inputDirFS != null) {
                try {
                    inputDirFS.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Set<String> getExistingSegmentInputFiles(List<SegmentZKMetadata> segmentsZKMetadata) {
        HashSet<String> existingSegmentInputFiles = new HashSet<String>();
        for (SegmentZKMetadata segmentZKMetadata : segmentsZKMetadata) {
            Map customMap = segmentZKMetadata.getCustomMap();
            if (customMap == null || !customMap.containsKey("input.data.file.uri")) continue;
            existingSegmentInputFiles.add((String)customMap.get("input.data.file.uri"));
        }
        return existingSegmentInputFiles;
    }
}

