/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.upsertcompactmerge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.ValidDocIdsMetadataInfo;
import org.apache.pinot.common.restlet.resources.ValidDocIdsType;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.common.utils.ServiceStatus;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.controller.util.ServerSegmentMetadataReader;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.Enablement;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class UpsertCompactMergeTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpsertCompactMergeTaskGenerator.class);
    private static final String DEFAULT_BUFFER_PERIOD = "2d";
    private static final int DEFAULT_NUM_SEGMENTS_BATCH_PER_SERVER_REQUEST = 500;

    public String getTaskType() {
        return "UpsertCompactMergeTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "UpsertCompactMergeTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            BiMap serverToEndpoints;
            List allSegments;
            String tableNameWithType = tableConfig.getTableName();
            LOGGER.info("Start generating task configs for table: {}", (Object)tableNameWithType);
            if (tableConfig.getTaskConfig() == null) {
                LOGGER.warn("Task config is null for table: {}", (Object)tableNameWithType);
                continue;
            }
            Map incompleteTasks = TaskGeneratorUtils.getIncompleteTasks((String)taskType, (String)tableNameWithType, (ClusterInfoAccessor)this._clusterInfoAccessor);
            if (!incompleteTasks.isEmpty()) {
                LOGGER.warn("Found incomplete tasks: {} for same table: {} and task type: {}. Skipping task generation.", new Object[]{incompleteTasks.keySet(), tableNameWithType, taskType});
                continue;
            }
            Map taskConfigs = tableConfig.getTaskConfig().getConfigsForTaskType(taskType);
            List<SegmentZKMetadata> candidateSegments = UpsertCompactMergeTaskGenerator.getCandidateSegments(taskConfigs, allSegments = this._clusterInfoAccessor.getSegmentsZKMetadata(tableNameWithType), System.currentTimeMillis());
            if (candidateSegments.isEmpty()) {
                LOGGER.info("No segments were eligible for compactMerge task for table: {}", (Object)tableNameWithType);
                continue;
            }
            PinotHelixResourceManager pinotHelixResourceManager = this._clusterInfoAccessor.getPinotHelixResourceManager();
            Map serverToSegments = pinotHelixResourceManager.getServerToOnlineSegmentsMapFromEV(tableNameWithType, true);
            try {
                serverToEndpoints = pinotHelixResourceManager.getDataInstanceAdminEndpoints(serverToSegments.keySet());
            }
            catch (InvalidConfigException e) {
                throw new RuntimeException(e);
            }
            ServerSegmentMetadataReader serverSegmentMetadataReader = new ServerSegmentMetadataReader(this._clusterInfoAccessor.getExecutor(), (HttpClientConnectionManager)this._clusterInfoAccessor.getConnectionManager());
            int numSegmentsBatchPerServerRequest = Integer.parseInt(taskConfigs.getOrDefault("numSegmentsBatchPerServerRequest", String.valueOf(500)));
            Map validDocIdsMetadataList = serverSegmentMetadataReader.getSegmentToValidDocIdsMetadataFromServer(tableNameWithType, serverToSegments, serverToEndpoints, null, 60000, ValidDocIdsType.SNAPSHOT.toString(), numSegmentsBatchPerServerRequest);
            Map<String, SegmentZKMetadata> candidateSegmentsMap = candidateSegments.stream().collect(Collectors.toMap(SegmentZKMetadata::getSegmentName, Function.identity()));
            Set<String> alreadyMergedSegments = UpsertCompactMergeTaskGenerator.getAlreadyMergedSegments(allSegments);
            SegmentSelectionResult segmentSelectionResult = UpsertCompactMergeTaskGenerator.processValidDocIdsMetadata(tableNameWithType, taskConfigs, candidateSegmentsMap, validDocIdsMetadataList, alreadyMergedSegments);
            if (!segmentSelectionResult.getSegmentsForDeletion().isEmpty()) {
                pinotHelixResourceManager.deleteSegments(tableNameWithType, segmentSelectionResult.getSegmentsForDeletion(), "0d");
                LOGGER.info("Deleted segments containing only invalid records for table: {}, number of segments to be deleted: {}", (Object)tableNameWithType, segmentSelectionResult.getSegmentsForDeletion());
            }
            int numTasks = 0;
            int maxTasks = Integer.parseInt(taskConfigs.getOrDefault("tableMaxNumTasks", String.valueOf(1L)));
            for (Map.Entry<Integer, List<List<SegmentMergerMetadata>>> entry : segmentSelectionResult.getSegmentsForCompactMergeByPartition().entrySet()) {
                if (numTasks == maxTasks) break;
                List<List<SegmentMergerMetadata>> groups = entry.getValue();
                if (groups.isEmpty() || groups.get(0).size() <= 1) continue;
                HashMap<String, Object> configs = new HashMap<String, Object>(this.getBaseTaskConfigs(tableConfig, groups.get(0).stream().map(x -> x.getSegmentZKMetadata().getSegmentName()).collect(Collectors.toList())));
                configs.put("downloadURL", this.getDownloadUrl(groups.get(0)));
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("crc", this.getSegmentCrcList(groups.get(0)));
                configs.put("maxZKCreationTimeMillis", String.valueOf(this.getMaxZKCreationTimeMillis(groups.get(0))));
                configs.put("maxNumRecordsPerSegment", String.valueOf(Long.parseLong(taskConfigs.getOrDefault("maxNumRecordsPerSegment", String.valueOf(5000000L)))));
                pinotTaskConfigs.add(new PinotTaskConfig("UpsertCompactMergeTask", configs));
                ++numTasks;
            }
            LOGGER.info("Finished generating {} tasks configs for table: {}", (Object)numTasks, (Object)tableNameWithType);
        }
        return pinotTaskConfigs;
    }

    @VisibleForTesting
    public static SegmentSelectionResult processValidDocIdsMetadata(String tableNameWithType, Map<String, String> taskConfigs, Map<String, SegmentZKMetadata> candidateSegmentsMap, Map<String, List<ValidDocIdsMetadataInfo>> validDocIdsMetadataInfoMap, Set<String> alreadyMergedSegments) {
        HashMap<Integer, List> segmentsEligibleForCompactMerge = new HashMap<Integer, List>();
        HashSet<String> segmentsForDeletion = new HashSet<String>();
        long validDocsThreshold = Long.parseLong(taskConfigs.getOrDefault("maxNumRecordsPerSegment", String.valueOf(5000000L)));
        long maxRecordsPerTask = Long.parseLong(taskConfigs.getOrDefault("maxNumRecordsPerTask", String.valueOf(50000000L)));
        long maxNumSegments = Long.parseLong(taskConfigs.getOrDefault("maxNumSegmentsPerTask", String.valueOf(10L)));
        long outputSegmentMaxSizeInBytes = Long.MAX_VALUE;
        try {
            if (taskConfigs.containsKey("outputSegmentMaxSize")) {
                String configuredOutputSegmentMaxSize = taskConfigs.get("outputSegmentMaxSize");
                LOGGER.info("Configured outputSegmentMaxSizeInByte: {} for {}", (Object)configuredOutputSegmentMaxSize, (Object)tableNameWithType);
                outputSegmentMaxSizeInBytes = DataSizeUtils.toBytes((String)configuredOutputSegmentMaxSize);
            } else {
                LOGGER.info("No configured outputSegmentMaxSizeInByte for {}, defaulting to Long.MAX_VALUE", (Object)tableNameWithType);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Invalid value outputSegmentMaxSizeInBytes configured for {}, defaulting to Long.MAX_VALUE", (Object)tableNameWithType, (Object)e);
        }
        block2: for (String segmentName : validDocIdsMetadataInfoMap.keySet()) {
            if (!candidateSegmentsMap.containsKey(segmentName)) {
                LOGGER.debug("Segment {} is not found in the candidate segments list, skipping it for {}", (Object)segmentName, (Object)"UpsertCompactMergeTask");
                continue;
            }
            SegmentZKMetadata segment = candidateSegmentsMap.get(segmentName);
            for (ValidDocIdsMetadataInfo validDocIdsMetadata : validDocIdsMetadataInfoMap.get(segmentName)) {
                long totalInvalidDocs = validDocIdsMetadata.getTotalInvalidDocs();
                long totalValidDocs = validDocIdsMetadata.getTotalValidDocs();
                long segmentSizeInBytes = validDocIdsMetadata.getSegmentSizeInBytes();
                if (segment.getCrc() != Long.parseLong(validDocIdsMetadata.getSegmentCrc())) {
                    LOGGER.warn("CRC mismatch for segment: {}, (segmentZKMetadata={}, validDocIdsMetadata={})", new Object[]{segmentName, segment.getCrc(), validDocIdsMetadata.getSegmentCrc()});
                    continue;
                }
                if (validDocIdsMetadata.getServerStatus() != null && !validDocIdsMetadata.getServerStatus().equals((Object)ServiceStatus.Status.GOOD)) {
                    LOGGER.warn("Server {} is in {} state, skipping {} generation for segment: {}", new Object[]{validDocIdsMetadata.getInstanceId(), validDocIdsMetadata.getServerStatus(), "UpsertCompactMergeTask", segmentName});
                    continue;
                }
                long totalDocs = validDocIdsMetadata.getTotalDocs();
                if (totalInvalidDocs == totalDocs) {
                    segmentsForDeletion.add(segmentName);
                    continue block2;
                }
                if (alreadyMergedSegments.contains(segmentName)) {
                    LOGGER.debug("Segment {} already merged. Skipping it for {}", (Object)segmentName, (Object)"UpsertCompactMergeTask");
                    continue block2;
                }
                Integer partitionID2 = SegmentUtils.getPartitionIdFromSegmentName((String)segmentName);
                if (partitionID2 == null) {
                    LOGGER.warn("Partition ID not found for segment: {}, skipping it for {}", (Object)segmentName, (Object)"UpsertCompactMergeTask");
                    continue;
                }
                double expectedSegmentSizeAfterCompaction = (double)(segmentSizeInBytes * totalValidDocs) * 1.0 / (double)totalDocs;
                segmentsEligibleForCompactMerge.computeIfAbsent(partitionID2, k -> new ArrayList()).add(new SegmentMergerMetadata(segment, totalValidDocs, totalInvalidDocs, expectedSegmentSizeAfterCompaction));
                continue block2;
            }
        }
        segmentsEligibleForCompactMerge.forEach((partitionID, segmentList) -> segmentList.sort(Comparator.comparingLong(o -> o.getSegmentZKMetadata().getCreationTime())));
        HashMap<Integer, List<List<SegmentMergerMetadata>>> groupedSegments = new HashMap<Integer, List<List<SegmentMergerMetadata>>>();
        for (Map.Entry entry : segmentsEligibleForCompactMerge.entrySet()) {
            List compactMergeGroups;
            int partitionID3 = (Integer)entry.getKey();
            List segments = (List)entry.getValue();
            ArrayList groups = new ArrayList();
            ArrayList<SegmentMergerMetadata> currentGroup = new ArrayList<SegmentMergerMetadata>();
            long currentValidDocsSum = 0L;
            long currentTotalDocsSum = 0L;
            double currentOutputSegmentSizeInBytes = 0.0;
            for (SegmentMergerMetadata segment : segments) {
                long validDocs = segment.getValidDocIds();
                long invalidDocs = segment.getInvalidDocIds();
                double expectedSegmentSizeInBytes = segment.getSegmentSizeInBytes();
                if (currentValidDocsSum + validDocs <= validDocsThreshold && (long)currentGroup.size() < maxNumSegments && currentTotalDocsSum + validDocs + invalidDocs < maxRecordsPerTask && currentOutputSegmentSizeInBytes + expectedSegmentSizeInBytes < (double)outputSegmentMaxSizeInBytes) {
                    currentGroup.add(segment);
                    currentValidDocsSum += validDocs;
                    currentTotalDocsSum += validDocs + invalidDocs;
                    currentOutputSegmentSizeInBytes += expectedSegmentSizeInBytes;
                    continue;
                }
                if (!currentGroup.isEmpty()) {
                    groups.add(new ArrayList(currentGroup));
                }
                currentGroup = new ArrayList();
                currentGroup.add(segment);
                currentValidDocsSum = validDocs;
                currentTotalDocsSum = validDocs + invalidDocs;
                currentOutputSegmentSizeInBytes = expectedSegmentSizeInBytes;
            }
            if (!currentGroup.isEmpty()) {
                groups.add(new ArrayList(currentGroup));
            }
            if ((compactMergeGroups = groups.stream().filter(x -> x.size() > 1).sorted((group1, group2) -> {
                long invalidDocsSum1 = group1.stream().mapToLong(SegmentMergerMetadata::getInvalidDocIds).sum();
                long invalidDocsSum2 = group2.stream().mapToLong(SegmentMergerMetadata::getInvalidDocIds).sum();
                if (invalidDocsSum2 < invalidDocsSum1) {
                    return -1;
                }
                if (invalidDocsSum2 == invalidDocsSum1) {
                    return Long.compare(group2.size(), group1.size());
                }
                return 1;
            }).collect(Collectors.toList())).isEmpty()) continue;
            groupedSegments.put(partitionID3, compactMergeGroups);
        }
        return new SegmentSelectionResult(groupedSegments, new ArrayList<String>(segmentsForDeletion));
    }

    @VisibleForTesting
    public static List<SegmentZKMetadata> getCandidateSegments(Map<String, String> taskConfigs, List<SegmentZKMetadata> allSegments, long currentTimeInMillis) {
        ArrayList<SegmentZKMetadata> candidateSegments = new ArrayList<SegmentZKMetadata>();
        String bufferPeriod = taskConfigs.getOrDefault("bufferTimePeriod", DEFAULT_BUFFER_PERIOD);
        long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferPeriod);
        for (SegmentZKMetadata segment : allSegments) {
            if (StringUtils.isBlank((CharSequence)segment.getDownloadUrl())) {
                LOGGER.warn("Skipping segment {} for task as download url is empty", (Object)segment.getSegmentName());
                continue;
            }
            if (!segment.getStatus().isCompleted() || segment.getEndTimeMs() > currentTimeInMillis - bufferMs) continue;
            candidateSegments.add(segment);
        }
        return candidateSegments;
    }

    @VisibleForTesting
    protected static Set<String> getAlreadyMergedSegments(List<SegmentZKMetadata> allSegments) {
        HashSet<String> alreadyMergedSegments = new HashSet<String>();
        for (SegmentZKMetadata segment : allSegments) {
            if (segment.getCustomMap() == null || segment.getCustomMap().isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)segment.getCustomMap().get("UpsertCompactMergeTask.mergedSegments")))) continue;
            alreadyMergedSegments.addAll(List.of(StringUtils.split((String)((String)segment.getCustomMap().get("UpsertCompactMergeTask.mergedSegments")), (String)",")));
        }
        return alreadyMergedSegments;
    }

    public void validateTaskConfigs(TableConfig tableConfig, Schema schema, Map<String, String> taskConfigs) {
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (String)"%s only supports realtime tables!", (Object)"UpsertCompactMergeTask");
        Preconditions.checkState((boolean)tableConfig.isUpsertEnabled(), (String)"Upsert must be enabled for %s", (Object)"UpsertCompactMergeTask");
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        assert (upsertConfig != null);
        Preconditions.checkState((upsertConfig.getSnapshot() != Enablement.DISABLE ? 1 : 0) != 0, (String)"'snapshot' from UpsertConfig must not be 'DISABLE' for %s", (Object)"UpsertCompactMergeTask");
        if (taskConfigs.containsKey("bufferTimePeriod")) {
            TimeUtils.convertPeriodToMillis((String)taskConfigs.get("bufferTimePeriod"));
        }
        if (taskConfigs.containsKey("outputSegmentMaxSize")) {
            DataSizeUtils.toBytes((String)taskConfigs.get("outputSegmentMaxSize"));
        }
    }

    @VisibleForTesting
    protected String getDownloadUrl(List<SegmentMergerMetadata> segmentMergerMetadataList) {
        return StringUtils.join((Iterable)segmentMergerMetadataList.stream().map(x -> x.getSegmentZKMetadata().getDownloadUrl()).collect(Collectors.toList()), (String)",");
    }

    @VisibleForTesting
    protected String getSegmentCrcList(List<SegmentMergerMetadata> segmentMergerMetadataList) {
        return StringUtils.join((Iterable)segmentMergerMetadataList.stream().map(x -> String.valueOf(x.getSegmentZKMetadata().getCrc())).collect(Collectors.toList()), (String)",");
    }

    @VisibleForTesting
    protected long getMaxZKCreationTimeMillis(List<SegmentMergerMetadata> segmentMergerMetadataList) {
        return segmentMergerMetadataList.stream().mapToLong(x -> x.getSegmentZKMetadata().getCreationTime()).max().orElse(-1L);
    }

    public static class SegmentSelectionResult {
        private final Map<Integer, List<List<SegmentMergerMetadata>>> _segmentsForCompactMergeByPartition;
        private final List<String> _segmentsForDeletion;

        SegmentSelectionResult(Map<Integer, List<List<SegmentMergerMetadata>>> segmentsForCompactMergeByPartition, List<String> segmentsForDeletion) {
            this._segmentsForCompactMergeByPartition = segmentsForCompactMergeByPartition;
            this._segmentsForDeletion = segmentsForDeletion;
        }

        public Map<Integer, List<List<SegmentMergerMetadata>>> getSegmentsForCompactMergeByPartition() {
            return this._segmentsForCompactMergeByPartition;
        }

        public List<String> getSegmentsForDeletion() {
            return this._segmentsForDeletion;
        }
    }

    public static class SegmentMergerMetadata {
        private final SegmentZKMetadata _segmentZKMetadata;
        private final long _validDocIds;
        private final long _invalidDocIds;
        private final double _segmentSizeInBytes;

        SegmentMergerMetadata(SegmentZKMetadata segmentZKMetadata, long validDocIds, long invalidDocIds, double segmentSizeInBytes) {
            this._segmentZKMetadata = segmentZKMetadata;
            this._validDocIds = validDocIds;
            this._invalidDocIds = invalidDocIds;
            this._segmentSizeInBytes = segmentSizeInBytes;
        }

        public SegmentZKMetadata getSegmentZKMetadata() {
            return this._segmentZKMetadata;
        }

        public long getValidDocIds() {
            return this._validDocIds;
        }

        public long getInvalidDocIds() {
            return this._invalidDocIds;
        }

        public double getSegmentSizeInBytes() {
            return this._segmentSizeInBytes;
        }
    }
}

