/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.util.FieldMaskTree;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.pinot.shaded.com.google.common.base.CaseFormat;
import org.apache.pinot.shaded.com.google.common.base.Joiner;
import org.apache.pinot.shaded.com.google.common.base.Optional;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.com.google.common.base.Splitter;
import org.apache.pinot.shaded.com.google.common.primitives.Ints;

public final class FieldMaskUtil {
    private static final String FIELD_PATH_SEPARATOR = ",";
    private static final String FIELD_PATH_SEPARATOR_REGEX = ",";
    private static final String FIELD_SEPARATOR_REGEX = "\\.";

    private FieldMaskUtil() {
    }

    public static String toString(FieldMask fieldMask) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : fieldMask.getPathsList()) {
            if (value.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(value);
        }
        return result.toString();
    }

    public static FieldMask fromString(String value) {
        return FieldMaskUtil.fromStringList(Arrays.asList(value.split(",")));
    }

    public static FieldMask fromString(Class<? extends Message> type, String value) {
        return FieldMaskUtil.fromStringList(type, Arrays.asList(value.split(",")));
    }

    public static FieldMask fromStringList(Class<? extends Message> type, Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Internal.getDefaultInstance(type).getDescriptorForType(), paths);
    }

    public static FieldMask fromStringList(Descriptors.Descriptor descriptor2, Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Optional.of(descriptor2), paths);
    }

    public static FieldMask fromStringList(Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Optional.absent(), paths);
    }

    private static FieldMask fromStringList(Optional<Descriptors.Descriptor> descriptor2, Iterable<String> paths) {
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String path : paths) {
            if (path.isEmpty()) continue;
            if (descriptor2.isPresent() && !FieldMaskUtil.isValid(descriptor2.get(), path)) {
                throw new IllegalArgumentException(path + " is not a valid path for " + descriptor2.get().getFullName());
            }
            builder.addPaths(path);
        }
        return builder.build();
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> type, int ... fieldNumbers) {
        return FieldMaskUtil.fromFieldNumbers(type, Ints.asList(fieldNumbers));
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> type, Iterable<Integer> fieldNumbers) {
        Descriptors.Descriptor descriptor2 = Internal.getDefaultInstance(type).getDescriptorForType();
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (Integer fieldNumber : fieldNumbers) {
            Descriptors.FieldDescriptor field = descriptor2.findFieldByNumber(fieldNumber);
            Preconditions.checkArgument(field != null, String.format("%s is not a valid field number for %s.", fieldNumber, type));
            builder.addPaths(field.getName());
        }
        return builder.build();
    }

    public static String toJsonString(FieldMask fieldMask) {
        ArrayList<String> paths = new ArrayList<String>(fieldMask.getPathsCount());
        for (String path : fieldMask.getPathsList()) {
            if (path.isEmpty()) continue;
            paths.add(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, path));
        }
        return Joiner.on(",").join(paths);
    }

    public static FieldMask fromJsonString(String value) {
        Iterable<String> paths = Splitter.on(",").split(value);
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String path : paths) {
            if (path.isEmpty()) continue;
            builder.addPaths(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, path));
        }
        return builder.build();
    }

    public static boolean isValid(Class<? extends Message> type, FieldMask fieldMask) {
        Descriptors.Descriptor descriptor2 = Internal.getDefaultInstance(type).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor2, fieldMask);
    }

    public static boolean isValid(Descriptors.Descriptor descriptor2, FieldMask fieldMask) {
        for (String path : fieldMask.getPathsList()) {
            if (FieldMaskUtil.isValid(descriptor2, path)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Class<? extends Message> type, String path) {
        Descriptors.Descriptor descriptor2 = Internal.getDefaultInstance(type).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor2, path);
    }

    public static boolean isValid(@Nullable Descriptors.Descriptor descriptor2, String path) {
        String[] parts = path.split(FIELD_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return false;
        }
        for (String name : parts) {
            if (descriptor2 == null) {
                return false;
            }
            Descriptors.FieldDescriptor field = descriptor2.findFieldByName(name);
            if (field == null) {
                return false;
            }
            descriptor2 = !field.isRepeated() && field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? field.getMessageType() : null;
        }
        return true;
    }

    public static FieldMask normalize(FieldMask mask) {
        return new FieldMaskTree(mask).toFieldMask();
    }

    public static FieldMask union(FieldMask firstMask, FieldMask secondMask, FieldMask ... otherMasks) {
        FieldMaskTree maskTree = new FieldMaskTree(firstMask).mergeFromFieldMask(secondMask);
        for (FieldMask mask : otherMasks) {
            maskTree.mergeFromFieldMask(mask);
        }
        return maskTree.toFieldMask();
    }

    public static FieldMask subtract(FieldMask firstMask, FieldMask secondMask, FieldMask ... otherMasks) {
        FieldMaskTree maskTree = new FieldMaskTree(firstMask).removeFromFieldMask(secondMask);
        for (FieldMask mask : otherMasks) {
            maskTree.removeFromFieldMask(mask);
        }
        return maskTree.toFieldMask();
    }

    public static FieldMask intersection(FieldMask mask1, FieldMask mask2) {
        FieldMaskTree tree = new FieldMaskTree(mask1);
        FieldMaskTree result = new FieldMaskTree();
        for (String path : mask2.getPathsList()) {
            tree.intersectFieldPath(path, result);
        }
        return result.toFieldMask();
    }

    public static void merge(FieldMask mask, Message source2, Message.Builder destination, MergeOptions options) {
        new FieldMaskTree(mask).merge(source2, destination, options);
    }

    public static void merge(FieldMask mask, Message source2, Message.Builder destination) {
        FieldMaskUtil.merge(mask, source2, destination, new MergeOptions());
    }

    public static <P extends Message> P trim(FieldMask mask, P source2) {
        Message.Builder destination = source2.newBuilderForType();
        FieldMaskUtil.merge(mask, source2, destination);
        return (P)destination.build();
    }

    public static final class MergeOptions {
        private boolean replaceMessageFields = false;
        private boolean replaceRepeatedFields = false;
        private boolean replacePrimitiveFields = false;

        public boolean replaceMessageFields() {
            return this.replaceMessageFields;
        }

        public boolean replaceRepeatedFields() {
            return this.replaceRepeatedFields;
        }

        public boolean replacePrimitiveFields() {
            return this.replacePrimitiveFields;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplaceMessageFields(boolean value) {
            this.replaceMessageFields = value;
            return this;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplaceRepeatedFields(boolean value) {
            this.replaceRepeatedFields = value;
            return this;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplacePrimitiveFields(boolean value) {
            this.replacePrimitiveFields = value;
            return this;
        }
    }
}

