/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf.diff;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import io.confluent.kafka.schemaregistry.protobuf.diff.Context;
import io.confluent.kafka.schemaregistry.protobuf.diff.Difference;
import io.confluent.kafka.schemaregistry.protobuf.diff.FieldSchemaDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.OneOfDiff;
import io.confluent.kafka.schemaregistry.protobuf.diff.SchemaDiff;
import java.util.HashMap;
import java.util.HashSet;

public class MessageSchemaDiff {
    static void compare(Context ctx, MessageElement original, MessageElement update) {
        try (Context.SchemaScope schemaScope = ctx.enterSchema(original);){
            if (schemaScope != null) {
                HashMap<Integer, FieldElement> originalByTag = new HashMap<Integer, FieldElement>();
                for (FieldElement fieldElement : original.getFields()) {
                    originalByTag.put(fieldElement.getTag(), fieldElement);
                }
                HashMap<Integer, FieldElement> updateByTag = new HashMap<Integer, FieldElement>();
                for (FieldElement field : update.getFields()) {
                    updateByTag.put(field.getTag(), field);
                }
                HashMap<String, OneOfElement> hashMap = new HashMap<String, OneOfElement>();
                HashMap<String, OneOfElement> updateOneOfs = new HashMap<String, OneOfElement>();
                HashMap<Integer, FieldElement> originalOneOfsByTag = new HashMap<Integer, FieldElement>();
                for (OneOfElement oneOfElement : original.getOneOfs()) {
                    hashMap.put(oneOfElement.getName(), oneOfElement);
                    for (FieldElement fieldElement : oneOfElement.getFields()) {
                        originalOneOfsByTag.put(fieldElement.getTag(), fieldElement);
                    }
                }
                for (OneOfElement oneOfElement : update.getOneOfs()) {
                    updateOneOfs.put(oneOfElement.getName(), oneOfElement);
                    Context.PathScope pathScope = ctx.enterPath(oneOfElement.getName());
                    Throwable throwable = null;
                    try {
                        int numMoved = 0;
                        int numExisting = 0;
                        for (FieldElement oneOfField2 : oneOfElement.getFields()) {
                            FieldElement originalField = (FieldElement)originalByTag.remove(oneOfField2.getTag());
                            if (originalField != null) {
                                ++numMoved;
                                continue;
                            }
                            if (originalOneOfsByTag.get(oneOfField2.getTag()) == null) continue;
                            ++numExisting;
                        }
                        if (numMoved > 1) {
                            ctx.addDifference(Difference.Type.MULTIPLE_FIELDS_MOVED_TO_ONEOF);
                            continue;
                        }
                        if (numMoved != true || numExisting <= 0) continue;
                        ctx.addDifference(Difference.Type.FIELD_MOVED_TO_EXISTING_ONEOF);
                    }
                    catch (Throwable numMoved) {
                        Throwable throwable2 = numMoved;
                        throw numMoved;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (throwable != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable numMoved) {
                                throwable.addSuppressed(numMoved);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
                HashSet allOneOfs = new HashSet(hashMap.keySet());
                allOneOfs.addAll(updateOneOfs.keySet());
                for (String oneOfName : allOneOfs) {
                    Context.PathScope pathScope = ctx.enterPath(oneOfName);
                    Throwable numMoved = null;
                    try {
                        OneOfElement originalOneOf = (OneOfElement)hashMap.get(oneOfName);
                        OneOfElement updateOneOf = (OneOfElement)updateOneOfs.get(oneOfName);
                        if (updateOneOf == null) {
                            ctx.addDifference(Difference.Type.ONEOF_REMOVED);
                            continue;
                        }
                        if (originalOneOf == null) {
                            ctx.addDifference(Difference.Type.ONEOF_ADDED);
                            continue;
                        }
                        OneOfDiff.compare(ctx, originalOneOf, updateOneOf);
                    }
                    catch (Throwable throwable) {
                        numMoved = throwable;
                        throw throwable;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (numMoved != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable throwable) {
                                numMoved.addSuppressed(throwable);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
                HashSet hashSet = new HashSet(originalByTag.keySet());
                hashSet.addAll(updateByTag.keySet());
                for (Integer n : hashSet) {
                    Context.PathScope pathScope = ctx.enterPath(n.toString());
                    Throwable throwable = null;
                    try {
                        FieldElement originalField = (FieldElement)originalByTag.get(n);
                        FieldElement updateField = (FieldElement)updateByTag.get(n);
                        if (updateField == null) {
                            if (originalField.getLabel() == Field.Label.REQUIRED) {
                                ctx.addDifference(Difference.Type.REQUIRED_FIELD_REMOVED);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.FIELD_REMOVED);
                            continue;
                        }
                        if (originalField == null) {
                            if (updateField.getLabel() == Field.Label.REQUIRED) {
                                ctx.addDifference(Difference.Type.REQUIRED_FIELD_ADDED);
                                continue;
                            }
                            ctx.addDifference(Difference.Type.FIELD_ADDED);
                            continue;
                        }
                        FieldSchemaDiff.compare(ctx, originalField, updateField);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (pathScope == null) continue;
                        if (throwable != null) {
                            try {
                                pathScope.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        pathScope.close();
                    }
                }
            }
            SchemaDiff.compareTypeElements(ctx, original.getNestedTypes(), update.getNestedTypes());
        }
    }
}

