/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.protobuf;

import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufRecordExtractor;
import org.apache.pinot.plugin.inputformat.protobuf.ProtoBufUtils;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoBufMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoBufMessageDecoder.class);
    public static final String DESCRIPTOR_FILE_PATH = "descriptorFile";
    public static final String PROTO_CLASS_NAME = "protoClassName";
    private ProtoBufRecordExtractor _recordExtractor;
    private String _protoClassName;
    private Message.Builder _builder;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        Preconditions.checkState(props.containsKey(DESCRIPTOR_FILE_PATH), "Protocol Buffer schema descriptor file must be provided");
        this._protoClassName = props.getOrDefault(PROTO_CLASS_NAME, "");
        InputStream descriptorFileInputStream = ProtoBufUtils.getDescriptorFileInputStream(props.get(DESCRIPTOR_FILE_PATH));
        Descriptors.Descriptor descriptor2 = this.buildProtoBufDescriptor(descriptorFileInputStream);
        this._recordExtractor = new ProtoBufRecordExtractor();
        this._recordExtractor.init(fieldsToRead, null);
        DynamicMessage dynamicMessage = DynamicMessage.getDefaultInstance(descriptor2);
        this._builder = dynamicMessage.newBuilderForType();
    }

    private Descriptors.Descriptor buildProtoBufDescriptor(InputStream fin) throws IOException {
        try {
            DynamicSchema dynamicSchema = DynamicSchema.parseFrom(fin);
            if (!StringUtils.isEmpty(this._protoClassName)) {
                return dynamicSchema.getMessageDescriptor(this._protoClassName);
            }
            return dynamicSchema.getMessageDescriptor(dynamicSchema.getMessageTypes().toArray(new String[0])[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new IOException("Descriptor file validation failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericRow decode(byte[] payload, GenericRow destination) {
        Message message;
        try {
            this._builder.mergeFrom(payload);
            message = this._builder.build();
        }
        catch (Exception e) {
            LOGGER.error("Not able to decode protobuf message", e);
            GenericRow genericRow = destination;
            return genericRow;
        }
        finally {
            this._builder.clear();
        }
        this._recordExtractor.extract(message, destination);
        return destination;
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }
}

