/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaAvroSerializer
extends AbstractKafkaAvroSerializer
implements Serializer<Object> {
    public KafkaAvroSerializer() {
    }

    public KafkaAvroSerializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
    }

    public KafkaAvroSerializer(SchemaRegistryClient client, Map<String, ?> props) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.configure(this.serializerConfig(props));
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.configure(new KafkaAvroSerializerConfig(configs));
    }

    @Override
    public byte[] serialize(String topic, Object data) {
        return this.serialize(topic, (Headers)null, data);
    }

    @Override
    public byte[] serialize(String topic, Headers headers, Object record) {
        if (record == null) {
            return null;
        }
        AvroSchema schema = new AvroSchema(AvroSchemaUtils.getSchema(record, this.useSchemaReflection, this.avroReflectionAllowNull, this.avroUseLogicalTypeConverters, this.removeJavaProperties, true));
        return this.serializeImpl(this.getSubjectName(topic, this.isKey, record, schema), topic, headers, record, schema);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing serializer", e);
        }
    }
}

