/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.stats.QuantileDigest;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.QuantileDigestState;
import io.trino.operator.aggregation.state.QuantileDigestStateFactory;
import io.trino.operator.aggregation.state.QuantileDigestStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.type.QuantileDigestType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.MoreMath;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

@AggregationFunction(value="merge")
public final class MergeQuantileDigestFunction
extends SqlAggregationFunction {
    public static final MergeQuantileDigestFunction MERGE = new MergeQuantileDigestFunction();
    public static final String NAME = "merge";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "input", Type.class, QuantileDigestState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "combine", QuantileDigestState.class, QuantileDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MergeQuantileDigestFunction.class, "output", QuantileDigestStateSerializer.class, QuantileDigestState.class, BlockBuilder.class);
    private static final double COMPARISON_EPSILON = 1.0E-6;

    public MergeQuantileDigestFunction() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, "Merges the input quantile digests into a single quantile digest", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(true, TypeSignature.parametricType((String)"qdigest", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})));
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        QuantileDigestType outputType = (QuantileDigestType)boundSignature.getReturnType();
        Type valueType = outputType.getValueType();
        QuantileDigestStateSerializer stateSerializer = new QuantileDigestStateSerializer(valueType);
        return new AggregationMetadata(INPUT_FUNCTION.bindTo(outputType), Optional.empty(), Optional.of(COMBINE_FUNCTION), OUTPUT_FUNCTION.bindTo(stateSerializer), (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<QuantileDigestState>(QuantileDigestState.class, stateSerializer, new QuantileDigestStateFactory())));
    }

    @InputFunction
    public static void input(Type type, QuantileDigestState state, Block value, int index) {
        MergeQuantileDigestFunction.merge(state, new QuantileDigest(type.getSlice(value, index)));
    }

    @CombineFunction
    public static void combine(QuantileDigestState state, QuantileDigestState otherState) {
        MergeQuantileDigestFunction.merge(state, otherState.getQuantileDigest());
    }

    private static void merge(QuantileDigestState state, QuantileDigest input) {
        if (input == null) {
            return;
        }
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getMaxError(), input.getMaxError(), 1.0E-6), (String)"Cannot merge qdigests with different accuracies (%s vs. %s)", (Object)state.getQuantileDigest().getMaxError(), (Object)input.getMaxError());
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getAlpha(), input.getAlpha(), 1.0E-6), (String)"Cannot merge qdigests with different alpha values (%s vs. %s)", (Object)state.getQuantileDigest().getAlpha(), (Object)input.getAlpha());
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void output(QuantileDigestStateSerializer serializer, QuantileDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

