/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowAndLongStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowAndLongState> {
    private static final int SERIALIZED_SIZE = 32;

    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        if (state.isNotNull()) {
            long count = state.getLong();
            long overflow = state.getOverflow();
            long[] decimal = state.getDecimalArray();
            int offset = state.getDecimalArrayOffset();
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{count, overflow, decimal[offset], decimal[offset + 1]}));
        } else {
            out.appendNull();
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowAndLongState state) {
        if (!block.isNull(index)) {
            Slice slice = VarbinaryType.VARBINARY.getSlice(block, index);
            if (slice.length() != 32) {
                throw new IllegalStateException("Unexpected serialized state size: " + slice.length());
            }
            long count = slice.getLong(0);
            long overflow = slice.getLong(8);
            state.setLong(count);
            state.setOverflow(overflow);
            state.setNotNull();
            long[] decimal = state.getDecimalArray();
            int offset = state.getDecimalArrayOffset();
            decimal[offset] = slice.getLong(16);
            decimal[offset + 1] = slice.getLong(24);
        }
    }
}

